/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.bind;

import java.awt.Container;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tentackle.bind.AbstractBinder;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.StringHelper;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormContainer;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.bind.FormComponentBinder;
import org.tentackle.swing.bind.FormComponentBinding;
import org.tentackle.validate.ChangeableBindingEvaluator;
import org.tentackle.validate.MandatoryBindingEvaluator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.Validator;

public class DefaultFormComponentBinder
extends AbstractBinder
implements FormComponentBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFormComponentBinder.class);
    private final FormContainer form;
    private final TreeMap<String, FormComponent> eligibleComponents;
    private final Map<FormComponent, FormComponentBinding> boundComponents;
    private final Map<String, FormComponentBinding> boundPaths;
    private final List<Binding> dynamicMandatoryBindings;
    private boolean needMandatoryUpdate;
    private final List<Binding> dynamicChangeableBindings;
    private boolean needChangeableUpdate;

    public DefaultFormComponentBinder(FormContainer form) {
        this.form = form;
        this.eligibleComponents = new TreeMap();
        this.boundComponents = new HashMap<FormComponent, FormComponentBinding>();
        this.boundPaths = new TreeMap<String, FormComponentBinding>();
        this.dynamicMandatoryBindings = new ArrayList<Binding>();
        this.dynamicChangeableBindings = new ArrayList<Binding>();
    }

    @Override
    public FormContainer getFormContainer() {
        return this.form;
    }

    public void fireToView(Binding binding, Object parent, Object modelValue) throws BindingVetoException {
        ValidationContext validationContext;
        Object parentObject;
        super.fireToView(binding, parent, modelValue);
        if (this.needMandatoryUpdate) {
            for (Binding mandatoryBinding : this.dynamicMandatoryBindings) {
                boolean mandatory = false;
                for (Validator validator : mandatoryBinding.getValidators()) {
                    if (!(validator instanceof MandatoryBindingEvaluator) || (parentObject = mandatoryBinding.getParentObject()) == null) continue;
                    validationContext = new ValidationContext();
                    validationContext.setParentObject(parentObject);
                    validationContext.setObject(mandatoryBinding.getModelValue());
                    validationContext.setType(mandatoryBinding.getMember().getType());
                    if (!ValidationScopeFactory.getInstance().getMandatoryScope().appliesTo(validator.getConfiguredScopes(validationContext)) || !validator.isConditionValid(validationContext)) continue;
                    mandatory = true;
                    break;
                }
                mandatoryBinding.setMandatory(mandatory);
            }
            this.needMandatoryUpdate = false;
        }
        if (this.needChangeableUpdate) {
            for (Binding changeableBinding : this.dynamicChangeableBindings) {
                boolean changeable = false;
                for (Validator validator : changeableBinding.getValidators()) {
                    if (!(validator instanceof ChangeableBindingEvaluator) || (parentObject = changeableBinding.getParentObject()) == null) continue;
                    validationContext = new ValidationContext();
                    validationContext.setParentObject(parentObject);
                    validationContext.setObject(changeableBinding.getModelValue());
                    validationContext.setType(changeableBinding.getMember().getType());
                    if (!ValidationScopeFactory.getInstance().getChangeableScope().appliesTo(validator.getConfiguredScopes(validationContext)) || !validator.isConditionValid(validationContext)) continue;
                    changeable = true;
                    break;
                }
                changeableBinding.setChangeable(changeable);
            }
            this.needChangeableUpdate = false;
        }
    }

    public void fireToModel(Binding binding, Object parent, Object viewValue) throws BindingVetoException {
        super.fireToModel(binding, parent, viewValue);
        this.requestMandatoryUpdate();
        this.requestChangeableUpdate();
    }

    @Override
    public void requestMandatoryUpdate() {
        this.needMandatoryUpdate = true;
    }

    @Override
    public List<? extends Binding> getMandatoryBindings() {
        return this.dynamicMandatoryBindings;
    }

    @Override
    public void requestChangeableUpdate() {
        this.needChangeableUpdate = true;
    }

    @Override
    public List<? extends Binding> getChangeableBindings() {
        return this.dynamicChangeableBindings;
    }

    public int bindAllInherited() {
        return this.doBind(false, false);
    }

    @Override
    public int bindFormInherited() {
        return this.doBind(false, true);
    }

    @Override
    public int bindBindableInherited() {
        return this.doBind(true, false);
    }

    public int bind() {
        return this.doBind(true, true);
    }

    public void unbind() {
        for (FormComponent comp : this.boundComponents.keySet()) {
            comp.setBinding(null);
        }
        this.eligibleComponents.clear();
        this.boundComponents.clear();
        this.boundPaths.clear();
    }

    public Collection<? extends Binding> getBindings() {
        return this.boundComponents.values();
    }

    @Override
    public Collection<FormComponent> getBoundComponents() {
        return this.boundComponents.keySet();
    }

    @Override
    public Collection<FormComponent> getUnboundComponents() {
        ArrayList<FormComponent> unboundComponents = new ArrayList<FormComponent>();
        for (FormComponent component : this.eligibleComponents.values()) {
            if (component.getBinding() != null) continue;
            unboundComponents.add(component);
        }
        return unboundComponents;
    }

    public void assertAllBound() throws BindingException {
        Collection<FormComponent> unboundComponents = this.getUnboundComponents();
        if (!unboundComponents.isEmpty()) {
            for (FormComponent comp : unboundComponents) {
                LOGGER.severe("unbound component " + comp.getComponentPath(), new Object[0]);
            }
            throw new BindingException("unbound components in " + this.form.getClass().getName());
        }
    }

    public void addBinding(Binding binding) {
        if (binding instanceof FormComponentBinding) {
            FormComponentBinding oldBinding = this.boundPaths.put(binding.getMember().getMemberPath(), (FormComponentBinding)binding);
            if (oldBinding != null) {
                throw new BindingException(binding + ": binding path '" + binding.getMember().getMemberPath() + "' already bound to " + oldBinding.getFormComponent().getComponentPath());
            }
            oldBinding = this.boundComponents.put(((FormComponentBinding)binding).getFormComponent(), (FormComponentBinding)binding);
            if (oldBinding != null) {
                throw new BindingException(binding + ": component '" + ((FormComponentBinding)binding).getFormComponent().getComponentPath() + "' already bound to " + oldBinding.getMember().getMemberPath());
            }
            ((FormComponentBinding)binding).getFormComponent().setBinding((FormComponentBinding)binding);
            List validators = binding.getValidators();
            if (validators != null) {
                for (Validator validator : validators) {
                    if (validator instanceof MandatoryBindingEvaluator && ((MandatoryBindingEvaluator)validator).isMandatoryDynamic()) {
                        this.addMandatoryBinding(binding);
                        this.requestMandatoryUpdate();
                    }
                    if (!(validator instanceof ChangeableBindingEvaluator) || !((ChangeableBindingEvaluator)validator).isChangeableDynamic()) continue;
                    this.addChangeableBinding(binding);
                    this.requestChangeableUpdate();
                }
            }
        }
    }

    @Override
    public FormComponentBinding getBinding(FormComponent component) {
        return this.boundComponents.get(component);
    }

    @Override
    public FormComponentBinding getBinding(String bindingPath) {
        return this.boundPaths.get(bindingPath);
    }

    @Override
    public FormComponentBinding removeBinding(FormComponent component) {
        FormComponentBinding binding = this.boundComponents.remove(component);
        if (binding != null) {
            if (this.boundPaths.remove(binding.getMember().getMemberPath()) != binding) {
                throw new BindingException("Binding " + binding + " missing in path map");
            }
            binding.getFormComponent().setBinding(null);
        }
        return binding;
    }

    @Override
    public FormComponentBinding removeBinding(String bindingPath) {
        FormComponentBinding binding = this.boundPaths.remove(bindingPath);
        if (binding != null) {
            if (this.boundComponents.remove(binding.getFormComponent()) != binding) {
                throw new BindingException("Binding " + binding + " missing in component map");
            }
            binding.getFormComponent().setBinding(null);
        }
        return binding;
    }

    protected void addMandatoryBinding(Binding mandatoryBinding) {
        this.dynamicMandatoryBindings.add(mandatoryBinding);
    }

    protected void addChangeableBinding(Binding changeableBinding) {
        this.dynamicChangeableBindings.add(changeableBinding);
    }

    protected int doBind(BindingMember[] parents, String parentMemberPath, Class<?> parentClass, boolean declaredOnly) {
        if (parentMemberPath != null) {
            boolean found = false;
            for (String bindingPath : this.toCamelCase(parentMemberPath)) {
                String key;
                found = this.eligibleComponents.containsKey(bindingPath);
                if (!found && (key = this.eligibleComponents.higherKey(bindingPath)) != null && key.startsWith(bindingPath)) {
                    found = true;
                }
                if (found) break;
            }
            if (!found) {
                return 0;
            }
        }
        int count = 0;
        for (BindableElement element : FormUtilities.getInstance().getBindingFactory().getBindableCache().getBindableMap(parentClass, declaredOnly).values()) {
            String fieldMemberName = StringHelper.firstToLower((String)element.getCamelName());
            String fieldMemberPath = (parentMemberPath == null ? "" : parentMemberPath + ".") + fieldMemberName;
            BindingMember[] fieldParents = new BindingMember[parents == null ? 1 : parents.length + 1];
            BindingMember fieldMember = FormUtilities.getInstance().getBindingFactory().createBindingMember(parentClass, parents == null ? null : parents[parents.length - 1], fieldMemberName, fieldMemberPath, element);
            if (parents != null) {
                System.arraycopy(parents, 0, fieldParents, 0, parents.length);
                fieldParents[parents.length] = fieldMember;
            } else {
                fieldParents[0] = fieldMember;
            }
            try {
                FormComponent component;
                if (element.getField() != null && !element.getField().isAccessible()) {
                    element.getField().setAccessible(true);
                }
                if ((component = this.findComponent(fieldMemberPath)) != null) {
                    FormComponentBinding binding = FormUtilities.getInstance().getBindingFactory().createFormComponentBinding(this, parents, fieldMember, component, element.getBindingOptions());
                    this.addBinding(binding);
                    ++count;
                }
                count += this.doBind(fieldParents, fieldMemberPath, fieldMember.getType(), declaredOnly);
            }
            catch (Exception ex) {
                throw new BindingException("binding " + fieldMemberPath + " failed", (Throwable)ex);
            }
        }
        return count;
    }

    private String[] toCamelCase(String bindingPath) {
        StringTokenizer stok = new StringTokenizer(bindingPath, ".");
        StringBuilder buf = new StringBuilder();
        StringBuilder omitBuf = new StringBuilder();
        int omitCount = 0;
        String lastCamelName = null;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (buf.length() == 0) {
                buf.append(token);
                if (omitCount >= 0) {
                    omitBuf.append(token);
                    ++omitCount;
                }
            } else {
                token = StringHelper.firstToUpper((String)token);
                buf.append(token);
                if (omitCount >= 0) {
                    if (lastCamelName == null) {
                        omitBuf.append(token);
                        ++omitCount;
                    } else if (token.toLowerCase().startsWith(lastCamelName)) {
                        omitBuf.append(token.substring(lastCamelName.length()));
                        ++omitCount;
                    } else {
                        omitCount = -1;
                    }
                }
            }
            lastCamelName = token.toLowerCase();
        }
        if (omitCount > 1 && omitCount < 4) {
            return new String[]{buf.toString(), omitBuf.toString()};
        }
        return new String[]{buf.toString()};
    }

    private FormComponent findComponent(String bindingPath) {
        FormComponent comp = null;
        for (String path : this.toCamelCase(bindingPath)) {
            LOGGER.finer("checking {0} for matching component", new Object[]{path});
            comp = this.eligibleComponents.get(path);
            if (comp != null) break;
        }
        return comp;
    }

    private Object getFormObject(Container container, Field formField) {
        try {
            if (!formField.isAccessible()) {
                formField.setAccessible(true);
            }
            return formField.get(container);
        }
        catch (Exception ex) {
            throw new BindingException("cannot access " + formField + " in container " + container.getClass().getName(), (Throwable)ex);
        }
    }

    private void addEligibleComponents(Container container, String containerPath, Set<Container> checkedContainers, boolean declaredOnly) {
        if ((!(container instanceof FormContainer) || ((FormContainer)((Object)container)).isBindable()) && checkedContainers.add(container)) {
            LOGGER.finer("checking {0} for eligible components", new Object[]{containerPath});
            for (Field field : declaredOnly ? container.getClass().getDeclaredFields() : ReflectionHelper.getAllFields(container.getClass(), (Class[])new Class[]{FormComponent.class, FormContainer.class}, (boolean)false, null, (boolean)true)) {
                Container subContainer;
                if (FormComponent.class.isAssignableFrom(field.getType())) {
                    FormComponent oldComponent;
                    FormComponent component = (FormComponent)this.getFormObject(container, field);
                    if (component == null || !component.isBindable()) continue;
                    String componentPath = containerPath + "." + field.getName();
                    component.setComponentPath(componentPath);
                    String bindingPath = component.getBindingPath();
                    if (bindingPath == null) {
                        bindingPath = field.getName();
                        bindingPath = StringHelper.removeTrailingText((String)bindingPath, (String)"Field");
                        bindingPath = StringHelper.removeTrailingText((String)bindingPath, (String)"Bean");
                        bindingPath = StringHelper.removeTrailingText((String)bindingPath, (String)"Comp");
                        bindingPath = StringHelper.removeTrailingText((String)bindingPath, (String)"Component");
                    }
                    if ((oldComponent = this.eligibleComponents.put(bindingPath, component)) != null) {
                        throw new BindingException("binding path '" + bindingPath + "' already provided by " + oldComponent.getComponentPath());
                    }
                    LOGGER.finer("added {0}:{1} to eligible components", new Object[]{componentPath, bindingPath});
                    continue;
                }
                if (!Container.class.isAssignableFrom(field.getType()) || (subContainer = (Container)this.getFormObject(container, field)) == null) continue;
                this.addEligibleComponents(subContainer, containerPath + "." + field.getName(), checkedContainers, declaredOnly);
            }
        }
    }

    private int doBind(boolean declaredBindablesOnly, boolean declaredComponentsOnly) {
        this.addEligibleComponents((Container)((Object)this.form), this.form.getClass().getName(), new HashSet<Container>(), declaredComponentsOnly);
        if (LOGGER.isFineLoggable()) {
            StringBuilder buf = new StringBuilder();
            buf.append("--------- eligible components: ----------\n");
            for (Map.Entry<String, FormComponent> entry : this.eligibleComponents.entrySet()) {
                buf.append(entry.getKey());
                buf.append(" : ");
                buf.append(entry.getValue().getComponentPath());
                buf.append("\n");
            }
            buf.append("-----------------------------------------\n");
            LOGGER.fine(buf.toString(), new Object[0]);
        }
        return this.doBind(null, null, this.form.getClass(), declaredBindablesOnly);
    }
}

