/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.bind;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.AbstractFractionNumberFormField;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.bind.AbstractFormBinding;
import org.tentackle.swing.bind.FormComponentBinder;
import org.tentackle.swing.bind.FormComponentBinding;
import org.tentackle.validate.ChangeableBindingEvaluator;
import org.tentackle.validate.MandatoryBindingEvaluator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.Validator;

public class DefaultFormComponentBinding
extends AbstractFormBinding
implements FormComponentBinding {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFormComponentBinding.class);
    private List<Validator> fixedMandatoryValidators;
    private List<Validator> fixedChangeableValidators;
    private FormComponent component;

    public DefaultFormComponentBinding(FormComponentBinder binder, BindingMember[] parents, BindingMember member, FormComponent component, String componentOptions) {
        super(binder, parents, member);
        if (component == null) {
            throw new NullPointerException("formComponent must not be null");
        }
        this.component = component;
        this.updateComponentName();
        this.processOptions(componentOptions);
        this.determineValidators();
        this.verifyType();
    }

    public FormComponentBinder getBinder() {
        return (FormComponentBinder)super.getBinder();
    }

    @Override
    public FormComponent getFormComponent() {
        return this.component;
    }

    public Object getViewValue() {
        return this.component.getFormValue();
    }

    public void fireToView(Object parent, Object modelValue) throws BindingVetoException {
        ValidationContext validationContext;
        super.fireToView(parent, modelValue);
        if (this.fixedMandatoryValidators != null && !this.fixedMandatoryValidators.isEmpty()) {
            boolean mandatory = false;
            for (Validator validator : this.fixedMandatoryValidators) {
                if (parent == null) continue;
                validationContext = new ValidationContext();
                validationContext.setParentObject(parent);
                validationContext.setObject(modelValue);
                validationContext.setType(this.getMember().getType());
                if (!ValidationScopeFactory.getInstance().getMandatoryScope().appliesTo(validator.getConfiguredScopes(validationContext)) || !validator.isConditionValid(validationContext) || !((MandatoryBindingEvaluator)validator).isMandatory(validationContext)) continue;
                mandatory = true;
                break;
            }
            this.setMandatory(mandatory);
        }
        if (this.fixedChangeableValidators != null && !this.fixedChangeableValidators.isEmpty()) {
            boolean changeable = false;
            for (Validator validator : this.fixedChangeableValidators) {
                if (parent == null) continue;
                validationContext = new ValidationContext();
                validationContext.setParentObject(parent);
                validationContext.setObject(modelValue);
                validationContext.setType(this.getMember().getType());
                if (!ValidationScopeFactory.getInstance().getChangeableScope().appliesTo(validator.getConfiguredScopes(validationContext)) || !validator.isConditionValid(validationContext) || !((ChangeableBindingEvaluator)validator).isChangeable(validationContext)) continue;
                changeable = true;
                break;
            }
            this.setChangeable(changeable);
        }
    }

    protected void determineValidators() {
        super.determineValidators();
        List validators = this.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                if (validator instanceof MandatoryBindingEvaluator && !((MandatoryBindingEvaluator)validator).isMandatoryDynamic()) {
                    if (this.fixedMandatoryValidators == null) {
                        this.fixedMandatoryValidators = new ArrayList<Validator>();
                    }
                    this.fixedMandatoryValidators.add(validator);
                }
                if (!(validator instanceof ChangeableBindingEvaluator) || ((ChangeableBindingEvaluator)validator).isChangeableDynamic()) continue;
                if (this.fixedChangeableValidators == null) {
                    this.fixedChangeableValidators = new ArrayList<Validator>();
                }
                this.fixedChangeableValidators.add(validator);
            }
        }
    }

    protected Class<?> getViewType() {
        try {
            Class<?> type = this.component.getClass().getMethod("getFormValue", new Class[0]).getReturnType();
            for (Method method : this.component.getClass().getMethods()) {
                Class<?>[] types;
                if (!method.getName().equals("setFormValue") || (types = method.getParameterTypes()).length != 1 || !type.isAssignableFrom(types[0])) continue;
                type = types[0];
            }
            return type;
        }
        catch (NoSuchMethodException ex) {
            throw new BindingException("cannot determine component's type", (Throwable)ex);
        }
    }

    protected void updateComponentName() {
        if (this.component instanceof Component && ((Component)((Object)this.component)).getName() == null) {
            StringBuilder buf = new StringBuilder(this.getMember().getMemberPath());
            for (Container parent = ((Component)((Object)this.component)).getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getName() == null) continue;
                buf.insert(0, parent.getName() + "/");
            }
            ((Component)((Object)this.component)).setName(buf.toString());
            LOGGER.fine("{0}.setName(\"{1}\")", new Object[]{this.component.getComponentPath(), ((Component)((Object)this.component)).getName()});
        }
    }

    protected void processOptions(String componentOptions) {
        if (componentOptions != null && this.getFormComponent() instanceof FormFieldComponent) {
            FormFieldComponent comp = (FormFieldComponent)this.getFormComponent();
            StringTokenizer stok = new StringTokenizer(componentOptions.toUpperCase(), ",");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                if (this.processOption(comp, token)) continue;
                throw new BindingException("unsupported @Bindable option \"" + token + "\") in " + this.getMember());
            }
        }
    }

    protected boolean processOption(FormFieldComponent comp, String option) {
        boolean processed = false;
        if ("UC".equals(option)) {
            comp.setConvert('^');
            processed = true;
        } else if ("LC".equals(option)) {
            comp.setConvert('v');
            processed = true;
        } else if ("AUTOSELECT".equals(option)) {
            comp.setAutoSelect(true);
            processed = true;
        } else if ("-AUTOSELECT".equals(option)) {
            comp.setAutoSelect(false);
            processed = true;
        } else if ("UNSIGNED".equals(option)) {
            processed = true;
        } else if ("-UNSIGNED".equals(option)) {
            processed = true;
        } else if ("UTC".equals(option)) {
            processed = true;
        } else {
            if (option.startsWith("MAXCOL=")) {
                try {
                    comp.setMaxColumns(Integer.parseInt(option.substring("MAXCOL".length() + 1)));
                    processed = true;
                }
                catch (NumberFormatException ex) {
                    throw new BindingException("invalid MAXCOL @Bindable option \"" + option + "\") in " + this.getMember(), (Throwable)ex);
                }
            }
            if (option.startsWith("COL=")) {
                try {
                    comp.setColumns(Integer.parseInt(option.substring("COL".length() + 1)));
                    processed = true;
                }
                catch (NumberFormatException ex) {
                    throw new BindingException("invalid COL @Bindable option \"" + option + "\") in " + this.getMember(), (Throwable)ex);
                }
            }
            if (option.startsWith("SCALE=")) {
                try {
                    if (!(comp instanceof AbstractFractionNumberFormField)) {
                        throw new BindingException("cannot apply SCALE @Bindable option \"" + option + "\") in " + this.getMember() + ": not an AbstractFractionNumberFormField");
                    }
                    ((AbstractFractionNumberFormField)comp).setScale(Integer.parseInt(option.substring("SCALE".length() + 1)));
                    processed = true;
                }
                catch (NumberFormatException ex) {
                    throw new BindingException("invalid SCALE @Bindable option \"" + option + "\") in " + this.getMember(), (Throwable)ex);
                }
            }
        }
        return processed;
    }

    public void setMandatory(boolean mandatory) {
        this.component.setMandatory(mandatory);
    }

    public boolean isMandatory() {
        return this.component.isMandatory();
    }

    public void setChangeable(boolean changeable) {
        this.component.setChangeable(changeable);
    }

    public boolean isChangeable() {
        return this.component.isChangeable();
    }

    protected Object getBoundRootObject() {
        return this.getBinder().getFormContainer();
    }

    protected boolean isValidationRequired() {
        return true;
    }

    protected String viewComponentToString() {
        return this.component.getComponentPath();
    }

    protected void updateView(Object value) {
        this.component.setFormValue(value);
    }
}

