/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.bind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tentackle.bind.AbstractBinder;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.StringHelper;
import org.tentackle.swing.BindableTableModel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.bind.FormTableBinder;
import org.tentackle.swing.bind.FormTableBinding;

public class DefaultFormTableBinder
extends AbstractBinder
implements FormTableBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFormTableBinder.class);
    private final BindableTableModel<?> model;
    private final Map<Integer, FormTableBinding> boundColumns;
    private final Map<String, FormTableBinding> boundPaths;

    public DefaultFormTableBinder(BindableTableModel<?> model) {
        this.model = model;
        this.boundColumns = new HashMap<Integer, FormTableBinding>();
        this.boundPaths = new TreeMap<String, FormTableBinding>();
    }

    @Override
    public BindableTableModel<?> getModel() {
        return this.model;
    }

    public int bindAllInherited() {
        return this.doBind(null, null, this.getModel().getBindingRootClass(), false);
    }

    public int bind() {
        return this.doBind(null, null, this.getModel().getBindingRootClass(), true);
    }

    public void unbind() {
        this.boundColumns.clear();
        this.boundPaths.clear();
    }

    public Collection<? extends Binding> getBindings() {
        return this.boundColumns.values();
    }

    @Override
    public Integer[] getBoundColumns() {
        return this.boundColumns.keySet().toArray(new Integer[0]);
    }

    @Override
    public Integer[] getUnboundColumns() {
        int columnCount = this.model.getColumnCount();
        ArrayList<Integer> unboundColumns = new ArrayList<Integer>();
        for (int mColumn = 0; mColumn < columnCount; ++mColumn) {
            if (this.boundColumns.containsKey(mColumn)) continue;
            unboundColumns.add(mColumn);
        }
        return unboundColumns.toArray(new Integer[0]);
    }

    public void assertAllBound() throws BindingException {
        Integer[] unboundColumns = this.getUnboundColumns();
        if (unboundColumns.length > 0) {
            for (Integer mColumn : unboundColumns) {
                LOGGER.severe("unbound column " + mColumn + " in table " + this.model, new Object[0]);
            }
            throw new BindingException("unbound columns in " + this.model);
        }
    }

    public void addBinding(Binding binding) {
        if (binding instanceof FormTableBinding) {
            FormTableBinding oldBinding = this.boundPaths.put(binding.getMember().getMemberPath(), (FormTableBinding)binding);
            if (oldBinding != null) {
                throw new BindingException(binding + ": binding path '" + binding.getMember().getMemberPath() + "' already bound to column " + oldBinding.getColumn());
            }
            oldBinding = this.boundColumns.put(((FormTableBinding)binding).getColumn(), (FormTableBinding)binding);
            if (oldBinding != null) {
                throw new BindingException(binding + ": column '" + ((FormTableBinding)binding).getColumn() + "' already bound to " + oldBinding.getMember().getMemberPath());
            }
        }
    }

    @Override
    public FormTableBinding getBinding(int mColumn) {
        return this.boundColumns.get(mColumn);
    }

    @Override
    public FormTableBinding getBinding(String bindingPath) {
        return this.boundPaths.get(bindingPath);
    }

    @Override
    public FormTableBinding removeBinding(int mColumn) {
        FormTableBinding binding = this.boundColumns.remove(mColumn);
        if (binding != null && this.boundPaths.remove(binding.getMember().getMemberPath()) != binding) {
            throw new BindingException("Binding " + binding + " missing in path map");
        }
        return binding;
    }

    @Override
    public FormTableBinding removeBinding(String bindingPath) {
        FormTableBinding binding = this.boundPaths.remove(bindingPath);
        if (binding != null && this.boundColumns.remove(binding.getColumn()) != binding) {
            throw new BindingException("Binding " + binding + " missing in component map");
        }
        return binding;
    }

    protected int doBind(BindingMember[] parents, String parentMemberPath, Class<?> parentClass, boolean declaredOnly) {
        if (parentMemberPath != null) {
            boolean found = false;
            for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                String bindingPath = this.getModel().getBindingPath(i);
                if (bindingPath == null || !bindingPath.startsWith(parentMemberPath)) continue;
                found = true;
                break;
            }
            if (!found) {
                return 0;
            }
        }
        int count = 0;
        for (BindableElement element : FormUtilities.getInstance().getBindingFactory().getBindableCache().getBindableMap(parentClass, declaredOnly).values()) {
            String fieldMemberName = StringHelper.firstToLower((String)element.getCamelName());
            String fieldMemberPath = (parentMemberPath == null ? "" : parentMemberPath + ".") + fieldMemberName;
            BindingMember[] fieldParents = new BindingMember[parents == null ? 1 : parents.length + 1];
            BindingMember fieldMember = FormUtilities.getInstance().getBindingFactory().createBindingMember(parentClass, parents == null ? null : parents[parents.length - 1], fieldMemberName, fieldMemberPath, element);
            if (parents != null) {
                System.arraycopy(parents, 0, fieldParents, 0, parents.length);
                fieldParents[parents.length] = fieldMember;
            } else {
                fieldParents[0] = fieldMember;
            }
            try {
                if (element.getField() != null && !element.getField().isAccessible()) {
                    element.getField().setAccessible(true);
                }
                for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                    String bindingPath = this.getModel().getBindingPath(i);
                    if (bindingPath == null || !bindingPath.equals(fieldMemberPath)) continue;
                    this.addBinding(FormUtilities.getInstance().getBindingFactory().createFormTableBinding(this, parents, fieldMember, i, element.getBindingOptions()));
                    ++count;
                }
                count += this.doBind(fieldParents, fieldMemberPath, fieldMember.getType(), declaredOnly);
            }
            catch (Exception ex) {
                throw new BindingException("binding " + fieldMemberPath + " failed", (Throwable)ex);
            }
        }
        return count;
    }
}

