/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.plaf.DefaultIconProvider;
import org.tentackle.swing.plaf.IconProvider;
import org.tentackle.swing.plaf.PlafUtilities$Singleton;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

@Service(value=PlafUtilities.class)
public class PlafUtilities {
    public static final String TENTACKLE_ICONREALM = "tentackle";
    private static final Logger LOGGER = LoggerFactory.getLogger(PlafUtilities.class);
    private Color alarmColor;
    private Color alarmBackgroundColor;
    private Color listSelectedForegroundColor;
    private Color listSelectedBackgroundColor;
    private Color listUnselectedForegroundColor;
    private Color listSelectedDisabledForegroundColor;
    private Color listUnselectedDisabledForegroundColor;
    private Color tableForegroundColor;
    private Color tableBackgroundColor;
    private Color tableFocusCellForegroundColor;
    private Color tableFocusCellBackgroundColor;
    private Color tableSelectionForegroundColor;
    private Color tableSelectionBackgroundColor;
    private Color dropFieldActiveColor;
    private Color dropFieldInactiveColor;
    private Color tableEditCellBorderColor;
    private Color textFieldBackgroundColor;
    private Color textFieldInactiveBackgroundColor;
    private final Map<String, IconProvider> iconProviderMap = new TreeMap<String, IconProvider>();
    private Map<String, ImageIcon> iconMap;

    public static PlafUtilities getInstance() {
        return PlafUtilities$Singleton.INSTANCE;
    }

    public PlafUtilities() {
        this.triggerLookAndFeelUpdated();
        this.addIconProvider(new DefaultIconProvider());
    }

    public void installLookAndFeel(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            String name = clazzName.substring(clazzName.lastIndexOf(46) + 1, clazzName.length() - 11);
            name = (String)clazz.getMethod("get" + name + "Name", new Class[0]).invoke(null, new Object[0]);
            UIManager.installLookAndFeel(name, clazzName);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.fine("plaf {0} not in classpath -- not loaded", new Object[]{clazzName});
        }
        catch (Exception e) {
            LOGGER.severe("cannot install plaf " + clazzName, (Throwable)e);
        }
    }

    public void installTentackleLookAndFeels() {
        for (String plafName : ServiceFactory.getServiceFinder().findServiceConfigurations(TentackleLookAndFeel.class.getName()).keySet()) {
            this.installLookAndFeel(plafName);
        }
    }

    public UIManager.LookAndFeelInfo[] getInstalledTentackleLookAndFeels() {
        ArrayList<UIManager.LookAndFeelInfo> tentackleLAFs = new ArrayList<UIManager.LookAndFeelInfo>();
        for (UIManager.LookAndFeelInfo lafInfo : UIManager.getInstalledLookAndFeels()) {
            try {
                if (!TentackleLookAndFeel.class.isAssignableFrom(Class.forName(lafInfo.getClassName()))) continue;
                tentackleLAFs.add(lafInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return tentackleLAFs.toArray(new UIManager.LookAndFeelInfo[tentackleLAFs.size()]);
    }

    public void setFocusAnimated(boolean flag) {
        LookAndFeel plaf = UIManager.getLookAndFeel();
        if (plaf instanceof TentackleLookAndFeel) {
            ((TentackleLookAndFeel)((Object)plaf)).setFocusAnimated(flag);
        }
    }

    public boolean isFocusAnimated() {
        LookAndFeel plaf = UIManager.getLookAndFeel();
        return plaf instanceof TentackleLookAndFeel ? ((TentackleLookAndFeel)((Object)plaf)).isFocusAnimated() : false;
    }

    public Color getAlarmColor() {
        return this.alarmColor;
    }

    public void setAlarmColor(Color aAlarmColor) {
        this.alarmColor = aAlarmColor;
    }

    public Color getAlarmBackgroundColor() {
        return this.alarmBackgroundColor;
    }

    public void setAlarmBackgroundColor(Color aAlarmBackgroundColor) {
        this.alarmBackgroundColor = aAlarmBackgroundColor;
    }

    public Color getListSelectedForegroundColor() {
        return this.listSelectedForegroundColor;
    }

    public void setListSelectedForegroundColor(Color aListSelectedForegroundColor) {
        this.listSelectedForegroundColor = aListSelectedForegroundColor;
    }

    public Color getListSelectedBackgroundColor() {
        return this.listSelectedBackgroundColor;
    }

    public void setListSelectedBackgroundColor(Color aListSelectedBackgroundColor) {
        this.listSelectedBackgroundColor = aListSelectedBackgroundColor;
    }

    public Color getListUnselectedForegroundColor() {
        return this.listUnselectedForegroundColor;
    }

    public void setListUnselectedForegroundColor(Color aListUnselectedForegroundColor) {
        this.listUnselectedForegroundColor = aListUnselectedForegroundColor;
    }

    public Color getListSelectedDisabledForegroundColor() {
        return this.listSelectedDisabledForegroundColor;
    }

    public void setListSelectedDisabledForegroundColor(Color aListSelectedDisabledForegroundColor) {
        this.listSelectedDisabledForegroundColor = aListSelectedDisabledForegroundColor;
    }

    public Color getListUnselectedDisabledForegroundColor() {
        return this.listUnselectedDisabledForegroundColor;
    }

    public void setListUnselectedDisabledForegroundColor(Color aListUnselectedDisabledForegroundColor) {
        this.listUnselectedDisabledForegroundColor = aListUnselectedDisabledForegroundColor;
    }

    public Color getTableForegroundColor() {
        return this.tableForegroundColor;
    }

    public void setTableForegroundColor(Color aTableForegroundColor) {
        this.tableForegroundColor = aTableForegroundColor;
    }

    public Color getTableBackgroundColor() {
        return this.tableBackgroundColor;
    }

    public void setTableBackgroundColor(Color aTableBackgroundColor) {
        this.tableBackgroundColor = aTableBackgroundColor;
    }

    public Color getTableFocusCellForegroundColor() {
        return this.tableFocusCellForegroundColor;
    }

    public void setTableFocusCellForegroundColor(Color aTableFocusCellForegroundColor) {
        this.tableFocusCellForegroundColor = aTableFocusCellForegroundColor;
    }

    public Color getTableFocusCellBackgroundColor() {
        return this.tableFocusCellBackgroundColor;
    }

    public void setTableFocusCellBackgroundColor(Color aTableFocusCellBackgroundColor) {
        this.tableFocusCellBackgroundColor = aTableFocusCellBackgroundColor;
    }

    public Color getTableSelectionForegroundColor() {
        return this.tableSelectionForegroundColor;
    }

    public void setTableSelectionForegroundColor(Color aTableSelectionForegroundColor) {
        this.tableSelectionForegroundColor = aTableSelectionForegroundColor;
    }

    public Color getTableSelectionBackgroundColor() {
        return this.tableSelectionBackgroundColor;
    }

    public void setTableSelectionBackgroundColor(Color aTableSelectionBackgroundColor) {
        this.tableSelectionBackgroundColor = aTableSelectionBackgroundColor;
    }

    public Color getDropFieldActiveColor() {
        return this.dropFieldActiveColor;
    }

    public void setDropFieldActiveColor(Color aDropFieldActiveColor) {
        this.dropFieldActiveColor = aDropFieldActiveColor;
    }

    public Color getDropFieldInactiveColor() {
        return this.dropFieldInactiveColor;
    }

    public void setDropFieldInactiveColor(Color aDropFieldInactiveColor) {
        this.dropFieldInactiveColor = aDropFieldInactiveColor;
    }

    public Color getTableEditCellBorderColor() {
        return this.tableEditCellBorderColor;
    }

    public void setTableEditCellBorderColor(Color aTableEditCellBorderColor) {
        this.tableEditCellBorderColor = aTableEditCellBorderColor;
    }

    public Color getTextFieldBackgroundColor() {
        return this.textFieldBackgroundColor;
    }

    public void setTextFieldBackgroundColor(Color aTextFieldBackgroundColor) {
        this.textFieldBackgroundColor = aTextFieldBackgroundColor;
    }

    public Color getTextFieldInactiveBackgroundColor() {
        return this.textFieldInactiveBackgroundColor;
    }

    public void setTextFieldInactiveBackgroundColor(Color aTextFieldInactiveBackgroundColor) {
        this.textFieldInactiveBackgroundColor = aTextFieldInactiveBackgroundColor;
    }

    public IconProvider addIconProvider(IconProvider iconProvider) {
        return this.iconProviderMap.put(iconProvider.getRealm(), iconProvider);
    }

    public IconProvider removeIconProvider(String realm) {
        return this.iconProviderMap.remove(realm);
    }

    public ImageIcon getIcon(String realm, String name) throws MissingResourceException {
        ImageIcon icon = null;
        String key = realm + "/" + name;
        if (this.iconMap == null) {
            this.iconMap = new TreeMap<String, ImageIcon>();
        } else {
            icon = this.iconMap.get(key);
        }
        if (icon == null) {
            IconProvider iconProvider = this.iconProviderMap.get(realm);
            if (iconProvider == null) {
                throw new MissingResourceException("no icon provider for realm '" + realm + "'", PlafUtilities.class.getName(), realm);
            }
            icon = iconProvider.loadImageIcon(UIManager.getLookAndFeel(), name);
            this.iconMap.put(key, icon);
        }
        return icon;
    }

    public ImageIcon getIcon(String name) throws MissingResourceException {
        return this.getIcon(TENTACKLE_ICONREALM, name);
    }

    public Object getUIManagerDefault(String ... keys) {
        for (String key : keys) {
            Object resource = UIManager.getDefaults().get(key);
            if (resource == null) continue;
            return resource;
        }
        throw new GUIRuntimeException("missing resource " + keys[0]);
    }

    public void triggerLookAndFeelUpdated() {
        try {
            this.setTextFieldBackgroundColor(new Color(((Color)this.getUIManagerDefault("TextField.background")).getRGB()));
            this.setTextFieldInactiveBackgroundColor(new Color(((Color)this.getUIManagerDefault("TextField.inactiveBackground", "TextField.background")).getRGB()));
            this.setAlarmColor(Color.red);
            this.setAlarmBackgroundColor(new Color(255, 192, 192));
            this.setListSelectedForegroundColor(new Color(((Color)this.getUIManagerDefault("List.selectionForeground", "List[Selected].textForeground")).getRGB()));
            this.setListSelectedBackgroundColor(new Color(((Color)this.getUIManagerDefault("List.selectionBackground", "List[Selected].textBackground")).getRGB()));
            this.setListUnselectedForegroundColor(new Color(((Color)this.getUIManagerDefault("List.foreground")).getRGB()));
            this.setListUnselectedDisabledForegroundColor(new Color(((Color)this.getUIManagerDefault("TextField.inactiveForeground", "List[Disabled].textForeground")).getRGB()));
            Color color1 = this.getListSelectedForegroundColor();
            Color color2 = this.getListSelectedBackgroundColor();
            this.setListSelectedDisabledForegroundColor(new Color(color1.getRed() + color2.getRed() >> 1, color1.getGreen() + color2.getGreen() >> 1, color1.getBlue() + color2.getBlue() >> 1));
            this.setTableForegroundColor(new Color(((Color)this.getUIManagerDefault("Table.foreground")).getRGB()));
            this.setTableBackgroundColor(new Color(((Color)this.getUIManagerDefault("Table.background")).getRGB()));
            this.setTableFocusCellForegroundColor(new Color(((Color)this.getUIManagerDefault("Table.focusCellForeground", "Table[Enabled+Selected].textForeground")).getRGB()));
            this.setTableFocusCellBackgroundColor(new Color(((Color)this.getUIManagerDefault("Table.focusCellBackground", "Table[Enabled+Selected].textBackground")).getRGB()));
            this.setTableSelectionForegroundColor(new Color(((Color)this.getUIManagerDefault("Table.selectionForeground", "Table.foreground")).getRGB()));
            this.setTableSelectionBackgroundColor(new Color(((Color)this.getUIManagerDefault("Table.selectionBackground", "Table[Disabled+Selected].textBackground")).getRGB()));
            color1 = new Color(((Color)this.getUIManagerDefault("TextField.selectionBackground", "TextField[Selected].textForeground")).getRGB());
            color2 = new Color(((Color)this.getUIManagerDefault("TextField.inactiveBackground", "TextField.background")).getRGB());
            this.setDropFieldActiveColor(new Color(color1.getRed() + color2.getRed() >> 1, color1.getGreen() + color2.getGreen() >> 1, color1.getBlue() + color2.getBlue() >> 1));
            float[] hsb = new float[3];
            Color.RGBtoHSB(this.getDropFieldActiveColor().getRed(), this.getDropFieldActiveColor().getGreen(), this.getDropFieldActiveColor().getBlue(), hsb);
            hsb[1] = 0.2f;
            hsb[2] = 0.9f;
            this.setDropFieldActiveColor(new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2])));
            this.setDropFieldInactiveColor(color2);
            Color.RGBtoHSB(this.getListSelectedDisabledForegroundColor().getRed(), this.getListSelectedDisabledForegroundColor().getGreen(), this.getListSelectedDisabledForegroundColor().getBlue(), hsb);
            hsb[1] = hsb[1] * 0.2f;
            this.setTableEditCellBorderColor(new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2])));
            this.iconMap = null;
        }
        catch (RuntimeException rex) {
            LOGGER.severe("updating UI defaults failed", (Throwable)rex);
        }
    }

    public Color brighter(Color color, double factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
    }

    public Color darker(Color color, double factor) {
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
    }
}

