/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.plaf.TPopupRenderer;

public class TComboPopup
extends BasicComboPopup {
    protected PropertyChangeListener tPropertyChangeListener;

    public TComboPopup(JComboBox combo) {
        super(combo);
    }

    @Override
    public void uninstallingUI() {
        if (this.tPropertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.tPropertyChangeListener);
        }
        super.uninstallingUI();
    }

    protected PropertyChangeListener createTPropertyChangeListener() {
        if (this.tPropertyChangeListener == null) {
            this.tPropertyChangeListener = new PopupRendererChangeListener();
        }
        return this.tPropertyChangeListener;
    }

    @Override
    protected void installComboBoxListeners() {
        this.tPropertyChangeListener = this.createTPropertyChangeListener();
        if (this.tPropertyChangeListener != null) {
            this.comboBox.addPropertyChangeListener(this.tPropertyChangeListener);
        }
        super.installComboBoxListeners();
    }

    @Override
    protected void configureList() {
        ListCellRenderer popupRenderer;
        super.configureList();
        if (this.comboBox instanceof FormComboBox && (popupRenderer = ((FormComboBox)this.comboBox).getPopupRenderer()) != null) {
            this.list.setCellRenderer(popupRenderer);
        }
    }

    private int getMinimumDisplayWidth() {
        ListCellRenderer popupRenderer;
        int width = 0;
        ComboBoxModel model = this.comboBox.getModel();
        int modelSize = model.getSize();
        ListCellRenderer renderer = this.list.getCellRenderer();
        if (this.comboBox instanceof FormComboBox && (popupRenderer = ((FormComboBox)this.comboBox).getPopupRenderer()) != null) {
            renderer = popupRenderer;
            this.list.setCellRenderer(popupRenderer);
        }
        if (renderer instanceof TPopupRenderer) {
            ((TPopupRenderer)renderer).setMinLeftWidth(this.comboBox.getPreferredSize().width);
            int leftWidth = 0;
            int rightWidth = 0;
            for (int i = 0; i < modelSize; ++i) {
                renderer.getListCellRendererComponent(this.list, model.getElementAt(i), -1, false, false).getPreferredSize();
                leftWidth = Math.max(leftWidth, ((TPopupRenderer)renderer).getLeftWidth());
                rightWidth = Math.max(rightWidth, ((TPopupRenderer)renderer).getRightWidth());
            }
            ((TPopupRenderer)renderer).setMinLeftWidth(leftWidth);
            ((TPopupRenderer)renderer).setMinRightWidth(rightWidth);
            width = leftWidth + rightWidth + 3;
        } else {
            for (int i = 0; i < modelSize; ++i) {
                width = Math.max(width, renderer.getListCellRendererComponent(this.list, model.getElementAt((int)i), (int)-1, (boolean)false, (boolean)false).getPreferredSize().width);
            }
        }
        return width;
    }

    @Override
    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle rect = super.computePopupBounds(px, py, pw, ph);
        if (this.comboBox instanceof FormComboBox && ((FormComboBox)this.comboBox).getPopupRenderer() != null) {
            rect.width = Math.max(rect.width, this.getMinimumDisplayWidth() + this.scroller.getVerticalScrollBar().getPreferredSize().width);
        }
        return rect;
    }

    private class PopupRendererChangeListener
    implements PropertyChangeListener {
        private PopupRendererChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            String propertyName = e.getPropertyName();
            if (propertyName.equals("popupRenderer")) {
                ListCellRenderer renderer = ((FormComboBox)comboBox).getPopupRenderer();
                TComboPopup.this.list.setCellRenderer(renderer == null ? comboBox.getRenderer() : renderer);
                if (TComboPopup.this.isVisible()) {
                    TComboPopup.this.hide();
                }
            } else if (propertyName.equals("shortLongPopup")) {
                boolean flag = ((FormComboBox)comboBox).isShortLongPopupEnabled();
                if (flag) {
                    ((FormComboBox)comboBox).setPopupRenderer(new TPopupRenderer());
                } else {
                    ((FormComboBox)comboBox).setPopupRenderer(null);
                }
            }
        }
    }
}

