/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class TFlasherListener
implements FocusListener,
ActionListener {
    private static Timer flasher;
    protected static boolean flasherVisible;
    protected JComponent comp;

    public static boolean isFlasherVisible() {
        return flasherVisible;
    }

    public static void removeFlasherListener(JComponent comp) {
        FocusListener[] listeners = comp.getFocusListeners();
        if (listeners != null) {
            for (int counter = 0; counter < listeners.length; ++counter) {
                if (!(listeners[counter] instanceof TFlasherListener)) continue;
                comp.removeFocusListener(listeners[counter]);
            }
        }
    }

    public TFlasherListener(JComponent comp) {
        this.comp = comp;
        if (flasher == null) {
            flasher = new Timer(500, null);
            flasher.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        flasherVisible = !flasherVisible;
        this.comp.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
        flasher.addActionListener(this);
    }

    @Override
    public void focusLost(FocusEvent e) {
        flasher.removeActionListener(this);
        this.comp.repaint();
    }
}

