/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.plaf.TBasicTransferable;

public class TTableTransferHandler
extends TransferHandler
implements UIResource {
    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTable) {
            int[] cols;
            int counter;
            int[] rows;
            JTable table = (JTable)c;
            if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                return null;
            }
            if (!table.getRowSelectionAllowed()) {
                int rowCount = table.getRowCount();
                rows = new int[rowCount];
                for (counter = 0; counter < rowCount; ++counter) {
                    rows[counter] = counter;
                }
            } else {
                rows = table.getSelectedRows();
            }
            if (!table.getColumnSelectionAllowed()) {
                if (table instanceof FormTable && ((FormTable)table).isCellDragEnabled() && table.getColumnModel().getSelectionModel().getAnchorSelectionIndex() >= 0) {
                    cols = new int[]{table.getColumnModel().getSelectionModel().getAnchorSelectionIndex()};
                } else {
                    int colCount = table.getColumnCount();
                    cols = new int[colCount];
                    for (counter = 0; counter < colCount; ++counter) {
                        cols[counter] = counter;
                    }
                }
            } else {
                cols = table.getSelectedColumns();
            }
            if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                return null;
            }
            StringBuffer plainBuf = new StringBuffer();
            StringBuffer htmlBuf = new StringBuffer();
            htmlBuf.append("<html>\n<body>\n<table>\n");
            for (int row = 0; row < rows.length; ++row) {
                htmlBuf.append("<tr>\n");
                for (int col = 0; col < cols.length; ++col) {
                    Object obj = table.getValueAt(rows[row], cols[col]);
                    String val = obj == null ? "" : obj.toString();
                    plainBuf.append(val + "\t");
                    htmlBuf.append("  <td>" + val + "</td>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                htmlBuf.append("</tr>\n");
            }
            plainBuf.deleteCharAt(plainBuf.length() - 1);
            htmlBuf.append("</table>\n</body>\n</html>");
            return new TBasicTransferable(plainBuf.toString(), htmlBuf.toString());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

