/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tmetal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.plaf.TComboPopup;
import org.tentackle.swing.plaf.TFlasherListener;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

public class TMetalComboBoxUI
extends MetalComboBoxUI {
    private static Color mandatoryColor;
    private boolean usingOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;

    public static ComponentUI createUI(JComponent c) {
        return new TMetalComboBoxUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (((TentackleLookAndFeel)((Object)UIManager.getLookAndFeel())).isFocusAnimated()) {
            this.comboBox.addFocusListener(new KComboBoxFlasherListener());
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        TFlasherListener.removeFlasherListener(this.comboBox);
    }

    private boolean isArrowButtonShownAsMandatory() {
        return !this.comboBox.isEditable() && this.comboBox instanceof FormComboBox && ((FormComboBox)this.comboBox).isMandatory();
    }

    private Color getMandatoryColor() {
        Color color = UIManager.getColor("ComboBox.mandatoryBackground");
        if (mandatoryColor == null) {
            mandatoryColor = new Color(color.getRGB());
        }
        return mandatoryColor;
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new TMetalPropertyChangeListener();
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = super.createArrowButton();
        if (this.isArrowButtonShownAsMandatory()) {
            button.setBackground(this.getMandatoryColor());
        }
        return button;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        if (this.isArrowButtonShownAsMandatory()) {
            this.arrowButton.setBackground(this.getMandatoryColor());
        }
    }

    @Override
    protected ComboPopup createPopup() {
        return new TComboPopup(this.comboBox);
    }

    private class KComboBoxFlasherListener
    extends TFlasherListener {
        public KComboBoxFlasherListener() {
            super(TMetalComboBoxUI.this.comboBox);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TMetalComboBoxUI.this.comboBox.isEditable()) {
                boolean bl = flasherVisible = !flasherVisible;
                if (!flasherVisible) {
                    Graphics g = TMetalComboBoxUI.this.arrowButton.getGraphics();
                    if (g != null) {
                        g.setColor(TMetalComboBoxUI.this.usingOcean ? UIManager.getColor("Button.focus") : TMetalComboBoxUI.this.arrowButton.getBackground());
                        Insets insets = TMetalComboBoxUI.this.arrowButton.getInsets();
                        int width = TMetalComboBoxUI.this.arrowButton.getWidth() - (insets.left + insets.right);
                        int height = TMetalComboBoxUI.this.arrowButton.getHeight() - (insets.top + insets.bottom);
                        if (height > 0 && width > 0) {
                            int left = insets.left;
                            int top = insets.top;
                            g.drawRect(left - 1, top - 1, width + 3, height + 1);
                        }
                    }
                } else {
                    TMetalComboBoxUI.this.arrowButton.repaint();
                }
            }
        }
    }

    public class TMetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public TMetalPropertyChangeListener() {
            super(TMetalComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                if (TMetalComboBoxUI.this.isArrowButtonShownAsMandatory()) {
                    TMetalComboBoxUI.this.arrowButton.setBackground(TMetalComboBoxUI.this.getMandatoryColor());
                } else {
                    TMetalComboBoxUI.this.arrowButton.setBackground(color);
                }
                TMetalComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("mandatory") || propertyName.equals("editable") || propertyName.equals("enabled")) {
                Color color = TMetalComboBoxUI.this.isArrowButtonShownAsMandatory() ? TMetalComboBoxUI.this.getMandatoryColor() : TMetalComboBoxUI.this.listBox.getBackground();
                TMetalComboBoxUI.this.arrowButton.setBackground(color);
            }
        }
    }
}

