/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tplastic;

import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;
import org.tentackle.common.Service;
import org.tentackle.swing.plaf.TentackleLookAndFeel;
import org.tentackle.swing.plaf.tmetal.TMetalLookAndFeel;
import org.tentackle.swing.plaf.tmetal.TOceanLookAndFeel;
import org.tentackle.swing.plaf.tplastic.TPlasticTheme;

@Service(value=TentackleLookAndFeel.class)
public class TPlasticLookAndFeel
extends TOceanLookAndFeel {
    public static String getTPlasticName() {
        return "TPlastic";
    }

    public static String getTPlasticDescription() {
        return "Enhanced Ocean LnF for Tentackle";
    }

    @Override
    public String getName() {
        return TPlasticLookAndFeel.getTPlasticName();
    }

    @Override
    public String getDescription() {
        return TPlasticLookAndFeel.getTPlasticDescription();
    }

    @Override
    public void initialize() {
        super.initialize();
        TMetalLookAndFeel.setCurrentTheme(new TPlasticTheme());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        OceanTheme currentTheme = (OceanTheme)MetalLookAndFeel.getCurrentTheme();
        if (currentTheme != null) {
            FontActiveValue userTextValue = new FontActiveValue(currentTheme, 2);
            FontActiveValue controlTextValue = new FontActiveValue(currentTheme, 0);
            Object[] defaults = new Object[]{"Label.font", userTextValue, "TextField.font", controlTextValue, "TextArea.font", controlTextValue, "PasswordField.font", controlTextValue, "Table.font", controlTextValue, "TitledBorder.font", userTextValue};
            table.putDefaults(defaults);
        }
    }

    private static class FontActiveValue
    implements UIDefaults.ActiveValue {
        private int type;
        private MetalTheme theme;

        FontActiveValue(MetalTheme theme, int type) {
            this.theme = theme;
            this.type = type;
        }

        @Override
        public Object createValue(UIDefaults table) {
            FontUIResource value = null;
            switch (this.type) {
                case 0: {
                    value = this.theme.getControlTextFont();
                    break;
                }
                case 1: {
                    value = this.theme.getSystemTextFont();
                    break;
                }
                case 2: {
                    value = this.theme.getUserTextFont();
                    break;
                }
                case 3: {
                    value = this.theme.getMenuTextFont();
                    break;
                }
                case 4: {
                    value = this.theme.getWindowTitleFont();
                    break;
                }
                case 5: {
                    value = this.theme.getSubTextFont();
                }
            }
            return value;
        }
    }
}

