/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.AbstractFractionNumberFormField;
import org.tentackle.swing.SwingSwingBundle;

public class FloatFormField
extends AbstractFractionNumberFormField {
    private float minValue = -3.4028235E38f;
    private float maxValue = Float.MAX_VALUE;

    public FloatFormField(Document doc, int columns) {
        super(doc, columns);
        this.decimalFormat.applyPattern(FormatHelper.getFloatingNumberPattern());
    }

    public FloatFormField(int columns) {
        this((Document)null, columns);
    }

    public FloatFormField() {
        this(0);
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Float getFormValue() {
        String str = this.getText();
        if (str == null || (str = str.replace(this.getFiller(), ' ').trim()).length() <= 0) return null;
        try {
            Number value = this.decimalFormat.parse(str);
            if (value instanceof Long) {
                value = ((Long)value).doubleValue();
            }
            if (value instanceof Double) {
                if ((Double)value > (double)this.maxValue) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), Float.valueOf(this.maxValue));
                    return null;
                } else {
                    if (!((Double)value < (double)this.minValue)) return Float.valueOf(((Double)value).floatValue());
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), Float.valueOf(this.minValue));
                }
                return null;
            } else {
                this.errorOffset = 0;
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
            }
            return null;
        }
        catch (ParseException e) {
            this.errorOffset = e.getErrorOffset();
            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
        }
        return null;
    }

    public float getFloatValue() {
        Float value = this.getFormValue();
        return value == null ? 0.0f : value.floatValue();
    }

    public void setFloatValue(float value) {
        this.setFormValue(Float.valueOf(value));
    }
}

