/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.FormUtilities;

public class FormEventQueue
extends EventQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormEventQueue.class);
    public static long dropKeyEventDefaultTime = 250L;
    private long dropKeyEventTime;

    public void dropKeyEvents(long millis) {
        this.dropKeyEventTime = System.currentTimeMillis() + millis;
    }

    public void dropKeyEvents() {
        this.dropKeyEvents(dropKeyEventDefaultTime);
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        Object object;
        MouseEvent me;
        AWTEvent event;
        while ((event = super.getNextEvent()) instanceof KeyEvent && ((KeyEvent)event).getWhen() <= this.dropKeyEventTime) {
        }
        if (event instanceof MouseEvent && (me = (MouseEvent)event).isShiftDown() && me.isControlDown() && me.isPopupTrigger() && (object = me.getSource()) instanceof Component) {
            Point p = me.getPoint();
            Component comp = SwingUtilities.getDeepestComponentAt((Component)object, p.x, p.y);
            LOGGER.info("Component Hierarchy:\n" + FormUtilities.getInstance().dumpComponentHierarchy(comp, me), new Object[0]);
        }
        return event;
    }
}

