/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormQuestion
extends FormDialog {
    private static final String YESKEYS = SwingSwingBundle.getString("YESKEYS");
    private static final String NOKEYS = SwingSwingBundle.getString("NOKEYS");
    private boolean okFlag;
    private Component messageComp;
    private JPanel buttonPanel;
    private JLabel iconLabel;
    private FormTextArea messageField;
    private JPanel messagePanel;
    private FormButton noButton;
    private FormButton yesButton;

    public FormQuestion() {
        this.initComponents();
        this.messageComp = this.messagePanel;
    }

    public boolean showDialog(String question, String yes, String no) {
        if (question != null) {
            this.messageField.setText(question);
            this.messageField.setSize(this.messageField.getOptimalSize());
        }
        this.messageField.setBackground(this.buttonPanel.getBackground());
        if (yes != null) {
            this.yesButton.setText(yes);
        }
        if (no != null) {
            this.noButton.setText(no);
        }
        this.okFlag = false;
        this.pack();
        this.setVisible(true);
        return this.okFlag;
    }

    public boolean showDialog() {
        return this.showDialog(null, null, null);
    }

    public void setMessageComponent(Component comp) {
        this.getContentPane().remove(this.messageComp);
        this.messageComp = comp;
        this.getContentPane().add(this.messageComp, "Center");
    }

    public Component getMessageComponent() {
        return this.messageComp;
    }

    public static boolean yesNo(String question, String yes, String no) {
        FormUtilities.getInstance().getEventQueue().dropKeyEvents();
        return new FormQuestion().showDialog(question, yes, no);
    }

    public static boolean yesNo(String question) {
        return FormQuestion.yesNo(question, null, null);
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.iconLabel = new JLabel();
        this.messageField = new FormTextArea();
        this.buttonPanel = new JPanel();
        this.yesButton = new FormButton();
        this.noButton = new FormButton();
        this.setAutoPosition(true);
        this.setTitle(SwingSwingBundle.getTranslation("QUESTION"));
        this.setModal(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FormQuestion.this.formKeyTyped(evt);
            }
        });
        this.messagePanel.setLayout(new GridBagLayout());
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setIcon(PlafUtilities.getInstance().getIcon("QuestionDialog"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.iconLabel, gridBagConstraints);
        this.messageField.setEditable(false);
        this.messageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageField.setLineWrap(true);
        this.messageField.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.messageField, gridBagConstraints);
        this.getContentPane().add((Component)this.messagePanel, "Center");
        this.yesButton.setIcon(PlafUtilities.getInstance().getIcon("ok"));
        this.yesButton.setName("yes");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormQuestion.this.yesButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.yesButton);
        this.noButton.setIcon(PlafUtilities.getInstance().getIcon("cancel"));
        this.noButton.setName("no");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormQuestion.this.noButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.noButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void formKeyTyped(KeyEvent evt) {
        char key = Character.toUpperCase(evt.getKeyChar());
        if (YESKEYS.indexOf(key) >= 0) {
            this.yesButton.doClick();
        }
        if (NOKEYS.indexOf(key) >= 0) {
            this.noButton.doClick();
        }
    }

    private void noButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void yesButtonActionPerformed(ActionEvent evt) {
        this.okFlag = true;
        this.dispose();
    }
}

