/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import org.tentackle.locale.I18nTranslatable;
import org.tentackle.locale.I18nTranslation;
import org.tentackle.swing.FocusTraversalGroup;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.FormWrapEvent;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.PropertyGroup;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.TooltipDisplay;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.bind.FormComponentBinding;

public class FormRadioButton
extends JRadioButton
implements FormComponent,
I18nTranslatable,
ActionListener {
    private static final String SELECT_CHARS = SwingSwingBundle.getString("YESKEYS");
    private static final String DESELECT_CHARS = SwingSwingBundle.getString("NOKEYS");
    private boolean autoUpdate = true;
    private String helpURL;
    private FormWindow formWrapWindow;
    private boolean fireRunning;
    private boolean savedValue;
    private Color selectedColor;
    private Color unselectedColor;
    private KeyEvent lastKeyEvent;
    private boolean tableCellEditorUsage;
    private boolean skipNextFocusLost;
    private Window parentWindow;
    private TooltipDisplay tooltipDisplay;
    private boolean transferFocusDone;
    private boolean transferFocusBackwardDone;
    private boolean transferFocusByEnter;
    private boolean focusGainedFromTransfer;
    private boolean focusGainedFromTransferBackward;
    private boolean formTraversable = true;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean allChangeable = true;
    private boolean bindable = true;
    private String componentPath;
    private String bindingPath;
    private FormComponentBinding binding;
    private boolean smartValueEntered = true;
    private boolean oldValueShown;
    private boolean mandatory;
    private FocusTraversalGroup focusTraversalGroup;
    private PropertyGroup propertyGroup;
    private boolean triggerValueChangedEnabled = true;
    private I18nTranslation i18nTranslation;

    public FormRadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.addActionListener(this);
        FormUtilities.getInstance().setupDefaultBindings(this);
    }

    public FormRadioButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public FormRadioButton(String text) {
        this(text, false);
    }

    public FormRadioButton() {
        this((String)null);
    }

    public void setText(I18nTranslation i18nTranslation) {
        this.setI18nTranslation(i18nTranslation);
    }

    public void setI18nTranslation(I18nTranslation i18nTranslation) {
        this.i18nTranslation = i18nTranslation;
        this.setText(i18nTranslation == null ? null : i18nTranslation.getText());
    }

    public I18nTranslation getI18nTranslation() {
        return this.i18nTranslation;
    }

    @Override
    public void showErrorPopup(String message) {
        FormUtilities.getInstance().showErrorPopup(this, message);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public Color getUnselectedColor() {
        return this.unselectedColor;
    }

    public void setUnselectedColor(Color unselectedColor) {
        this.unselectedColor = unselectedColor;
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.autoUpdate = autoupdate;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public String getToolTipText() {
        return this.getTooltipDisplay() == null ? super.getToolTipText() : null;
    }

    @Override
    public void transferFocus() {
        this.transferFocusDone = true;
        super.transferFocus();
    }

    @Override
    public void transferFocusBackward() {
        this.transferFocusBackwardDone = true;
        super.transferFocusBackward();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            this.lastKeyEvent = e;
            if (this.isCellEditorUsage()) {
                this.transferFocusByEnter = false;
                if (!(e.getModifiers() != 0 && e.getModifiers() != 1 || e.getKeyCode() != 10 && e.getKeyCode() != 9)) {
                    if (e.getModifiers() == 0) {
                        this.transferFocusDone = true;
                    } else {
                        this.transferFocusBackwardDone = true;
                    }
                    this.transferFocusByEnter = true;
                    this.fireValueEntered();
                    e.consume();
                    return;
                }
            } else if (e.getModifiers() == 0) {
                if (e.getKeyCode() == 38) {
                    e.consume();
                    this.transferFocusBackward();
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                    this.transferFocus();
                }
            }
            char key = e.getKeyChar();
            if (e.getModifiers() == 0) {
                if (this.isCellEditorUsage()) {
                    if (key != '\uffff') {
                        if (DESELECT_CHARS.indexOf(key) >= 0) {
                            e.consume();
                            this.setSelected(false);
                        } else if (SELECT_CHARS.indexOf(key) >= 0) {
                            e.consume();
                            this.setSelected(true);
                        }
                    }
                } else if (key != '\uffff') {
                    if (DESELECT_CHARS.indexOf(key) >= 0) {
                        e.consume();
                        this.setSelected(true);
                        this.doClick();
                    } else if (SELECT_CHARS.indexOf(key) >= 0) {
                        e.consume();
                        this.setSelected(false);
                        this.doClick();
                    }
                }
            }
            if (e.getKeyCode() == 90 && e.getModifiers() == 2) {
                this.setSelected(this.savedValue);
            }
        }
        super.processKeyEvent(e);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (!e.isTemporary()) {
            if (e.getID() == 1004) {
                this.performFocusGained(e.getOppositeComponent());
            } else if (e.getID() == 1005) {
                if (this.skipNextFocusLost) {
                    this.skipNextFocusLost = false;
                    this.performWrapEvent();
                } else {
                    this.performFocusLost();
                }
            }
        }
    }

    private void performFocusGained(Component opposite) {
        if (opposite instanceof FormComponent) {
            this.focusGainedFromTransfer = ((FormComponent)((Object)opposite)).wasTransferFocus();
            this.focusGainedFromTransferBackward = ((FormComponent)((Object)opposite)).wasTransferFocusBackward();
        }
        this.transferFocusDone = false;
        this.transferFocusBackwardDone = false;
        if (this.isAutoUpdate()) {
            this.fireValueChanged();
        }
        this.formWrapWindow = null;
        this.showTooltip(super.getToolTipText());
        this.oldValueShown = this.getValueShown();
    }

    private void performFocusLost() {
        this.transferFocusByEnter = !(this.lastKeyEvent == null || this.lastKeyEvent.getKeyCode() != 10 && this.lastKeyEvent.getKeyCode() != 9 || this.lastKeyEvent.getModifiers() != 0 && this.lastKeyEvent.getModifiers() != 1);
        this.performWrapEvent();
        this.showTooltip(null);
        this.lastKeyEvent = null;
    }

    private void performWrapEvent() {
        if (this.formWrapWindow != null) {
            this.formWrapWindow.fireFormWrappedFocus(new FormWrapEvent(this));
            this.formWrapWindow = null;
        }
    }

    private void showTooltip(String text) {
        TooltipDisplay td = this.getTooltipDisplay();
        if (td != null) {
            td.setTooltip(text);
        }
    }

    private TooltipDisplay getTooltipDisplay() {
        Window w;
        if (this.tooltipDisplay == null && (w = this.getParentWindow()) instanceof FormWindow) {
            this.tooltipDisplay = ((FormWindow)((Object)w)).getTooltipDisplay();
        }
        return this.tooltipDisplay;
    }

    @Override
    public void requestFocusLater() {
        FormUtilities.getInstance().requestFocusLater(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }

    @Override
    public synchronized void addValueListener(ValueListener l) {
        this.listenerList.add(ValueListener.class, l);
    }

    @Override
    public synchronized void removeValueListener(ValueListener l) {
        this.listenerList.remove(ValueListener.class, l);
    }

    @Override
    public void fireValueChanged() {
        FormUtilities.getInstance().doFireValueChanged(this, this.listenerList.getListenerList());
    }

    @Override
    public void fireValueEntered() {
        FormUtilities.getInstance().doFireValueEntered(this, this.listenerList.getListenerList());
    }

    @Override
    public void setFormValue(Object selected) {
        this.setSelected(selected instanceof Boolean && (Boolean)selected != false);
    }

    @Override
    public Boolean getFormValue() {
        return this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void saveValue() {
        if (this.honourChangeable) {
            this.savedValue = super.isSelected();
        }
    }

    @Override
    public boolean isValueChanged() {
        if (!this.honourChangeable) {
            return false;
        }
        boolean value = super.isSelected();
        return value != this.savedValue;
    }

    @Override
    public void setTriggerValueChangedEnabled(boolean enabled) {
        this.triggerValueChangedEnabled = enabled;
    }

    @Override
    public boolean isTriggerValueChangedEnabled() {
        return this.triggerValueChangedEnabled;
    }

    @Override
    public void triggerValueChanged() {
        if (this.triggerValueChangedEnabled) {
            FormUtilities.getInstance().triggerValueChanged(this);
        }
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.isHonourChangeable()) {
            this.changeable = changeable;
            super.setEnabled(changeable && this.allChangeable);
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable && this.allChangeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void updateAllChangeable(boolean allChangeable) {
        if (this.allChangeable != allChangeable) {
            this.allChangeable = allChangeable;
            this.setChangeable(this.changeable);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.changeable = enabled;
    }

    @Override
    public void setFireRunning(boolean running) {
        this.fireRunning = running;
    }

    @Override
    public boolean isFireRunning() {
        return this.fireRunning;
    }

    @Override
    public void prepareFocusLost() {
        if (!this.tableCellEditorUsage) {
            this.performFocusLost();
            this.skipNextFocusLost = true;
        }
    }

    @Override
    public void setFormWrapWindow(FormWindow parent) {
        this.formWrapWindow = parent;
    }

    @Override
    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    @Override
    public void showHelp() {
        FormUtilities.getInstance().openHelpURL(this);
    }

    @Override
    public Window getParentWindow() {
        if (this.parentWindow == null) {
            this.parentWindow = FormUtilities.getInstance().getParentWindow(this);
        }
        return this.parentWindow;
    }

    @Override
    public void invalidateParentInfo() {
        this.parentWindow = null;
        this.tooltipDisplay = null;
    }

    @Override
    public boolean wasTransferFocus() {
        return this.transferFocusDone;
    }

    @Override
    public boolean wasTransferFocusBackward() {
        return this.transferFocusBackwardDone;
    }

    @Override
    public boolean wasFocusGainedFromTransfer() {
        return this.focusGainedFromTransfer;
    }

    @Override
    public boolean wasFocusGainedFromTransferBackward() {
        return this.focusGainedFromTransferBackward;
    }

    @Override
    public boolean wasTransferFocusByEnter() {
        return this.transferFocusByEnter;
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        this.tableCellEditorUsage = flag;
    }

    @Override
    public boolean isCellEditorUsage() {
        return this.tableCellEditorUsage;
    }

    @Override
    public void setFormTraversable(boolean formTraversable) {
        this.formTraversable = formTraversable;
    }

    @Override
    public boolean isFormTraversable() {
        return this.formTraversable;
    }

    @Override
    public void setFocusTraversalGroup(FocusTraversalGroup group) {
        if (this.focusTraversalGroup != group) {
            if (this.focusTraversalGroup != null) {
                if (this.focusTraversalGroup.removeComponent(this)) {
                    this.focusTraversalGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in focus travseral group " + this.focusTraversalGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.focusTraversalGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in focus travseral group " + group);
                }
            }
        }
    }

    @Override
    public FocusTraversalGroup getFocusTraversalGroup() {
        return this.focusTraversalGroup;
    }

    @Override
    public void setPropertyGroup(PropertyGroup group) {
        if (this.propertyGroup != group) {
            if (this.propertyGroup != null) {
                if (this.propertyGroup.removeComponent(this)) {
                    this.propertyGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in property group " + this.propertyGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.propertyGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in property group " + group);
                }
            }
        }
    }

    @Override
    public PropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.mandatory != mandatory) {
            boolean oldValue = this.mandatory;
            this.mandatory = mandatory;
            this.firePropertyChange("mandatory", oldValue, mandatory);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    @Override
    public String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    @Override
    public String getBindingPath() {
        return this.bindingPath;
    }

    @Override
    public void setBinding(FormComponentBinding binding) {
        this.binding = binding;
    }

    @Override
    public FormComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public void setSmartValueEntered(boolean smartValueEntered) {
        this.smartValueEntered = smartValueEntered;
    }

    @Override
    public boolean isSmartValueEntered() {
        return this.smartValueEntered;
    }

    @Override
    public Boolean getValueShown() {
        return super.isSelected();
    }

    @Override
    public boolean isValueShownModified() {
        return this.oldValueShown != this.getValueShown();
    }

    @Override
    public void clearValueShownModified() {
        this.oldValueShown = this.getValueShown();
    }
}

