/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tnimbus;

import java.awt.Color;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import org.tentackle.common.Service;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

@Service(value=TentackleLookAndFeel.class)
public class TNimbusLookAndFeel
extends NimbusLookAndFeel
implements TentackleLookAndFeel {
    private static final long serialVersionUID = -1L;
    private Color mandatoryColor;
    private Color unselectedMandatoryColor;
    private boolean focusAnimated = true;

    public static String getTNimbusName() {
        return "TNimbus";
    }

    public static String getTNimbusDescription() {
        return "Enhanced Nimbus LnF for Tentackle";
    }

    @Override
    public void loadTentackleExtraColors() {
        this.mandatoryColor = new ColorUIResource(255, 255, 170);
        this.unselectedMandatoryColor = new ColorUIResource(PlafUtilities.getInstance().brighter(this.mandatoryColor, 0.75));
    }

    @Override
    public Color getMandatoryColor() {
        return this.mandatoryColor;
    }

    @Override
    public void setMandatoryColor(Color mandatoryColor) {
        this.mandatoryColor = mandatoryColor;
    }

    @Override
    public Color getUnselectedMandatoryColor() {
        return this.unselectedMandatoryColor;
    }

    @Override
    public void setUnselectedMandatoryColor(Color unselectedMandatoryColor) {
        this.unselectedMandatoryColor = unselectedMandatoryColor;
    }

    @Override
    public ImageIcon loadImageIcon(String name) throws MissingResourceException {
        URL url = TNimbusLookAndFeel.class.getResource("icons/" + name + ".png");
        if (url == null) {
            url = TNimbusLookAndFeel.class.getResource("icons/" + name + ".gif");
        }
        if (url == null) {
            throw new MissingResourceException("no such icon '" + name + "'", TNimbusLookAndFeel.class.getName(), name);
        }
        return new ImageIcon(url);
    }

    @Override
    public void setFocusAnimated(boolean flag) {
        this.focusAnimated = flag;
    }

    @Override
    public boolean isFocusAnimated() {
        return this.focusAnimated;
    }
}

