/**
 * Tentackle - http://www.tentackle.org
 * Copyright (C) 2001-2008 Harald Krake, harald@krake.de, +49 7722 9508-0
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// Created on February 3, 2003, 3:16 PM

package org.tentackle.swing;



/**
 * A simple dialog to edit a search text.
 * <p>
 * Used in {@link FormTableUtilityPopup}.
 */
@SuppressWarnings("serial")
public class SearchTextDialog extends org.tentackle.swing.FormDialog {

  private String searchText;      // search text
  private boolean caseSensitive;  // true if case-sensitive, default is false
  private boolean okFlag;         // returnval from showDialog();


  /**
   * Creates a search dialog
   */
  public SearchTextDialog() {
    initComponents();
  }


  /**
   * Displays the modal dialog and prompts the user for the search text.
   * @param searchText the initial search text
   * @param caseSensitive the initial value for caseSensitive
   * @return true if ok-button pressed, false if cancel
   */
  public boolean showDialog(String searchText, boolean caseSensitive) {
    okFlag = false;
    this.searchText = searchText;
    this.caseSensitive = caseSensitive;
    setFormValues();
    pack();
    setVisible(true);
    return okFlag;
  }

  /**
   * Displays the modal dialog and prompts the user for the search text.
   * @return true if ok-button pressed, false if cancel
   */
  public boolean showDialog() {
    return showDialog(null, false);
  }


  /**
   * Gets the search text.
   * @return the search text
   */
  public String getSearchText() {
    return searchText;
  }

  /**
   * Gets the case sensitivity
   * @return true if case sensitive
   */
  public boolean isCaseSensitive()  {
    return caseSensitive;
  }



  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    searchPanel = new org.tentackle.swing.FormPanel();
    jLabel1 = new org.tentackle.swing.FormLabel();
    searchTextField = new org.tentackle.swing.StringFormField();
    uclcCheckBox = new org.tentackle.swing.FormCheckBox();
    buttonPanel = new org.tentackle.swing.FormPanel();
    searchButton = new org.tentackle.swing.FormButton();
    cancelButton = new org.tentackle.swing.FormButton();

    setAutoPosition(true);
    setTitle(SwingSwingBundle.getTranslation("FIND")); // NOI18N
    addFormWrapListener(new org.tentackle.swing.FormWrapListener() {
      public void formWrapped(org.tentackle.swing.FormWrapEvent evt) {
        formFormWrapped(evt);
      }
    });

    searchPanel.setLayout(new java.awt.GridBagLayout());

    jLabel1.setText(SwingSwingBundle.getTranslation("FIND:")); // NOI18N
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
    searchPanel.add(jLabel1, gridBagConstraints);

    searchTextField.setColumns(20);
    searchTextField.setName("text"); // NOI18N
    searchTextField.addValueListener(new org.tentackle.swing.ValueListener() {
      public void valueEntered(org.tentackle.swing.ValueEvent evt) {
        searchTextFieldValueEntered(evt);
      }
      public void valueChanged(org.tentackle.swing.ValueEvent evt) {
        searchTextFieldValueChanged(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    searchPanel.add(searchTextField, gridBagConstraints);

    uclcCheckBox.setText(SwingSwingBundle.getTranslation("CASE SENSITIVE?")); // NOI18N
    uclcCheckBox.setName("uclc"); // NOI18N
    uclcCheckBox.addValueListener(new org.tentackle.swing.ValueListener() {
      public void valueEntered(org.tentackle.swing.ValueEvent evt) {
        uclcCheckBoxValueEntered(evt);
      }
      public void valueChanged(org.tentackle.swing.ValueEvent evt) {
        uclcCheckBoxValueChanged(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    searchPanel.add(uclcCheckBox, gridBagConstraints);

    getContentPane().add(searchPanel, java.awt.BorderLayout.CENTER);

    searchButton.setIcon(org.tentackle.swing.plaf.PlafUtilities.getInstance().getIcon("search"));
    searchButton.setMnemonic('s');
    searchButton.setText(SwingSwingBundle.getTranslation("FIND")); // NOI18N
    searchButton.setName("search"); // NOI18N
    searchButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        searchButtonActionPerformed(evt);
      }
    });
    buttonPanel.add(searchButton);

    cancelButton.setIcon(org.tentackle.swing.plaf.PlafUtilities.getInstance().getIcon("cancel"));
    cancelButton.setMnemonic('a');
    cancelButton.setText(SwingSwingBundle.getTranslation("CANCEL")); // NOI18N
    cancelButton.setName("cancel"); // NOI18N
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });
    buttonPanel.add(cancelButton);

    getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void formFormWrapped(org.tentackle.swing.FormWrapEvent evt) {//GEN-FIRST:event_formFormWrapped
    searchButton.doClick();
  }//GEN-LAST:event_formFormWrapped

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void searchButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchButtonActionPerformed
    okFlag = true;
    dispose();
  }//GEN-LAST:event_searchButtonActionPerformed

  private void uclcCheckBoxValueEntered(org.tentackle.swing.ValueEvent evt) {//GEN-FIRST:event_uclcCheckBoxValueEntered
    caseSensitive = uclcCheckBox.isSelected();
  }//GEN-LAST:event_uclcCheckBoxValueEntered

  private void uclcCheckBoxValueChanged(org.tentackle.swing.ValueEvent evt) {//GEN-FIRST:event_uclcCheckBoxValueChanged
    uclcCheckBox.setSelected(caseSensitive);
  }//GEN-LAST:event_uclcCheckBoxValueChanged

  private void searchTextFieldValueEntered(org.tentackle.swing.ValueEvent evt) {//GEN-FIRST:event_searchTextFieldValueEntered
    searchText = searchTextField.getText();
  }//GEN-LAST:event_searchTextFieldValueEntered

  private void searchTextFieldValueChanged(org.tentackle.swing.ValueEvent evt) {//GEN-FIRST:event_searchTextFieldValueChanged
    searchTextField.setText(searchText);
  }//GEN-LAST:event_searchTextFieldValueChanged


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private org.tentackle.swing.FormPanel buttonPanel;
  private org.tentackle.swing.FormButton cancelButton;
  private org.tentackle.swing.FormLabel jLabel1;
  private org.tentackle.swing.FormButton searchButton;
  private org.tentackle.swing.FormPanel searchPanel;
  private org.tentackle.swing.StringFormField searchTextField;
  private org.tentackle.swing.FormCheckBox uclcCheckBox;
  // End of variables declaration//GEN-END:variables

}
