/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class EnhancedLineBorder
extends LineBorder {
    private boolean topEnabled;
    private boolean leftEnabled;
    private boolean bottomEnabled;
    private boolean rightEnabled;

    public EnhancedLineBorder(Color color, int thickness, boolean topEnabled, boolean leftEnabled, boolean bottomEnabled, boolean rightEnabled) {
        super(color, thickness);
        this.topEnabled = topEnabled;
        this.leftEnabled = leftEnabled;
        this.bottomEnabled = bottomEnabled;
        this.rightEnabled = rightEnabled;
    }

    public EnhancedLineBorder(boolean topEnabled, boolean leftEnabled, boolean bottomEnabled, boolean rightEnabled) {
        this(Color.BLACK, 1, topEnabled, leftEnabled, bottomEnabled, rightEnabled);
    }

    public EnhancedLineBorder(Color color, int thickness) {
        this(color, thickness, true, true, true, true);
    }

    public EnhancedLineBorder(Color color) {
        this(color, 1);
    }

    public EnhancedLineBorder() {
        this(Color.BLACK);
    }

    public void setTopEnabled(boolean enabled) {
        this.topEnabled = enabled;
    }

    public boolean isTopEnabled() {
        return this.topEnabled;
    }

    public void setBottomEnabled(boolean enabled) {
        this.bottomEnabled = enabled;
    }

    public boolean isBottomEnabled() {
        return this.bottomEnabled;
    }

    public void setLeftEnabled(boolean enabled) {
        this.leftEnabled = enabled;
    }

    public boolean isLeftEnabled() {
        return this.leftEnabled;
    }

    public void setRightEnabled(boolean enabled) {
        this.rightEnabled = enabled;
    }

    public boolean isRightEnabled() {
        return this.rightEnabled;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    @Override
    public int getThickness() {
        return this.thickness;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        if (this.topEnabled) {
            g.fillRect(x, y, width - 1, this.thickness);
        }
        if (this.bottomEnabled) {
            g.fillRect(x, y + height - this.thickness, width - 1, this.thickness);
        }
        if (this.leftEnabled) {
            g.fillRect(x, y, this.thickness, height - 1);
        }
        if (this.rightEnabled) {
            g.fillRect(x + width - this.thickness, y, this.thickness, height - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.topEnabled ? this.thickness : 0, this.leftEnabled ? this.thickness : 0, this.bottomEnabled ? this.thickness : 0, this.rightEnabled ? this.thickness : 0);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.topEnabled ? this.thickness : 0;
        insets.left = this.leftEnabled ? this.thickness : 0;
        insets.bottom = this.bottomEnabled ? this.thickness : 0;
        insets.right = this.rightEnabled ? this.thickness : 0;
        return insets;
    }
}

