/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.tentackle.locale.I18nTranslatable;
import org.tentackle.locale.I18nTranslation;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.FormChangeableComponent;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.TooltipDisplay;

public class FormButton
extends JButton
implements FormChangeableComponent,
I18nTranslatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormButton.class);
    private static final String TABLECELLEDITOR_PROPERTY = "JButton.isTableCellEditor";
    private String helpURL;
    private boolean clickOnEnter;
    private boolean actionPerformedDelayed = true;
    private boolean formTraversable;
    private TooltipDisplay tooltipDisplay;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean allChangeable = true;
    private I18nTranslation i18nTranslation;

    public FormButton() {
    }

    public FormButton(Icon icon) {
        super(icon);
    }

    public FormButton(String text) {
        super(text);
    }

    public FormButton(Action a) {
        super(a);
    }

    public FormButton(String text, Icon icon) {
        super(text, icon);
    }

    public void setText(I18nTranslation i18nTranslation) {
        this.setI18nTranslation(i18nTranslation);
    }

    public void setI18nTranslation(I18nTranslation i18nTranslation) {
        this.i18nTranslation = i18nTranslation;
        this.setText(i18nTranslation == null ? null : i18nTranslation.getText());
    }

    public I18nTranslation getI18nTranslation() {
        return this.i18nTranslation;
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.isHonourChangeable()) {
            this.changeable = changeable;
            super.setEnabled(changeable && this.allChangeable);
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable && this.allChangeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void updateAllChangeable(boolean allChangeable) {
        if (this.allChangeable != allChangeable) {
            this.allChangeable = allChangeable;
            this.setChangeable(this.changeable);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.changeable = enabled;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this.isActionPerformedDelayed()) {
            EventQueue.invokeLater(() -> FormButton.super.fireActionPerformed(event));
        } else {
            super.fireActionPerformed(event);
        }
    }

    private void showTooltip(String text) {
        TooltipDisplay td;
        if (this.formTraversable && (td = this.getTooltipDisplay()) != null) {
            td.setTooltip(text);
        }
    }

    private TooltipDisplay getTooltipDisplay() {
        Window w;
        if (this.tooltipDisplay == null && (w = FormUtilities.getInstance().getParentWindow(this)) instanceof FormWindow) {
            this.tooltipDisplay = ((FormWindow)((Object)w)).getTooltipDisplay();
        }
        return this.tooltipDisplay;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (!e.isTemporary()) {
            if (e.getID() == 1004) {
                if (!this.isEnabled()) {
                    this.showTooltip(null);
                    this.transferFocus();
                } else {
                    this.showTooltip(this.getToolTipText());
                }
            } else if (e.getID() == 1005) {
                this.showTooltip(null);
            }
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        boolean isTableCellEditor = this.isCellEditorUsage();
        int keyCode = e.getKeyCode();
        if (e.getID() == 401) {
            if (this.isFormTraversable()) {
                if (e.getModifiers() == 0) {
                    switch (keyCode) {
                        case 37: 
                        case 38: {
                            if (isTableCellEditor) break;
                            this.transferFocusBackward();
                            e.consume();
                            break;
                        }
                        case 39: 
                        case 40: {
                            if (isTableCellEditor) break;
                            this.transferFocus();
                            e.consume();
                            break;
                        }
                        case 10: {
                            if (this.isClickOnEnter()) {
                                this.doClick();
                                break;
                            }
                            if (isTableCellEditor) break;
                            this.transferFocus();
                            e.consume();
                        }
                    }
                } else {
                    switch (keyCode) {
                        case 10: {
                            if (!e.isShiftDown() || isTableCellEditor) break;
                            this.transferFocusBackward();
                            e.consume();
                        }
                    }
                }
            }
            switch (keyCode) {
                case 112: 
                case 156: {
                    e.consume();
                    FormUtilities.getInstance().openHelpURL(this);
                }
            }
        }
        if (isTableCellEditor && (keyCode == 10 || keyCode == 9)) {
            Container p = this.getParent();
            while (p != null) {
                if (p instanceof FormTable) {
                    p.dispatchEvent(new KeyEvent(p, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation()));
                    p = null;
                    continue;
                }
                p = p.getParent();
            }
            e.consume();
        } else {
            super.processKeyEvent(e);
        }
    }

    public void setClickOnEnter(boolean clickOnEnter) {
        this.clickOnEnter = clickOnEnter;
    }

    public boolean isClickOnEnter() {
        return this.clickOnEnter;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public boolean isActionPerformedDelayed() {
        return this.actionPerformedDelayed;
    }

    public void setActionPerformedDelayed(boolean delayActionPerformed) {
        this.actionPerformedDelayed = delayActionPerformed;
    }

    public boolean isFormTraversable() {
        return this.formTraversable;
    }

    public void setFormTraversable(boolean formTraversable) {
        this.formTraversable = formTraversable;
    }

    public void setCellEditorUsage(boolean flag) {
        this.putClientProperty(TABLECELLEDITOR_PROPERTY, flag);
    }

    public boolean isCellEditorUsage() {
        try {
            Object obj = this.getClientProperty(TABLECELLEDITOR_PROPERTY);
            if (obj != null) {
                return (Boolean)obj;
            }
        }
        catch (Exception ex) {
            LOGGER.severe("property JButton.isTableCellEditor not Boolean! " + ex, new Object[0]);
        }
        return false;
    }
}

