/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Toolkit;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormInfo
extends FormDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormInfo.class);
    private Component messageComp;
    private JPanel buttonPanel;
    private JLabel iconLabel;
    private FormTextArea messageField;
    private JPanel messagePanel;
    private FormButton okButton;

    public FormInfo() {
        this.initComponents();
        this.messageComp = this.messagePanel;
    }

    public void showDialog(String message, String title, final long timeout) {
        if (message != null) {
            this.messageField.setText(message);
            this.messageField.setSize(this.messageField.getOptimalSize());
        }
        if (title != null) {
            this.setTitle(title);
        }
        if (timeout > 0L) {
            this.setModal(false);
            this.buttonPanel.setVisible(false);
            new Thread("FormInfoDialog Auto Disposer"){

                @Override
                public void run() {
                    try {
                        1.sleep(timeout);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warning("interrupted -> ignored", (Throwable)ex);
                    }
                    EventQueue.invokeLater(FormInfo.this::dispose);
                }
            }.start();
        }
        this.pack();
        Toolkit.beep();
        this.setVisible(true);
    }

    public void showDialog() {
        this.showDialog(null, null, 0L);
    }

    public void setMessageComponent(Component comp) {
        this.getContentPane().remove(this.messageComp);
        this.messageComp = comp;
        this.getContentPane().add(this.messageComp, "Center");
    }

    public Component getMessageComponent() {
        return this.messageComp;
    }

    public static void show(String message, Logger logger, long timeout) {
        if (logger != null) {
            logger.info(message, new Object[0]);
        }
        FormUtilities.getInstance().getEventQueue().dropKeyEvents();
        new FormInfo().showDialog(message, null, timeout);
    }

    public static void show(String message, Logger logger) {
        FormInfo.show(message, logger, 0L);
    }

    public static void show(String message, boolean log, long timeout) {
        FormInfo.show(message, (Logger)(log ? LOGGER : null), timeout);
    }

    public static void show(String message, boolean log) {
        FormInfo.show(message, log, 0L);
    }

    public static void show(String message, long timeout) {
        FormInfo.show(message, false, timeout);
    }

    public static void show(String message) {
        FormInfo.show(message, false);
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.iconLabel = new JLabel();
        this.messageField = new FormTextArea();
        this.buttonPanel = new JPanel();
        this.okButton = new FormButton();
        this.setAutoPosition(true);
        this.setTitle(SwingSwingBundle.getTranslation("INFORMATION"));
        this.setModal(true);
        this.messagePanel.setLayout(new GridBagLayout());
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setIcon(PlafUtilities.getInstance().getIcon("InformationDialog"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.iconLabel, gridBagConstraints);
        this.messageField.setEditable(false);
        this.messageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageField.setLineWrap(true);
        this.messageField.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.messageField, gridBagConstraints);
        this.getContentPane().add((Component)this.messagePanel, "Center");
        this.okButton.setClickOnEnter(true);
        this.okButton.setFormTraversable(true);
        this.okButton.setIcon(PlafUtilities.getInstance().getIcon("ok"));
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormInfo.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

