/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.swing.ErrorToolTip;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormChangeableComponent;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormContainer;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormEventQueue;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormFocusTraversalPolicy;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.FormUtilities$Singleton;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.GUIExceptionHandler;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.ValueEvent;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.bind.DefaultFormBindingFactory;
import org.tentackle.swing.bind.FormBindingFactory;
import org.tentackle.swing.bind.FormComponentBinding;

@Service(value=FormUtilities.class)
public class FormUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormUtilities.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private final FormFocusTraversalPolicy defaultFocusTraversalPolicy = new FormFocusTraversalPolicy();
    private final Set<Window> windows = new HashSet<Window>();
    private EventListenerList windowListeners;
    private List<Dialog> modalDialogs;
    private int uiVersion;
    private String helpURL;
    private FormEventQueue eventQueue;
    private boolean requestFocusLaterPending;
    private FormBindingFactory bindingFactory;
    private boolean activated;
    private long autoClose;
    private AutoCloseThread autoCloseThread;
    private Popup errorPopup;
    private JComponent popupComponent;
    private final ComponentListener popupComponentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            FormUtilities.this.hideErrorPopup();
        }
    };
    private final HierarchyListener popupHierarchyListener = e -> this.hideErrorPopup();
    private static final int STEP_X = 32;
    private static final int STEP_Y = 24;

    public static FormUtilities getInstance() {
        return FormUtilities$Singleton.INSTANCE;
    }

    public FormUtilities() {
        if (INSTANCE_COUNT.incrementAndGet() > 1) {
            throw new RuntimeException("Singleton! Only one single instance allowed.");
        }
        this.windowListeners = new EventListenerList();
        this.modalDialogs = new ArrayList<Dialog>();
        try {
            this.bindingFactory = (FormBindingFactory)ServiceFactory.createService(FormBindingFactory.class, DefaultFormBindingFactory.class);
        }
        catch (Exception ex) {
            throw new GUIRuntimeException("cannot create form binding factory", ex);
        }
    }

    public void activate() {
        if (!this.activated) {
            GUIExceptionHandler.install(false);
            try {
                String multiLineToolTipUIClassName = "org.tentackle.swing.plaf.MultiLineToolTipUI";
                UIManager.put("ToolTipUI", multiLineToolTipUIClassName);
                UIManager.put(multiLineToolTipUIClassName, Class.forName(multiLineToolTipUIClassName));
            }
            catch (ClassNotFoundException cnfe) {
                throw new GUIRuntimeException("MultiLine ToolTip UI class not found", cnfe);
            }
            this.activated = true;
        }
    }

    public String dumpComponentHierarchy(Component comp, MouseEvent me) {
        boolean showing = true;
        StringBuilder buf = new StringBuilder();
        while (comp != null) {
            if (showing && !comp.isShowing()) {
                showing = false;
            }
            buf.append(comp.getClass().getName());
            Point location = showing ? comp.getLocationOnScreen() : new Point();
            buf.append("@[");
            buf.append(location.x);
            buf.append('/');
            buf.append(location.y);
            buf.append(',');
            buf.append(comp.getWidth());
            buf.append('/');
            buf.append(comp.getHeight());
            buf.append(']');
            String name = comp.getName();
            if (name != null) {
                buf.append(" (");
                buf.append(name);
                buf.append(')');
            }
            String text = null;
            if (comp instanceof JTextComponent) {
                text = ((JTextComponent)comp).getText();
            } else if (comp instanceof JLabel) {
                text = ((JLabel)comp).getText();
            } else if (comp instanceof FormTable) {
                text = ((FormTable)comp).getPreferencesName();
            } else if (comp instanceof JTableHeader && me != null) {
                Object headerValue;
                JTableHeader header = (JTableHeader)comp;
                MouseEvent me2 = SwingUtilities.convertMouseEvent((Component)me.getSource(), me, header);
                int columnIndex = header.getColumnModel().getColumnIndexAtX(me2.getX());
                if (columnIndex >= 0 && (headerValue = header.getColumnModel().getColumn(columnIndex).getHeaderValue()) != null) {
                    text = headerValue.toString();
                }
            }
            if (text != null) {
                buf.append(" = \"");
                buf.append(text);
                buf.append('\"');
            }
            buf.append('\n');
            comp = comp.getParent();
        }
        return buf.toString();
    }

    protected FormEventQueue createEventQueue() {
        return new FormEventQueue();
    }

    public synchronized FormEventQueue getEventQueue() {
        if (this.eventQueue == null) {
            this.eventQueue = this.createEventQueue();
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(this.eventQueue);
        }
        return this.eventQueue;
    }

    public FormBindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEmptyEventQueue() {
        FormEventQueue q = this.getEventQueue();
        if (EventQueue.isDispatchThread()) {
            throw new Error("waitForEmptyEventQueue() invoked from within dispatch thread!");
        }
        boolean queueEmpty = false;
        while (!queueEmpty) {
            EmptyEvent e = new EmptyEvent();
            q.postEvent(e);
            EmptyEvent emptyEvent = e;
            synchronized (emptyEvent) {
                while (!e.isDispatched()) {
                    try {
                        e.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                queueEmpty = e.isEventQueueEmpty();
            }
        }
    }

    public void setAutoClose(long ms) {
        this.autoClose = ms;
    }

    public long getAutoClose() {
        return this.autoClose;
    }

    public void modalToFront() {
        int size = this.modalDialogs.size();
        if (size > 0) {
            Dialog d = this.modalDialogs.get(size - 1);
            EventQueue.invokeLater(d::toFront);
        }
    }

    private void fireWindowActionPerformed(ActionEvent e) {
        Object[] lList = this.windowListeners.getListenerList();
        for (int i = lList.length - 2; i >= 0; i -= 2) {
            if (lList[i] != ActionListener.class) continue;
            ((ActionListener)lList[i + 1]).actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindow(Window w) {
        Set<Window> set = this.windows;
        synchronized (set) {
            if (this.windows.add(w)) {
                FormWindow fw;
                if (w instanceof Dialog && ((Dialog)w).isModal()) {
                    this.modalDialogs.add((Dialog)w);
                }
                FormWindow formWindow = fw = w instanceof FormWindow ? (FormWindow)((Object)w) : null;
                if (fw != null && fw.isAutoCloseable()) {
                    fw.setTimeOfLastValuesChanged(System.currentTimeMillis());
                    if (this.autoCloseThread == null) {
                        this.autoCloseThread = new AutoCloseThread();
                        this.autoCloseThread.start();
                        LOGGER.fine("autoclose-thread started", new Object[0]);
                    }
                }
                this.fireWindowActionPerformed(new ActionEvent(w, 1001, "add"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Window w) {
        Set<Window> set = this.windows;
        synchronized (set) {
            if (this.windows.remove(w)) {
                if (w instanceof Dialog && ((Dialog)w).isModal()) {
                    this.modalDialogs.remove(w);
                }
                this.fireWindowActionPerformed(new ActionEvent(w, 1001, "remove"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window[] getWindows() {
        Set<Window> set = this.windows;
        synchronized (set) {
            Window[] remainingWindows = new Window[]{};
            Iterator<Window> iter = this.windows.iterator();
            while (iter.hasNext()) {
                Window w = iter.next();
                if (w.isShowing()) continue;
                iter.remove();
            }
            return this.windows.toArray(remainingWindows);
        }
    }

    public boolean isModalDialogShowing() {
        return !this.modalDialogs.isEmpty();
    }

    public void setUIVersionOfFormWindow(FormWindow formWindow) {
        formWindow.setUIVersion(this.uiVersion);
    }

    public void updateUIofWindow(Window w) {
        if (w instanceof JDialog) {
            SwingUtilities.updateComponentTreeUI(((JDialog)w).getRootPane());
        }
        if (w instanceof JFrame) {
            SwingUtilities.updateComponentTreeUI(((JFrame)w).getRootPane());
        }
        if (w instanceof FormWindow) {
            this.setUIVersionOfFormWindow((FormWindow)((Object)w));
        }
    }

    public void updateUIofAllWindows() {
        ++this.uiVersion;
        for (Window w : this.windows) {
            this.updateUIofWindow(w);
        }
    }

    public void processWindowEvent(WindowEvent e) {
        Window w = e.getWindow();
        switch (e.getID()) {
            case 200: 
            case 205: {
                this.addWindow(w);
            }
            case 204: {
                if (!(w instanceof FormWindow) || ((FormWindow)((Object)w)).getUIVersion() == this.uiVersion) break;
                this.updateUIofWindow(w);
                break;
            }
            case 201: 
            case 202: {
                this.removeWindow(w);
            }
        }
    }

    public void addWindowActionListener(ActionListener listener) {
        this.windowListeners.add(ActionListener.class, listener);
    }

    public void removeWindowActionListener(ActionListener listener) {
        this.windowListeners.remove(ActionListener.class, listener);
    }

    public void setDefaultFocusTraversalPolicy(Container container) {
        if (container instanceof FormContainer) {
            container.setFocusTraversalPolicy(this.defaultFocusTraversalPolicy);
        }
    }

    public void setAutoUpdate(Component c, boolean autoUpdate) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    ((FormComponent)((Object)next)).setAutoUpdate(autoUpdate);
                    continue;
                }
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).setAutoUpdate(autoUpdate);
                    continue;
                }
                this.setAutoUpdate(next, autoUpdate);
            }
        }
    }

    public void doFireValueChanged(FormComponent c, Object[] listeners) {
        if (!c.isFireRunning()) {
            FormComponentBinding binding;
            c.setFireRunning(true);
            if (listeners != null) {
                ValueEvent evt = null;
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ValueListener.class) continue;
                    if (evt == null) {
                        evt = new ValueEvent(c, 1);
                    }
                    ((ValueListener)listeners[i + 1]).valueChanged(evt);
                }
            }
            if ((binding = c.getBinding()) != null) {
                binding.setViewValue(binding.getModelValue());
            }
            c.setFireRunning(false);
        }
    }

    public void doFireValueEntered(FormComponent c, Object[] listeners) {
        if (!c.isFireRunning()) {
            c.setFireRunning(true);
            FormComponentBinding binding = c.getBinding();
            if (binding != null) {
                binding.setModelValue(binding.getViewValue());
            }
            if (listeners != null) {
                ValueEvent evt = null;
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ValueListener.class) continue;
                    if (evt == null) {
                        evt = new ValueEvent(c, 2);
                    }
                    ((ValueListener)listeners[i + 1]).valueEntered(evt);
                }
            }
            c.setFireRunning(false);
            c.triggerValueChanged();
        }
    }

    public void doValidate(FormComponent c) {
        FormComponentBinding binding;
        if (c.isChangeable() && (binding = c.getBinding()) != null) {
            binding.validate();
        }
    }

    public void setFormValue(Component c) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    ((FormComponent)((Object)next)).fireValueChanged();
                    continue;
                }
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).setFormValues();
                    continue;
                }
                this.setFormValue(next);
            }
        }
    }

    public void setFormValueKeepChanged(Component c) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    if (((FormComponent)((Object)next)).isValueChanged()) continue;
                    ((FormComponent)((Object)next)).fireValueChanged();
                    continue;
                }
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).setFormValuesKeepChanged();
                    continue;
                }
                this.setFormValueKeepChanged(next);
            }
        }
    }

    public void getFormValue(Component c) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    ((FormComponent)((Object)next)).fireValueEntered();
                    continue;
                }
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).getFormValues();
                    continue;
                }
                this.getFormValue(next);
            }
        }
    }

    public void saveValue(Component c) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    ((FormComponent)((Object)next)).saveValue();
                    continue;
                }
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).saveValues();
                    continue;
                }
                this.saveValue(next);
            }
        }
    }

    public boolean isValueChanged(Component c, boolean triggerValueChangedEnabledOnly) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    if (triggerValueChangedEnabledOnly && !((FormComponent)((Object)next)).isTriggerValueChangedEnabled() || !((FormComponent)((Object)next)).isValueChanged()) continue;
                    return true;
                }
                if (next instanceof FormContainer) {
                    if (!((FormContainer)((Object)next)).areValuesChanged()) continue;
                    return true;
                }
                if (next instanceof FormTable) {
                    if (((FormTable)next).isDataChanged()) {
                        return true;
                    }
                    Component editor = ((FormTable)next).getEditorComponent();
                    if (!(editor instanceof FormComponent) || triggerValueChangedEnabledOnly && !((FormComponent)((Object)editor)).isTriggerValueChangedEnabled() || !((FormComponent)((Object)editor)).isValueChanged()) continue;
                    return true;
                }
                if (!this.isValueChanged(next, triggerValueChangedEnabledOnly)) continue;
                return true;
            }
        }
        return false;
    }

    public void triggerValueChanged(Component c) {
        while (c != null) {
            if (c instanceof FormContainer) {
                if (((FormContainer)((Object)c)).isTriggerValuesChangedEnabled()) {
                    ((FormContainer)((Object)c)).triggerValuesChanged();
                } else {
                    return;
                }
            }
            c = c.getParent();
        }
    }

    public void setChangeable(Component c, boolean changeable) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).setChangeable(changeable);
                    if (!(next instanceof FormChangeableComponent)) continue;
                    ((FormChangeableComponent)((Object)next)).updateAllChangeable(changeable);
                    continue;
                }
                if (next instanceof FormChangeableComponent) {
                    ((FormChangeableComponent)((Object)next)).updateAllChangeable(changeable);
                    continue;
                }
                this.setChangeable(next, changeable);
            }
        }
    }

    public void setBackground(Component c, Color background) {
        c.setBackground(background);
        if (c instanceof Container) {
            for (Component component : ((Container)c).getComponents()) {
                this.setBackground(component, background);
            }
        }
    }

    public void setForeground(Component c, Color foreground) {
        c.setForeground(foreground);
        if (c instanceof Container) {
            for (Component component : ((Container)c).getComponents()) {
                this.setForeground(component, foreground);
            }
        }
    }

    public Window getParentWindow(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    public Window getVisibleParentOrRelatedWindow(Component comp) {
        FormWindow fw;
        Window w = this.getParentWindow(comp);
        if (w != null && !w.isVisible() && w instanceof FormWindow && (fw = ((FormWindow)((Object)w)).getRelatedWindow()) instanceof Window) {
            w = (Window)((Object)fw);
        }
        return w;
    }

    public boolean isParentWindowModal(Component comp) {
        Window w = this.getParentWindow(comp);
        return w instanceof Dialog && ((Dialog)w).isModal();
    }

    public boolean packParentWindow(Component comp) {
        Window w = comp instanceof FormComponent ? ((FormComponent)((Object)comp)).getParentWindow() : (comp instanceof FormContainer ? ((FormContainer)((Object)comp)).getParentWindow() : this.getParentWindow(comp));
        if (w != null) {
            w.pack();
            return true;
        }
        return false;
    }

    public void invalidateParentInfo(Component c) {
        if (c instanceof Container) {
            for (Component next : ((Container)c).getComponents()) {
                if (next instanceof FormComponent) {
                    ((FormComponent)((Object)next)).invalidateParentInfo();
                    continue;
                }
                if (next instanceof FormContainer) {
                    ((FormContainer)((Object)next)).invalidateParentInfo();
                    continue;
                }
                this.invalidateParentInfo(next);
            }
        }
    }

    public Collection<FormContainer> getSubContainer(FormContainer container) {
        HashSet<FormContainer> containers = new HashSet<FormContainer>();
        if (container != null) {
            this.findSubContainer(containers, container);
        }
        return containers;
    }

    private void findSubContainer(Set<FormContainer> containers, FormContainer container) {
        for (Component component : ((Container)((Object)container)).getComponents()) {
            if (!(component instanceof FormContainer) || !containers.add((FormContainer)((Object)component))) continue;
            this.findSubContainer(containers, (FormContainer)((Object)component));
        }
    }

    public FormComponentBinding getBinding(FormContainer container, FormComponent component) {
        for (FormContainer subContainer : this.getSubContainer(container)) {
            FormComponentBinding binding = subContainer.getBinder().getBinding(component);
            if (binding == null) continue;
            return binding;
        }
        return null;
    }

    public FormComponentBinding getBinding(FormContainer container, String bindingPath) {
        for (FormContainer subContainer : this.getSubContainer(container)) {
            FormComponentBinding binding = subContainer.getBinder().getBinding(bindingPath);
            if (binding == null) continue;
            return binding;
        }
        return null;
    }

    public void requestFocusLater(Component c) {
        this.requestFocusLaterPending = true;
        EventQueue.invokeLater(c::requestFocusInWindow);
    }

    public void setWaitCursor(Component comp) {
        Component glassPane;
        Window w = this.getVisibleParentOrRelatedWindow(comp);
        Cursor c = Cursor.getPredefinedCursor(3);
        if (w instanceof RootPaneContainer && (glassPane = ((RootPaneContainer)((Object)w)).getGlassPane()) != null) {
            glassPane.setCursor(c);
            glassPane.setVisible(true);
        }
        if (w != null) {
            w.setCursor(c);
        }
    }

    public void setDefaultCursor(Component comp) {
        Component glassPane;
        Window w = this.getVisibleParentOrRelatedWindow(comp);
        Cursor c = Cursor.getDefaultCursor();
        if (w instanceof RootPaneContainer && (glassPane = ((RootPaneContainer)((Object)w)).getGlassPane()) != null) {
            glassPane.setCursor(null);
        }
        if (w != null) {
            w.setCursor(c);
        }
    }

    public void hideErrorPopup() {
        if (EventQueue.isDispatchThread()) {
            if (this.errorPopup != null) {
                this.errorPopup.hide();
                this.errorPopup = null;
            }
            if (this.popupComponent != null) {
                this.popupComponent.removeComponentListener(this.popupComponentListener);
                this.popupComponent.removeHierarchyListener(this.popupHierarchyListener);
                this.popupComponent = null;
            }
        } else {
            throw new IllegalStateException("operation only valid from dispatch-thread");
        }
    }

    public void showErrorPopup(FormComponent formComponent, String message) {
        this.hideErrorPopup();
        if (message != null && !message.isEmpty() && formComponent instanceof JComponent && ((JComponent)((Object)formComponent)).isShowing()) {
            JComponent comp = (JComponent)((Object)formComponent);
            ErrorToolTip toolTip = new ErrorToolTip(comp, message);
            Point loc = comp.getLocationOnScreen();
            this.errorPopup = PopupFactory.getSharedInstance().getPopup(comp, toolTip, loc.x + (comp.getWidth() >> 1), loc.y + comp.getHeight() + 2);
            this.popupComponent = comp;
            this.popupComponent.addComponentListener(this.popupComponentListener);
            this.popupComponent.addHierarchyListener(this.popupHierarchyListener);
            this.errorPopup.show();
        }
    }

    public Point getCenteredLocation(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        return new Point((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public Point getPreferredLocation(Window window, Window owner) {
        Point location;
        if (owner != null && owner.isShowing()) {
            Dimension windowSize = window.getSize();
            Dimension ownerSize = owner.getSize();
            location = owner.getLocation();
            location.x += (ownerSize.width - windowSize.width) / 2;
            location.y += (ownerSize.height - windowSize.height) / 2;
        } else {
            location = this.getCenteredLocation(window);
        }
        return this.getAlignedLocation(window, location);
    }

    public Point getAlignedLocation(Window window, Point location) {
        Dimension windowSize = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = screenSize.width * 19 / 20;
        int maxHeight = screenSize.height * 19 / 20;
        int minX = screenSize.width / 20;
        int minY = screenSize.height / 20;
        if (location.x + windowSize.width > maxWidth) {
            location.x = maxWidth - windowSize.width;
        }
        if (location.x < 0) {
            location.x = 0;
        } else if (location.x < minX && location.x + windowSize.width < maxWidth) {
            location.x = minX;
        }
        if (location.y + windowSize.height > maxHeight) {
            location.y = maxHeight - windowSize.height;
        }
        if (location.y < 0) {
            location.y = 0;
        } else if (location.y < minY && location.y + windowSize.height < maxHeight) {
            location.y = minY;
        }
        return this.getFreeLocation(window, location);
    }

    private Point getFreeLocation(Window window, Point startLocation) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = startLocation.x + window.getWidth() / 2;
        int y = startLocation.y + window.getHeight() / 2;
        int dx = x > screenSize.width / 2 ? -32 : 32;
        int dy = y > screenSize.height / 2 ? -24 : 24;
        for (int loop = 0; loop < 4; ++loop) {
            boolean abort = false;
            Point location = new Point(startLocation);
            while (!abort && this.isWindowOverlaying(window, location, dx, dy)) {
                location.x += dx;
                location.y += dy;
                if (location.x < 0) {
                    location.x = 0;
                    abort = true;
                }
                if (location.x + window.getWidth() > screenSize.width) {
                    location.x = screenSize.width - window.getWidth();
                    abort = true;
                }
                if (location.y < 0) {
                    location.y = 0;
                    abort = true;
                }
                if (location.y + window.getHeight() <= screenSize.height) continue;
                location.y = screenSize.height - window.getHeight();
                abort = true;
            }
            if (!abort) {
                return location;
            }
            if (dx > 0 && dy > 0) {
                dx = -32;
                continue;
            }
            if (dx < 0 && dy > 0) {
                dy = -24;
                continue;
            }
            if (dx < 0 && dy < 0) {
                dx = 32;
                continue;
            }
            if (dx <= 0 || dy >= 0) continue;
            dy = 24;
        }
        return startLocation;
    }

    private boolean isWindowOverlaying(Window window, Point location, int dx, int dy) {
        Window owner = window.getOwner();
        if (dx < 0) {
            dx = -dx;
        }
        if (dy < 0) {
            dy = -dy;
        }
        for (Window w : this.windows) {
            if (!w.isShowing()) continue;
            Window o = w.getOwner();
            if (w == window || o != owner || (location.x > w.getX() + dx || location.x + window.getWidth() + dx < w.getX() + w.getWidth()) && (location.y > w.getY() + dy || location.y + window.getHeight() + dy < w.getY() + w.getHeight())) continue;
            return true;
        }
        return false;
    }

    public void setupDefaultBindings(final JComponent comp) {
        FormComponent fc;
        HashSet set = new HashSet();
        comp.setFocusTraversalKeys(0, set);
        set = new HashSet();
        comp.setFocusTraversalKeys(1, set);
        AbstractAction enterAction = new AbstractAction("focusNextFormComponent"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (comp instanceof FormFieldComponent) {
                    ((FormFieldComponent)((Object)comp)).postActionEvent();
                }
                if (comp instanceof FormTextArea) {
                    ((FormTextArea)comp).doSmartEnter();
                } else if (comp instanceof FormComponent) {
                    FormUtilities.this.requestFocusLaterPending = false;
                    ((FormComponent)((Object)comp)).prepareFocusLost();
                    if (!FormUtilities.this.requestFocusLaterPending) {
                        comp.transferFocus();
                    }
                } else {
                    comp.transferFocus();
                }
            }
        };
        comp.getActionMap().put(enterAction.getValue("Name"), enterAction);
        comp.getInputMap().put(KeyStroke.getKeyStroke(10, 0), enterAction.getValue("Name"));
        comp.getInputMap().put(KeyStroke.getKeyStroke(9, 0), enterAction.getValue("Name"));
        AbstractAction enterShiftAction = new AbstractAction("focusPreviousFormComponent"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (comp instanceof FormFieldComponent) {
                    ((FormFieldComponent)((Object)comp)).postActionEvent();
                }
                if (comp instanceof FormComponent) {
                    FormUtilities.this.requestFocusLaterPending = false;
                    ((FormComponent)((Object)comp)).prepareFocusLost();
                    if (!FormUtilities.this.requestFocusLaterPending) {
                        comp.transferFocusBackward();
                    }
                } else {
                    comp.transferFocusBackward();
                }
            }
        };
        comp.getActionMap().put(enterShiftAction.getValue("Name"), enterShiftAction);
        comp.getInputMap().put(KeyStroke.getKeyStroke(10, 1), enterShiftAction.getValue("Name"));
        comp.getInputMap().put(KeyStroke.getKeyStroke(9, 1), enterShiftAction.getValue("Name"));
        if (comp instanceof FormComponent) {
            fc = (FormComponent)((Object)comp);
            AbstractAction helpAction = new AbstractAction("showHelp"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    fc.showHelp();
                }
            };
            comp.getActionMap().put(helpAction.getValue("Name"), helpAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(156, 0), helpAction.getValue("Name"));
            comp.getInputMap().put(KeyStroke.getKeyStroke(112, 0), helpAction.getValue("Name"));
        }
        if (comp instanceof FormFieldComponent) {
            fc = (FormFieldComponent)((Object)comp);
            AbstractAction clearAllAction = new AbstractAction("clearText", (FormFieldComponent)fc){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ FormFieldComponent val$fc;
                {
                    this.val$fc = formFieldComponent;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.val$fc.isChangeable()) {
                        this.val$fc.clearText();
                    }
                }
            };
            comp.getActionMap().put(clearAllAction.getValue("Name"), clearAllAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(8, 1), clearAllAction.getValue("Name"));
            AbstractAction toggleInsertAction = new AbstractAction("toggleInsert", (FormFieldComponent)fc){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ FormFieldComponent val$fc;
                {
                    this.val$fc = formFieldComponent;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$fc.setOverwrite(!this.val$fc.isOverwrite());
                }
            };
            comp.getActionMap().put(toggleInsertAction.getValue("Name"), toggleInsertAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(155, 0), toggleInsertAction.getValue("Name"));
            AbstractAction caretLeftAction = new AbstractAction("caretLeft", (FormFieldComponent)fc){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ FormFieldComponent val$fc;
                {
                    this.val$fc = formFieldComponent;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$fc.setCaretLeft();
                }
            };
            comp.getActionMap().put(caretLeftAction.getValue("Name"), caretLeftAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(36, 0), caretLeftAction.getValue("Name"));
            comp.getInputMap().put(KeyStroke.getKeyStroke(65368, 0), caretLeftAction.getValue("Name"));
            AbstractAction caretRightAction = new AbstractAction("caretRight", (FormFieldComponent)fc){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ FormFieldComponent val$fc;
                {
                    this.val$fc = formFieldComponent;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$fc.setCaretRight();
                }
            };
            comp.getActionMap().put(caretRightAction.getValue("Name"), caretRightAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(35, 0), caretRightAction.getValue("Name"));
            AbstractAction upLeftAction = new AbstractAction("upLeft", (FormFieldComponent)fc){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ FormFieldComponent val$fc;
                {
                    this.val$fc = formFieldComponent;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$fc.upLeft();
                }
            };
            comp.getActionMap().put(upLeftAction.getValue("Name"), upLeftAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(38, 0), upLeftAction.getValue("Name"));
            AbstractAction downRightAction = new AbstractAction("downRight", (FormFieldComponent)fc){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ FormFieldComponent val$fc;
                {
                    this.val$fc = formFieldComponent;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$fc.downRight();
                }
            };
            comp.getActionMap().put(downRightAction.getValue("Name"), downRightAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), downRightAction.getValue("Name"));
        }
    }

    public void savePreferredSizes(Component comp, String prefName, boolean system) {
        int[] counter = new int[]{0};
        try {
            PersistedPreferences prefs = system ? PersistedPreferences.systemRoot().node(prefName) : PersistedPreferences.userRoot().node(prefName);
            this.savePreferredSizes(comp, prefs, counter);
        }
        catch (RuntimeException | BackingStoreException ex) {
            FormError.showException(SwingSwingBundle.getString("PREFERENCES COULD NOT BE SAVED"), ex);
        }
    }

    private void savePreferredSizes(Component comp, PersistedPreferences prefs, int[] counter) throws BackingStoreException {
        if (comp instanceof JScrollPane) {
            counter[0] = counter[0] + 1;
            prefs.putInt("height_" + counter[0], comp.getHeight());
            prefs.putInt("width_" + counter[0], comp.getWidth());
            prefs.flush();
        } else if (comp instanceof Container) {
            for (Component component : ((Container)comp).getComponents()) {
                this.savePreferredSizes(component, prefs, counter);
            }
        }
    }

    public void loadPreferredSizes(Component comp, String prefName, boolean system) {
        int[] counter = new int[]{0};
        try {
            PersistedPreferences sysPrefs = PersistedPreferences.systemRoot().node(prefName);
            PersistedPreferences userPrefs = system ? null : PersistedPreferences.userRoot().node(prefName);
            this.loadPreferredSizes(comp, sysPrefs, userPrefs, counter);
        }
        catch (RuntimeException | BackingStoreException ex) {
            FormError.showException(SwingSwingBundle.getString("PREFERENCES COULD NOT BE LOADED"), ex);
        }
    }

    private void loadPreferredSizes(Component comp, PersistedPreferences sysPrefs, PersistedPreferences userPrefs, int[] counter) throws BackingStoreException {
        if (comp instanceof JScrollPane) {
            counter[0] = counter[0] + 1;
            String key = "width_" + counter[0];
            int width = -1;
            if (userPrefs != null) {
                width = userPrefs.getInt(key, width);
            }
            if (width == -1) {
                width = sysPrefs.getInt(key, width);
            }
            key = "height_" + counter[0];
            int height = -1;
            if (userPrefs != null) {
                height = userPrefs.getInt(key, height);
            }
            if (height == -1) {
                height = sysPrefs.getInt(key, height);
            }
            if (width > 0 && height > 0) {
                comp.setPreferredSize(new Dimension(width, height));
            }
        } else if (comp instanceof Container) {
            for (Component component : ((Container)comp).getComponents()) {
                this.loadPreferredSizes(component, sysPrefs, userPrefs, counter);
            }
        }
    }

    public void installPreferredSizeMenu(Component comp, String prefName) {
        PreferredSizeMouseListener mouseListener = new PreferredSizeMouseListener(prefName);
        if (comp instanceof JScrollPane) {
            comp.addMouseListener(mouseListener);
        } else if (comp instanceof Container) {
            for (Component component : ((Container)comp).getComponents()) {
                this.installPreferredSizeMenu(component, prefName);
            }
        }
    }

    public String getPreferencesName(Class<?> clazz, String compName) {
        return "/" + clazz.getName().replace('.', '/') + "/" + compName;
    }

    public void setHelpURL(String aHelpURL) {
        this.helpURL = aHelpURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void openHelpURL(Component comp) {
        String url = null;
        if (comp instanceof FormComponent) {
            url = ((FormComponent)((Object)comp)).getHelpURL();
        } else if (comp instanceof FormContainer) {
            url = ((FormContainer)((Object)comp)).getHelpURL();
        } else if (comp instanceof FormButton) {
            url = ((FormButton)comp).getHelpURL();
        } else if (comp instanceof FormTable) {
            url = ((FormTable)comp).getHelpURL();
        }
        if (this.helpURL != null) {
            url = url != null ? this.helpURL + url : this.helpURL;
        }
        if (url != null) {
            try {
                FormInfo.show(MessageFormat.format(SwingSwingBundle.getString("OPENING HELP FOR <{0}> ..."), url), true, 5000L);
                Desktop.getDesktop().browse(URI.create(url));
            }
            catch (IOException | RuntimeException ex) {
                FormError.showException(MessageFormat.format(SwingSwingBundle.getString("CAN'T OPEN HELP FOR <{0}>"), url), ex);
            }
        }
    }

    private class EmptyEvent
    extends PaintEvent
    implements ActiveEvent {
        private boolean dispatched;
        private boolean queueEmpty;

        EmptyEvent() {
            super(new JLabel(), 801, new Rectangle());
            this.dispatched = false;
            this.queueEmpty = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDispatched() {
            EmptyEvent emptyEvent = this;
            synchronized (emptyEvent) {
                return this.dispatched;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isEventQueueEmpty() {
            EmptyEvent emptyEvent = this;
            synchronized (emptyEvent) {
                return this.queueEmpty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            EmptyEvent emptyEvent = this;
            synchronized (emptyEvent) {
                this.queueEmpty = FormUtilities.this.getEventQueue().peekEvent() == null;
                this.dispatched = true;
                this.notifyAll();
            }
        }
    }

    private class PreferredSizeMouseListener
    implements MouseListener {
        private final String prefName;

        public PreferredSizeMouseListener(String prefName) {
            this.prefName = prefName;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.processMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.processMouseEvent(e);
        }

        private void processMouseEvent(MouseEvent evt) {
            Component comp;
            if (evt.isPopupTrigger() && (comp = evt.getComponent()) != null) {
                Window window = FormUtilities.this.getParentWindow(comp);
                Component parent = window == null ? comp : window;
                JPopupMenu menu = new JPopupMenu();
                if (PersistedPreferencesFactory.getInstance().isSystemOnly()) {
                    if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                        JMenuItem saveItem = new JMenuItem(SwingSwingBundle.getString("SAVE SYSTEM PREFERENCES"));
                        saveItem.addActionListener(e -> {
                            if (FormQuestion.yesNo(SwingSwingBundle.getString("SAVE SYSTEM PREFERENCES FOR THIS WINDOW?"))) {
                                FormUtilities.this.savePreferredSizes(parent, this.prefName, true);
                            }
                        });
                        menu.add(saveItem);
                    }
                    JMenuItem restoreItem = new JMenuItem(SwingSwingBundle.getString("LOAD SYSTEM PREFERENCES"));
                    restoreItem.addActionListener(e -> {
                        FormUtilities.this.loadPreferredSizes(parent, this.prefName, true);
                        if (window != null) {
                            window.pack();
                        }
                    });
                    menu.add(restoreItem);
                } else {
                    if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                        JMenuItem saveItem = new JMenuItem(SwingSwingBundle.getString("SAVE USER PREFERENCES"));
                        saveItem.addActionListener(e -> {
                            if (FormQuestion.yesNo(SwingSwingBundle.getString("SAVE USER PREFERENCES FOR THIS WINDOW?"))) {
                                FormUtilities.this.savePreferredSizes(parent, this.prefName, false);
                            }
                        });
                        menu.add(saveItem);
                    }
                    JMenuItem restoreItem = new JMenuItem(SwingSwingBundle.getString("LOAD USER PREFERENCES"));
                    restoreItem.addActionListener(e -> {
                        FormUtilities.this.loadPreferredSizes(comp, this.prefName, false);
                        if (window != null) {
                            window.pack();
                        }
                    });
                    menu.add(restoreItem);
                    JMenuItem restoreSysItem = new JMenuItem(SwingSwingBundle.getString("LOAD SYSTEM PREFERENCES"));
                    restoreSysItem.addActionListener(e -> {
                        FormUtilities.this.loadPreferredSizes(parent, this.prefName, true);
                        if (window != null) {
                            window.pack();
                        }
                    });
                    menu.add(restoreSysItem);
                }
                menu.show(comp, evt.getX(), evt.getY());
            }
        }
    }

    private class AutoCloseThread
    extends Thread {
        private AutoCloseThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean keepRunning;
                do {
                    AutoCloseThread.sleep(1000L);
                    keepRunning = false;
                    Set set = FormUtilities.this.windows;
                    synchronized (set) {
                        for (Window w : FormUtilities.this.windows) {
                            if (!w.isVisible() || !(w instanceof FormWindow) || !((FormWindow)((Object)w)).isAutoCloseable()) continue;
                            keepRunning = true;
                            FormWindow fw = (FormWindow)((Object)w);
                            if (!fw.checkAutoClose()) continue;
                            EventQueue.invokeLater(() -> {
                                ((Window)((Object)fw)).dispose();
                                LOGGER.fine("autoclosing {0}", new Object[]{fw});
                            });
                        }
                    }
                } while (keepRunning);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Set set = FormUtilities.this.windows;
            synchronized (set) {
                LOGGER.fine("autoclose-thread stopped", new Object[0]);
                FormUtilities.this.autoCloseThread = null;
            }
        }
    }
}

