/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormSpinField;
import org.tentackle.swing.IntegerFormField;
import org.tentackle.swing.SpinEvent;
import org.tentackle.swing.SpinListener;
import org.tentackle.swing.ValueEvent;

public class HourSpinField
extends FormSpinField
implements SpinListener {
    private final IntegerFormField hourField = new IntegerFormField();

    public HourSpinField(int hour) {
        this.hourField.setColumns(2);
        this.hourField.setFormat("00");
        this.setFormComponent(this.hourField);
        this.setHour(hour);
        this.addSpinListener(this);
    }

    public HourSpinField() {
        this(0);
    }

    @Override
    public void valueEntered(ValueEvent e) {
        super.valueEntered(e);
        this.setHour(this.getHour());
    }

    public void setHour(int hour) {
        if ((hour %= 24) < 0) {
            hour += 24;
        }
        this.hourField.setIntValue(hour);
    }

    public int getHour() {
        return this.hourField.getIntValue();
    }

    @Override
    public void increment(SpinEvent e, FormComponent c) {
        this.setHour(this.getHour() + 1);
    }

    @Override
    public void decrement(SpinEvent e, FormComponent c) {
        this.setHour(this.getHour() - 1);
    }
}

