/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.swing.AbstractNumberFormField;
import org.tentackle.swing.SwingSwingBundle;

public class LongFormField
extends AbstractNumberFormField {
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;

    public LongFormField(Document doc, int columns) {
        super(doc, columns);
    }

    public LongFormField(int columns) {
        this((Document)null, columns);
    }

    public LongFormField() {
        this(0);
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long getFormValue() {
        String str = this.getText();
        if (str == null || (str = str.replace(this.getFiller(), ' ').trim()).length() <= 0) return null;
        try {
            Number value = this.decimalFormat.parse(str);
            if (value instanceof Long) {
                if ((Long)value > this.maxValue) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.maxValue);
                    return null;
                } else {
                    if ((Long)value >= this.minValue) return (Long)value;
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.minValue);
                }
                return null;
            } else if (value instanceof Double) {
                if ((Double)value > 0.0) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.maxValue);
                    return null;
                } else {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.minValue);
                }
                return null;
            } else {
                this.errorOffset = 0;
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
            }
            return null;
        }
        catch (ParseException e) {
            this.errorOffset = e.getErrorOffset();
            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
        }
        return null;
    }

    public long getLongValue() {
        Long value = this.getFormValue();
        return value == null ? 0L : value;
    }

    public void setLongValue(long value) {
        this.setFormValue(value);
    }
}

