/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.tentackle.swing.AbstractFormField;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;

public class FormFieldComboBox<E>
extends FormComboBox<E>
implements FormFieldComponent {
    private AbstractFormField editorField;
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (FormFieldComboBox.this.isEditable()) {
                if (FormFieldComboBox.this.isPopupVisible()) {
                    if (e.getModifiers() == 0) {
                        int index = FormFieldComboBox.this.getSelectedIndex();
                        if (e.getKeyCode() == 40 && index < FormFieldComboBox.this.getItemCount() - 1) {
                            FormFieldComboBox.this.setFormValueIndex(index + 1);
                        } else if (e.getKeyCode() == 38 && index > 0) {
                            FormFieldComboBox.this.setFormValueIndex(index - 1);
                        } else if (e.getKeyCode() == 10 || e.getKeyCode() == 27 || e.getKeyCode() == 114) {
                            FormFieldComboBox.this.hidePopup();
                        }
                        if (e.getKeyCode() != 10) {
                            e.consume();
                        }
                    }
                } else if (e.getKeyCode() == 114 || e.isControlDown() && (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 10) || e.getKeyCode() == 40 && FormFieldComboBox.this.isCaretRight() && FormFieldComboBox.this.isCellEditorUsage() || e.getKeyCode() == 38 && FormFieldComboBox.this.isCaretLeft() && FormFieldComboBox.this.isCellEditorUsage()) {
                    FormFieldComboBox.this.showPopup();
                    e.consume();
                } else if (e.getKeyCode() == 9 && FormFieldComboBox.this.isCellEditorUsage()) {
                    e.setKeyCode(10);
                }
            }
        }
    };
    private final PopupMenuListener popupListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            String text;
            int matchIndex;
            if (FormFieldComboBox.this.isEditable() && (matchIndex = FormFieldComboBox.this.getItemIndexWithLeadString(text = FormFieldComboBox.this.getFormValueText(), FormFieldComboBox.this.getModel())) >= 0) {
                FormFieldComboBox.this.setFormValueIndex(matchIndex);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    };

    public FormFieldComboBox(AbstractFormField editorField) {
        this.setEditorField(editorField);
        this.setup();
    }

    public FormFieldComboBox() {
        this((AbstractFormField)null);
    }

    public FormFieldComboBox(AbstractFormField editorField, E[] items) {
        super(items);
        this.setEditorField(editorField);
        this.setup();
    }

    public FormFieldComboBox(E[] items) {
        this(null, items);
    }

    protected void setup() {
        this.setEditor(new FormFieldComboBoxEditor());
        this.setRenderer(new FormFieldComboBoxRenderer());
        this.addPopupMenuListener(this.popupListener);
    }

    public void setEditorField(AbstractFormField editorField) {
        if (this.isEditable() && this.editorField != null) {
            this.editorField.removeFocusListener(this);
        }
        if (this.editorField != null) {
            this.editorField.removeKeyListener(this.keyListener);
        }
        this.editorField = editorField == null ? new StringFormField() : editorField;
        if (this.isEditable()) {
            this.editorField.addFocusListener(this);
        }
        this.editorField.addKeyListener(this.keyListener);
    }

    public AbstractFormField getEditorField() {
        return this.editorField;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isEditable()) {
            return this.editorField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            this.editorField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.editorField.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.editorField.getToolTipText();
    }

    @Override
    public boolean wasTransferFocus() {
        return this.isEditable() ? this.editorField.wasTransferFocus() : super.wasTransferFocus();
    }

    @Override
    public boolean wasTransferFocusBackward() {
        return this.isEditable() ? this.editorField.wasTransferFocusBackward() : super.wasTransferFocusBackward();
    }

    @Override
    public boolean wasFocusGainedFromTransfer() {
        return this.isEditable() ? this.editorField.wasFocusGainedFromTransfer() : super.wasFocusGainedFromTransfer();
    }

    @Override
    public boolean wasFocusGainedFromTransferBackward() {
        return this.isEditable() ? this.editorField.wasFocusGainedFromTransferBackward() : super.wasFocusGainedFromTransferBackward();
    }

    @Override
    public boolean wasTransferFocusByEnter() {
        return this.isEditable() ? this.editorField.wasTransferFocusByEnter() : super.wasTransferFocusByEnter();
    }

    @Override
    public Object getValueShown() {
        return this.isEditable() ? this.getEditorField().getValueShown() : super.getSelectedItem();
    }

    @Override
    public void fireValueEntered() {
        if (this.isEditable()) {
            this.setFormValueText(this.editorField.getText());
        }
        super.fireValueEntered();
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary() && this.isEditable() && !this.isCellEditorUsage() && this.isAutoUpdate()) {
            this.fireValueChanged();
        }
    }

    @Override
    public boolean setFormValueText(String text) {
        boolean rv = super.setFormValueText(text);
        this.editorField.setText(text);
        return rv;
    }

    @Override
    public void setFormat(String format) {
        this.editorField.setFormat(format);
    }

    @Override
    public String getFormat() {
        return this.editorField.getFormat();
    }

    @Override
    public void setColumns(int columns) {
        this.editorField.setColumns(columns);
    }

    @Override
    public int getColumns() {
        return this.editorField.getColumns();
    }

    @Override
    public void setAutoSelect(boolean autoselect) {
        this.editorField.setAutoSelect(autoselect);
    }

    @Override
    public boolean isAutoSelect() {
        return this.editorField.isAutoSelect();
    }

    @Override
    public void setAutoNext(boolean autonext) {
        this.editorField.setAutoNext(autonext);
    }

    @Override
    public boolean isAutoNext() {
        return this.editorField.isAutoNext();
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.editorField.setAutoUpdate(autoupdate);
    }

    @Override
    public boolean isAutoUpdate() {
        return this.editorField.isAutoUpdate();
    }

    @Override
    public void setConvert(char convert) {
        this.editorField.setConvert(convert);
    }

    @Override
    public char getConvert() {
        return this.editorField.getConvert();
    }

    @Override
    public void setAdjust(char adjust) {
        this.editorField.setAdjust(adjust);
    }

    @Override
    public void setConverter(Function<String, String> converter) {
        this.editorField.setConverter(converter);
    }

    @Override
    public Function<String, String> getConverter() {
        return this.editorField.getConverter();
    }

    @Override
    public char getAdjust() {
        return this.editorField.getAdjust();
    }

    @Override
    public void setMaxColumns(int columns) {
        this.editorField.setMaxColumns(columns);
    }

    @Override
    public int getMaxColumns() {
        return this.editorField.getMaxColumns();
    }

    @Override
    public void setDefaultColumns(int columns) {
        this.editorField.setDefaultColumns(columns);
    }

    @Override
    public int getDefaultColumns() {
        return this.editorField.getDefaultColumns();
    }

    @Override
    public void setFiller(char filler) {
        this.editorField.setFiller(filler);
    }

    @Override
    public char getFiller() {
        return this.editorField.getFiller();
    }

    @Override
    public void setOverwrite(boolean override) {
        this.editorField.setOverwrite(override);
    }

    @Override
    public boolean isOverwrite() {
        return this.editorField.isOverwrite();
    }

    @Override
    public void setValidChars(String str) {
        this.editorField.setValidChars(str);
    }

    @Override
    public String getValidChars() {
        return this.editorField.getValidChars();
    }

    @Override
    public void setInvalidChars(String str) {
        this.editorField.setInvalidChars(str);
    }

    @Override
    public String getInvalidChars() {
        return this.editorField.getInvalidChars();
    }

    @Override
    public void setEraseFirst(boolean erasefirst) {
        this.editorField.setEraseFirst(erasefirst);
    }

    @Override
    public boolean isEraseFirst() {
        return this.editorField.isEraseFirst();
    }

    @Override
    public void setCaretPosition(int pos) {
        this.editorField.setCaretPosition(pos);
    }

    @Override
    public int getCaretPosition() {
        return this.editorField.getCaretPosition();
    }

    @Override
    public boolean isCaretLeft() {
        return this.editorField.isCaretLeft();
    }

    @Override
    public boolean isCaretRight() {
        return this.editorField.isCaretRight();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        this.editorField.setHorizontalAlignment(alignment);
    }

    @Override
    public int getHorizontalAlignment() {
        return this.editorField.getHorizontalAlignment();
    }

    @Override
    public void setVerticalAlignment(int alignment) {
        this.editorField.setVerticalAlignment(alignment);
    }

    @Override
    public int getVerticalAlignment() {
        return this.editorField.getVerticalAlignment();
    }

    @Override
    public void requestFocusLater() {
        FormUtilities.getInstance().requestFocusLater(this);
    }

    @Override
    public boolean isInhibitAutoSelect() {
        return this.editorField.isInhibitAutoSelect();
    }

    @Override
    public void setInhibitAutoSelect(boolean inhibitAutoSelect) {
        this.editorField.setInhibitAutoSelect(inhibitAutoSelect);
    }

    @Override
    public void clearText() {
        this.editorField.clearText();
    }

    @Override
    public void setCaretLeft() {
        this.editorField.setCaretLeft();
    }

    @Override
    public void setCaretRight() {
        this.editorField.setCaretRight();
    }

    @Override
    public void upLeft() {
        if (this.isPopupVisible()) {
            int max = this.getItemCount();
            if (max > 0) {
                int ndx = this.getSelectedIndex();
                if (ndx != -1 && ndx > 0) {
                    this.setSelectedIndex(ndx - 1);
                } else {
                    this.setSelectedIndex(max - 1);
                }
            }
        } else {
            this.editorField.upLeft();
        }
    }

    @Override
    public void downRight() {
        if (this.isPopupVisible()) {
            int max = this.getItemCount();
            if (max > 0) {
                int ndx = this.getSelectedIndex();
                if (ndx == -1 || ndx < max - 1) {
                    this.setSelectedIndex(ndx + 1);
                } else {
                    this.setSelectedIndex(0);
                }
            }
        } else {
            this.editorField.downRight();
        }
    }

    @Override
    public int getErrorOffset() {
        return this.editorField.getErrorOffset();
    }

    @Override
    public void setErrorOffset(int errorOffset) {
        this.editorField.setErrorOffset(errorOffset);
    }

    @Override
    public String getErrorMessage() {
        return this.editorField.getErrorMessage();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.editorField.setErrorMessage(errorMessage);
    }

    @Override
    public void setText(String str) {
        this.editorField.setText(str);
    }

    @Override
    public String getText() {
        return this.editorField.getText();
    }

    @Override
    public boolean isEmpty() {
        return this.editorField.isEmpty();
    }

    @Override
    public String doFormat(Object object) {
        return this.editorField.doFormat(object);
    }

    @Override
    public void setStartEditLeftmost(boolean startEditLeftmost) {
        this.editorField.setStartEditLeftmost(startEditLeftmost);
    }

    @Override
    public boolean isStartEditLeftmost() {
        return this.editorField.isStartEditLeftmost();
    }

    @Override
    public void postActionEvent() {
        this.editorField.postActionEvent();
    }

    @Override
    public void saveValue() {
        this.editorField.saveValue();
        super.saveValue();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.editorField.setMandatory(mandatory);
    }

    private class FormFieldComboBoxRenderer
    extends BasicComboBoxRenderer {
        private FormFieldComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(FormFieldComboBox.this.editorField.doFormat(value));
            return this;
        }
    }

    private class FormFieldComboBoxEditor
    extends BasicComboBoxEditor
    implements Serializable {
        private FormFieldComboBoxEditor() {
        }

        @Override
        public Component getEditorComponent() {
            return FormFieldComboBox.this.editorField;
        }

        @Override
        public void setItem(Object obj) {
            FormFieldComboBox.this.editorField.setFormValue(obj);
        }

        @Override
        public Object getItem() {
            return FormFieldComboBox.this.editorField.getFormValue();
        }
    }
}

