/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.FormWrapEvent;
import org.tentackle.swing.FormWrapListener;
import org.tentackle.swing.TooltipDisplay;
import org.tentackle.swing.bind.FormComponentBinder;

public class FormFrame
extends JFrame
implements FormWindow,
ContainerListener {
    private String helpURL;
    private TooltipDisplay tooltipDisplay;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean triggerValuesChangedEnabled = true;
    private boolean autoPosition;
    private EventListenerList listeners;
    private int uiVersion = 0;
    private boolean keepChanged;
    private long autoClose = 0L;
    private long lastValuesChanged;
    private FormWindow relatedWindow;
    private Window parentWindow;
    private boolean parentWindowLoaded;
    private boolean bindable = true;
    private boolean autoUpdate = true;
    private FormComponentBinder binder;

    public FormFrame(String title) {
        super(title == null ? "" : title);
        FormUtilities.getInstance().setDefaultFocusTraversalPolicy(this);
        FormUtilities.getInstance().setUIVersionOfFormWindow(this);
        this.enableEvents(64L);
        this.getContentPane().addContainerListener(this);
        this.setAutoClose(FormUtilities.getInstance().getAutoClose());
    }

    public FormFrame() {
        this((String)null);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        FormUtilities.getInstance().processWindowEvent(e);
        super.processWindowEvent(e);
    }

    @Override
    public void pack() {
        super.pack();
        if (this.autoPosition) {
            this.alignLocation();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        FormUtilities.getInstance().modalToFront();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component comp = e.getChild();
        if (comp instanceof FormComponent) {
            ((FormComponent)((Object)comp)).invalidateParentInfo();
        } else {
            FormUtilities.getInstance().invalidateParentInfo(comp);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.componentAdded(e);
    }

    @Override
    public Window getParentWindow() {
        if (!this.parentWindowLoaded) {
            this.parentWindow = FormUtilities.getInstance().getParentWindow(this);
            this.parentWindowLoaded = true;
        }
        return this.parentWindow;
    }

    @Override
    public void invalidateParentInfo() {
        this.parentWindowLoaded = false;
        FormUtilities.getInstance().invalidateParentInfo(this.getContentPane());
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.autoUpdate = autoupdate;
        FormUtilities.getInstance().setAutoUpdate(this, this.autoUpdate);
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setFormValues() {
        if (this.binder != null) {
            this.binder.requestMandatoryUpdate();
            this.binder.requestChangeableUpdate();
        }
        if (this.keepChanged) {
            this.setFormValuesKeepChanged();
        } else {
            FormUtilities.getInstance().setFormValue(this.getContentPane());
        }
    }

    @Override
    public void setFormValuesKeepChanged() {
        if (this.binder != null) {
            this.binder.requestMandatoryUpdate();
            this.binder.requestChangeableUpdate();
        }
        FormUtilities.getInstance().setFormValueKeepChanged(this.getContentPane());
    }

    @Override
    public void getFormValues() {
        FormUtilities.getInstance().getFormValue(this.getContentPane());
    }

    @Override
    public void saveValues() {
        FormUtilities.getInstance().saveValue(this.getContentPane());
    }

    @Override
    public boolean areValuesChanged() {
        return FormUtilities.getInstance().isValueChanged(this.getContentPane(), true);
    }

    @Override
    public void triggerValuesChanged() {
        this.lastValuesChanged = System.currentTimeMillis();
    }

    @Override
    public void setTriggerValuesChangedEnabled(boolean enabled) {
        this.triggerValuesChangedEnabled = enabled;
    }

    @Override
    public boolean isTriggerValuesChangedEnabled() {
        return this.triggerValuesChangedEnabled;
    }

    @Override
    public void setChangeable(boolean flag) {
        if (this.isHonourChangeable()) {
            FormUtilities.getInstance().setChangeable(this, flag);
            this.changeable = flag;
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    @Override
    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public void showHelp() {
        FormUtilities.getInstance().openHelpURL(this);
    }

    @Override
    public int getUIVersion() {
        return this.uiVersion;
    }

    @Override
    public void setUIVersion(int version) {
        this.uiVersion = version;
    }

    @Override
    public void setTooltipDisplay(TooltipDisplay display) {
        this.tooltipDisplay = display;
    }

    @Override
    public TooltipDisplay getTooltipDisplay() {
        return this.tooltipDisplay;
    }

    @Override
    public void fireFormWrappedFocus(FormWrapEvent evt) {
        if (this.listeners != null) {
            Object[] lList = this.listeners.getListenerList();
            for (int i = lList.length - 2; i >= 0; i -= 2) {
                if (lList[i] != FormWrapListener.class) continue;
                ((FormWrapListener)lList[i + 1]).formWrapped(evt);
            }
        }
    }

    @Override
    public void addFormWrapListener(FormWrapListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(FormWrapListener.class, l);
    }

    @Override
    public void removeFormWrapListener(FormWrapListener l) {
        if (this.listeners != null) {
            this.listeners.remove(FormWrapListener.class, l);
        }
    }

    @Override
    public void setAutoPosition(boolean flag) {
        this.autoPosition = flag;
    }

    @Override
    public boolean isAutoPosition() {
        return this.autoPosition;
    }

    @Override
    public void setRelatedWindow(FormWindow relatedWindow) {
        this.relatedWindow = relatedWindow;
    }

    @Override
    public FormWindow getRelatedWindow() {
        return this.relatedWindow;
    }

    @Override
    public void alignLocation() {
        Point location = this.isShowing() ? FormUtilities.getInstance().getAlignedLocation(this, this.getLocation()) : FormUtilities.getInstance().getPreferredLocation(this, this.getOwner());
        if (!this.getLocation().equals(location)) {
            this.setLocation(location);
        }
    }

    @Override
    public void setKeepChangedValues(boolean keepChanged) {
        this.keepChanged = keepChanged;
    }

    @Override
    public boolean getKeepChangedValues() {
        return this.keepChanged;
    }

    @Override
    public long getTimeOfLastValuesChanged() {
        return this.lastValuesChanged;
    }

    @Override
    public void setTimeOfLastValuesChanged(long millis) {
        this.lastValuesChanged = millis;
    }

    @Override
    public void setAutoClose(long autoClose) {
        this.autoClose = autoClose;
    }

    @Override
    public long getAutoClose() {
        return this.autoClose;
    }

    @Override
    public boolean isAutoCloseable() {
        return this.autoClose > 0L;
    }

    @Override
    public boolean checkAutoClose() {
        return this.isAutoCloseable() && this.isVisible() && this.lastValuesChanged + this.autoClose < System.currentTimeMillis() && !this.areValuesChanged();
    }

    protected FormComponentBinder createBinder() {
        return FormUtilities.getInstance().getBindingFactory().createFormComponentBinder(this);
    }

    @Override
    public FormComponentBinder getBinder() {
        if (this.binder == null) {
            this.binder = this.createBinder();
        }
        return this.binder;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }
}

