/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormMailField
extends FormFieldComponentPanel {
    private String subject;
    private String body;
    private FormButton mailButton;
    private StringFormField mailField;

    public FormMailField() {
        this.initComponents();
        super.setFormComponent(this.mailField);
    }

    @Override
    public void setFormComponent(FormComponent comp) {
        throw new IllegalAccessError("changing the component is not allowed");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            ((Component)((Object)this.getFormComponent())).setName(name + "/mailAddress");
            this.mailButton.setName(name + "/sendMail");
        } else {
            ((Component)((Object)this.getFormComponent())).setName("mailAddress");
            this.mailButton.setName("sendMail");
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.mailButton.setFocusable(!flag);
    }

    private void initComponents() {
        this.mailField = new StringFormField();
        this.mailButton = new FormButton();
        this.setLayout(new GridBagLayout());
        this.mailField.setName("mailAddress");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)this.mailField, gridBagConstraints);
        this.mailButton.setIcon(PlafUtilities.getInstance().getIcon("mail"));
        this.mailButton.setMargin(new Insets(0, 0, 0, 0));
        this.mailButton.setName("sendMail");
        this.mailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormMailField.this.mailButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.mailButton, gridBagConstraints);
    }

    private void mailButtonActionPerformed(ActionEvent evt) {
        if (this.getText() != null && !this.getText().isEmpty()) {
            try {
                String url = this.getText();
                if (!url.toUpperCase().startsWith("MAILTO:")) {
                    url = "mailto:" + url;
                }
                boolean withArgs = false;
                if (this.subject != null && !this.subject.isEmpty()) {
                    url = url + "?subject=" + this.subject.replace(" ", "%20");
                    withArgs = true;
                }
                if (this.body != null && !this.body.isEmpty()) {
                    url = url + (withArgs ? "&" : "?") + "body=" + this.body.replace(" ", "%20").replace("\n", "%0d%0a");
                }
                Desktop.getDesktop().mail(URI.create(url));
            }
            catch (IOException ex) {
                FormError.showException(SwingSwingBundle.getString("MAILER COULD NOT BE LAUNCHED"), ex);
            }
        }
    }
}

