/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.tentackle.common.BMoney;
import org.tentackle.common.DMoney;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.FormatHelper;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.prefs.PreferencesInvalidException;
import org.tentackle.swing.AbstractFormField;
import org.tentackle.swing.AbstractFormTableModel;
import org.tentackle.swing.BMoneyFormField;
import org.tentackle.swing.BindableTableModel;
import org.tentackle.swing.ByteFormField;
import org.tentackle.swing.DateFormField;
import org.tentackle.swing.DoubleFormField;
import org.tentackle.swing.FloatFormField;
import org.tentackle.swing.FormChangeableComponent;
import org.tentackle.swing.FormCheckBox;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormComponentCellEditor;
import org.tentackle.swing.FormComponentPanel;
import org.tentackle.swing.FormFieldComboBox;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormFieldComponentCellEditor;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormRadioButton;
import org.tentackle.swing.FormTableCellRenderer;
import org.tentackle.swing.FormTableColumnModel;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.FormTableMap;
import org.tentackle.swing.FormTableTraversalEvent;
import org.tentackle.swing.FormTableTraversalListener;
import org.tentackle.swing.FormTableTraversalVetoException;
import org.tentackle.swing.FormTableUtilityPopup;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.IntegerFormField;
import org.tentackle.swing.LongFormField;
import org.tentackle.swing.ShortFormField;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.bind.FormTableBinding;

public class FormTable<T>
extends JTable
implements FormChangeableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormTable.class);
    public static final String PREF_TABLE_WIDTH = "width";
    public static final String PREF_TABLE_HEIGHT = "height";
    public static final String PREF_COLUMN_WIDTH = "w_";
    public static final String PREF_COLUMN_INDEX = "i_";
    public static final String PREF_COLUMN_VISIBILITY = "v_";
    public static final String CLICK_ACTION = "click";
    public static final String ENTER_ACTION = "enter";
    public static final String NEXTCELL_ACTION = "selectNextRowCell";
    public static final String PREVIOUSCELL_ACTION = "selectPreviousRowCell";
    public static final String HELP_ACTION = "helpURL";
    public static final int CELLTRAVERSAL_NONE = 0;
    public static final int CELLTRAVERSAL_COLUMN = 1;
    public static final int CELLTRAVERSAL_ROW = 2;
    public static final int CELLTRAVERSAL_NOTABLEWRAP = 16;
    public static final int CELLTRAVERSAL_SKIPNOEDIT = 32;
    public static final int CELLTRAVERSAL_AUTOEDIT = 64;
    public static final int CELLTRAVERSAL_TRANSFERFOCUS = 144;
    public static final int CELLTRAVERSAL_NOLINEWRAP = 20;
    public static final int CELLTRAVERSAL_WRAPINLINE = 24;
    protected final transient LinkedHashMap<Class<?>, TableCellRenderer> defaultRenderersByColumnInterface;
    protected final transient LinkedHashMap<Class<?>, TableCellEditor> defaultEditorsByColumnInterface;
    protected Dimension preferencesSize;
    private boolean sizeInPreferencesIgnored;
    private boolean createDefaultColumnsFromPreferences;
    private int cellTraversal = 0;
    private boolean inhibitCellTraversal;
    private boolean usingAbstractFormTableModel;
    private BindableTableModel<T> bindableModel;
    private boolean cellEditorFixed = true;
    private boolean cellRendererFixed = true;
    private boolean cellRectFixed = true;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean allChangeable = true;
    private boolean enableEnterAction;
    private int clicks;
    private int clickCountToAction = 2;
    private int clickCountToStart = 2;
    private String helpURL;
    private boolean cellDragEnabled = true;
    private boolean formTraversable;
    private FormTableUtilityPopup utilityPopup;
    private List<String> format;
    private List<DateFormat> dateFormat;
    private List<NumberFormat> numberFormat;
    private List<String> formatFlags;
    private List<Integer> maxColumns;
    private List<Integer> scales;
    private List<Integer> hAlignment;
    private List<Integer> vAlignment;
    private static final char FORMAT_AUTOSELECT = 'S';
    private static final char FORMAT_BLANKZERO = 'Z';
    private Color selectedForeground;
    private Color selectedBackground;
    private Color unselectedForeground;
    private Color unselectedBackground;
    private Color focusedForeground;
    private Color focusedBackground;
    private Color selectedMandatoryBackground;
    private Color unselectedMandatoryBackground;
    private int minRowHeight;
    private int maxRowHeight;
    private final Action nextCellAction;
    private final Action previousCellAction;
    private final Action helpAction;
    private long cellEventSerial;
    private long minCellEventSerial;
    private long paintCount;

    public FormTable(TableModel model) {
        this.setSelectedForeground(this.getSelectionForeground());
        this.setSelectedBackground(this.getSelectionBackground());
        this.setUnselectedForeground(this.getForeground());
        this.setUnselectedBackground(this.getBackground());
        this.setFocusedForeground(UIManager.getColor("Table.focusCellForeground"));
        this.setFocusedBackground(UIManager.getColor("Table.focusCellBackground"));
        Color color = UIManager.getColor("Table.unselectedMandatoryBackground");
        this.setUnselectedMandatoryBackground(color == null ? this.getBackground() : color);
        color = UIManager.getColor("Table.selectedMandatoryBackground");
        this.setSelectedMandatoryBackground(color == null ? this.getSelectionBackground() : color);
        this.nextCellAction = new NextCellAction();
        this.previousCellAction = new PreviousCellAction();
        this.helpAction = new AbstractAction(){
            private static final long serialVersionUID = -5644390861803492172L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FormUtilities.getInstance().openHelpURL(FormTable.this);
            }
        };
        this.getActionMap().put(NEXTCELL_ACTION, this.nextCellAction);
        this.getActionMap().put(PREVIOUSCELL_ACTION, this.previousCellAction);
        this.getActionMap().put(HELP_ACTION, this.helpAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), NEXTCELL_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 1), PREVIOUSCELL_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(156, 0), HELP_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), HELP_ACTION);
        this.cellTraversal = 0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    FormTable.this.clicks = e.getClickCount();
                    FormTable.this.doFireActionPerformed(FormTable.CLICK_ACTION);
                }
            }
        });
        this.defaultRenderersByColumnInterface = new LinkedHashMap();
        this.setDefaultRenderer(Object.class, new FormTableCellRenderer());
        this.setDefaultRenderer(String.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Date.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanTableCellRenderer());
        this.setDefaultRenderer(Byte.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Short.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Integer.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Long.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Float.class, new FormTableCellRenderer());
        this.setDefaultRenderer(Double.class, new FormTableCellRenderer());
        this.setDefaultRenderer(BMoney.class, new FormTableCellRenderer());
        this.defaultEditorsByColumnInterface = new LinkedHashMap();
        this.setDefaultEditor(String.class, new FormFieldComponentCellEditor(new StringFormField()));
        this.setDefaultEditor(Timestamp.class, new FormFieldComponentCellEditor(new DateFormField(FormatHelper.getShortTimestampPattern())));
        this.setDefaultEditor(Date.class, new FormFieldComponentCellEditor(new DateFormField()));
        this.setDefaultEditor(Byte.class, new FormFieldComponentCellEditor(new ByteFormField()));
        this.setDefaultEditor(Short.class, new FormFieldComponentCellEditor(new ShortFormField()));
        this.setDefaultEditor(Integer.class, new FormFieldComponentCellEditor(new IntegerFormField()));
        this.setDefaultEditor(Long.class, new FormFieldComponentCellEditor(new LongFormField()));
        this.setDefaultEditor(Float.class, new FormFieldComponentCellEditor(new FloatFormField()));
        this.setDefaultEditor(Double.class, new FormFieldComponentCellEditor(new DoubleFormField()));
        this.setDefaultEditor(DMoney.class, new FormFieldComponentCellEditor(new BMoneyFormField(true)));
        this.setDefaultEditor(BMoney.class, new FormFieldComponentCellEditor(new BMoneyFormField()));
        FormCheckBox box = new FormCheckBox();
        box.setHorizontalAlignment(0);
        box.setBackground(this.getFocusedBackground());
        this.setDefaultEditor(Boolean.class, new FormComponentCellEditor(box));
        if (model != null) {
            this.setModel(model);
        }
    }

    public FormTable() {
        this(null);
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public boolean isFormTraversable() {
        return this.formTraversable;
    }

    public void setFormTraversable(boolean formTraversable) {
        this.formTraversable = formTraversable;
    }

    public void setUtilityPopup(FormTableUtilityPopup utilityPopup) {
        this.uninstallUtilityPopup();
        this.utilityPopup = utilityPopup;
        this.installUtilityPopup();
    }

    protected void installUtilityPopup() {
        if (this.utilityPopup != null) {
            this.getTableHeader().addMouseListener(this.utilityPopup);
            this.addMouseListener(this.utilityPopup);
            JTableHeader header = this.getTableHeader();
            if (header != null) {
                header.addMouseListener(this.utilityPopup);
            }
            this.utilityPopup.setTable(this);
        }
    }

    protected void uninstallUtilityPopup() {
        if (this.utilityPopup != null) {
            this.getTableHeader().removeMouseListener(this.utilityPopup);
            this.removeMouseListener(this.utilityPopup);
            JTableHeader header = this.getTableHeader();
            if (header != null) {
                header.removeMouseListener(this.utilityPopup);
            }
            this.utilityPopup.setTable(null);
        }
    }

    public FormTableUtilityPopup getUtilityPopup() {
        return this.utilityPopup;
    }

    public void autoResizeColumnWidths() {
        for (int colNdx = 0; colNdx < this.getColumnCount(); ++colNdx) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.getColumnModel();
            TableColumn col = colModel.getColumn(colNdx);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            for (int rowNdx = 0; rowNdx < this.getRowCount(); ++rowNdx) {
                renderer = this.getCellRenderer(rowNdx, colNdx);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(rowNdx, colNdx), false, false, rowNdx, colNdx);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width + 10);
        }
    }

    public boolean isDataChanged() {
        TableModel m = this.getModel();
        return m instanceof AbstractFormTableModel && ((AbstractFormTableModel)m).isDataChanged();
    }

    public String getPreferencesName(FormTableEntry<?> entry) {
        if (entry != null) {
            return FormUtilities.getInstance().getPreferencesName(entry.getClass(), this.getName());
        }
        return null;
    }

    public String getPreferencesName() {
        TableModel model = this.getModel();
        if (model instanceof AbstractFormTableModel) {
            return this.getPreferencesName(((AbstractFormTableModel)model).getTemplate());
        }
        return null;
    }

    public boolean createDefaultColumnsFromPreferences(String prefName, boolean systemOnly) {
        TableModel m = this.getModel();
        boolean somePrefsLoaded = false;
        boolean somePrefsMissing = false;
        if (m != null) {
            int colCount = m.getColumnCount();
            PersistedPreferences systemPref = PersistedPreferences.systemRoot().node(prefName);
            PersistedPreferences userPref = systemOnly ? null : PersistedPreferences.userRoot().node(prefName);
            int width = -1;
            String key = PREF_TABLE_WIDTH;
            if (!systemOnly) {
                width = userPref.getInt(key, width);
            }
            if (width == -1) {
                width = systemPref.getInt(key, width);
            }
            int height = -1;
            key = PREF_TABLE_HEIGHT;
            if (!systemOnly) {
                height = userPref.getInt(key, height);
            }
            if (height == -1) {
                height = systemPref.getInt(key, height);
            }
            if (width > 0 && height > 0) {
                Container p;
                this.preferencesSize = new Dimension(width, height);
                if (!this.sizeInPreferencesIgnored && (p = this.getParent()) instanceof JViewport && (p = p.getParent()) instanceof JScrollPane) {
                    p.setPreferredSize(this.preferencesSize);
                }
            }
            TableColumn[] uCols = new TableColumn[colCount];
            boolean[] uVisible = new boolean[colCount];
            int uColCount = 0;
            TableColumn[] oCols = new TableColumn[colCount];
            boolean[] oVisible = new boolean[colCount];
            for (int i = 0; i < colCount; ++i) {
                oCols[i] = null;
                oVisible[i] = false;
                uVisible[i] = false;
            }
            boolean isAbstractFormTableModel = m instanceof AbstractFormTableModel;
            for (int i = 0; i < colCount; ++i) {
                TableColumn tc = new TableColumn(i);
                tc.setHeaderValue(isAbstractFormTableModel ? ((AbstractFormTableModel)m).getDisplayedColumnName(i) : m.getColumnName(i));
                key = PREF_COLUMN_WIDTH + m.getColumnName(i);
                width = -1;
                if (!systemOnly) {
                    width = userPref.getInt(key, width);
                }
                if (width == -1) {
                    width = systemPref.getInt(key, width);
                }
                if (width >= 0) {
                    tc.setPreferredWidth(width);
                }
                key = PREF_COLUMN_INDEX + m.getColumnName(i);
                int index = -1;
                if (!systemOnly) {
                    index = userPref.getInt(key, index);
                }
                if (index == -1) {
                    index = systemPref.getInt(key, index);
                }
                key = PREF_COLUMN_VISIBILITY + m.getColumnName(i);
                int visible = -1;
                if (!systemOnly) {
                    visible = userPref.getInt(key, visible);
                }
                if (visible == -1) {
                    visible = systemPref.getInt(key, visible);
                }
                if (visible == 1) {
                    somePrefsLoaded = true;
                } else if (visible == -1) {
                    somePrefsMissing = true;
                }
                if (index >= 0 && index < colCount && oCols[index] == null) {
                    oCols[index] = tc;
                    oVisible[index] = true;
                    if (visible == -1) continue;
                    oVisible[index] = visible == 1;
                    continue;
                }
                uCols[uColCount] = tc;
                if (visible != -1) {
                    uVisible[uColCount] = visible == 1;
                }
                ++uColCount;
            }
            if (somePrefsLoaded) {
                if (somePrefsMissing && !FormQuestion.yesNo(MessageFormat.format("Table {0} has changed.\nSaved preferences are incomplete.\nApply preferences anyway?", StringHelper.lastAfter((String)prefName, (char)'/')))) {
                    return false;
                }
                TableColumnModel cm = this.getColumnModel();
                if (cm instanceof FormTableColumnModel) {
                    FormTableColumnModel fcm = (FormTableColumnModel)cm;
                    fcm.removeAllColumns();
                    uColCount = 0;
                    for (int i = 0; i < colCount; ++i) {
                        if (oCols[i] != null) {
                            fcm.addColumn(oCols[i]);
                            if (oVisible[i]) continue;
                            fcm.setOriginalColumnVisible(i, false);
                            continue;
                        }
                        fcm.addColumn(uCols[uColCount]);
                        if (!uVisible[uColCount]) {
                            fcm.setOriginalColumnVisible(i, false);
                        }
                        ++uColCount;
                    }
                } else {
                    while (cm.getColumnCount() > 0) {
                        cm.removeColumn(cm.getColumn(0));
                    }
                    uColCount = 0;
                    for (int i = 0; i < colCount; ++i) {
                        if (oCols[i] != null) {
                            cm.addColumn(oCols[i]);
                            continue;
                        }
                        cm.addColumn(uCols[uColCount++]);
                    }
                }
                this.configureRenderers();
                this.configureEditors();
            }
        }
        return somePrefsLoaded;
    }

    public Dimension getPreferencesSize() {
        return this.preferencesSize;
    }

    public boolean isCreateDefaultColumnsFromPreferences() {
        return this.createDefaultColumnsFromPreferences;
    }

    public void setCreateDefaultColumnsFromPreferences(boolean createDefaultColumnsFromPreferences) {
        this.createDefaultColumnsFromPreferences = createDefaultColumnsFromPreferences;
    }

    @Override
    public void createDefaultColumnsFromModel() {
        boolean columnsCreated = false;
        if (this.createDefaultColumnsFromPreferences && this.getModel() instanceof AbstractFormTableModel) {
            columnsCreated = this.createDefaultColumnsFromPreferences(this.getPreferencesName(), PersistedPreferencesFactory.getInstance().isSystemOnly());
        }
        if (!columnsCreated) {
            this.createDefaultColumnsFromDefaultModel();
        }
    }

    public void createDefaultColumnsFromDefaultModel() {
        TableColumnModel cm = this.getColumnModel();
        if (cm instanceof FormTableColumnModel) {
            ((FormTableColumnModel)cm).removeAllColumns();
        }
        super.createDefaultColumnsFromModel();
        this.configureRenderers();
        this.configureEditors();
        TableModel dm = this.getModel();
        if (dm instanceof AbstractFormTableModel) {
            for (int i = 0; i < dm.getColumnCount(); ++i) {
                TableColumn tc = cm.getColumn(i);
                tc.setHeaderValue(((AbstractFormTableModel)dm).getDisplayedColumnName(i));
            }
        }
    }

    public void savePreferences(String prefName, boolean system) throws BackingStoreException {
        Container p;
        PersistedPreferences prefs = system ? PersistedPreferences.systemRoot().node(prefName) : PersistedPreferences.userRoot().node(prefName);
        TableColumnModel cm = this.getColumnModel();
        if (cm instanceof FormTableColumnModel) {
            FormTableColumnModel fcm = (FormTableColumnModel)cm;
            int viewIndex = 0;
            Enumeration<TableColumn> ocols = fcm.getOriginalColumns();
            while (ocols.hasMoreElements()) {
                TableColumn tc = ocols.nextElement();
                String columnIdentifier = this.createColumnIdentifier(tc);
                prefs.putInt(PREF_COLUMN_WIDTH + columnIdentifier, tc.getPreferredWidth());
                prefs.putInt(PREF_COLUMN_INDEX + columnIdentifier, viewIndex);
                prefs.putInt(PREF_COLUMN_VISIBILITY + columnIdentifier, fcm.isOriginalColumnVisible(viewIndex) ? 1 : 0);
                ++viewIndex;
            }
        } else {
            int viewIndex = 0;
            Enumeration<TableColumn> cols = cm.getColumns();
            while (cols.hasMoreElements()) {
                TableColumn tc = cols.nextElement();
                String columnIdentifier = this.createColumnIdentifier(tc);
                prefs.putInt(PREF_COLUMN_WIDTH + columnIdentifier, tc.getPreferredWidth());
                prefs.putInt(PREF_COLUMN_INDEX + columnIdentifier, viewIndex);
                ++viewIndex;
            }
        }
        if ((p = this.getParent()) instanceof JViewport) {
            if ((p = p.getParent()) instanceof JScrollPane) {
                prefs.putInt(PREF_TABLE_HEIGHT, p.getHeight());
                prefs.putInt(PREF_TABLE_WIDTH, p.getWidth());
            }
        } else {
            prefs.putInt(PREF_TABLE_HEIGHT, -1);
            prefs.putInt(PREF_TABLE_WIDTH, this.getWidth());
        }
        try {
            prefs.flush();
        }
        catch (PreferencesInvalidException pix) {
            LOGGER.warning(pix.toString(), new Object[0]);
        }
    }

    protected String createColumnIdentifier(TableColumn column) {
        TableModel m = this.getModel();
        return m.getColumnName(column.getModelIndex());
    }

    public void setSelectedRow(int row) {
        this.selectionModel.setSelectionInterval(row, row);
    }

    public void setSelectedRows(int[] rows) {
        this.selectionModel.clearSelection();
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                this.selectionModel.addSelectionInterval(rows[i], rows[i]);
            }
        }
    }

    public void setSelectedColumn(int col) {
        this.columnModel.getSelectionModel().setSelectionInterval(col, col);
    }

    public void setSelectedColumns(int[] cols) {
        this.columnModel.getSelectionModel().clearSelection();
        if (cols != null) {
            for (int i = 0; i < cols.length; ++i) {
                this.columnModel.getSelectionModel().addSelectionInterval(cols[i], cols[i]);
            }
        }
    }

    public FormTableEntry<T> getEntryAt(int row) {
        if (row >= 0) {
            row = this.convertRowIndexToModel(row);
        }
        if (this.usingAbstractFormTableModel) {
            return ((AbstractFormTableModel)this.getModel()).getEntryAt(row);
        }
        return null;
    }

    public T getObjectAt(int row) {
        FormTableEntry<T> entry = this.getEntryAt(row);
        return entry == null ? null : (T)entry.getObject();
    }

    public T getSelectedObject() {
        int row = this.getSelectedRow();
        return row >= 0 ? (T)this.getObjectAt(row) : null;
    }

    protected void queueEvent(AWTEvent e) {
        EventQueue.invokeLater(() -> this.processEvent(e));
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof CellTraversalEvent) {
            if (this.cellEventSerial > this.minCellEventSerial) {
                if (((CellTraversalEvent)e).next) {
                    this.nextCellAction.actionPerformed(new CellActionEvent(this.cellTraversal));
                } else {
                    this.previousCellAction.actionPerformed(new CellActionEvent(this.cellTraversal));
                }
            }
        } else if (e instanceof CellEditingEvent) {
            if (this.cellEventSerial > this.minCellEventSerial) {
                CellEditingEvent cee = (CellEditingEvent)e;
                int row = cee.row;
                int col = cee.col;
                this.changeSelection(cee.row, cee.col, false, false);
                if (cee.mode != 0 && !this.isCellEditable(row, col)) {
                    int ct = this.cellTraversal;
                    if (ct == 0) {
                        ct = 1;
                    }
                    ct |= 0x60;
                    if (cee.mode == 1) {
                        this.nextCellAction.actionPerformed(new CellActionEvent(ct));
                    } else if (cee.mode == -1) {
                        this.previousCellAction.actionPerformed(new CellActionEvent(ct));
                    }
                } else {
                    this.editCellAt(row, col);
                }
            }
        } else {
            super.processEvent(e);
        }
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new FormTableColumnModel();
    }

    public void setColumnVisible(int columnIndex, boolean visible) {
        if (!(this.columnModel instanceof FormTableColumnModel)) {
            throw new IllegalArgumentException("column model is not FormTableColumnModel");
        }
        ((FormTableColumnModel)this.columnModel).setModelColumnVisible(columnIndex, visible);
    }

    public boolean isColumnVisible(int columnIndex) {
        if (this.columnModel instanceof FormTableColumnModel) {
            return ((FormTableColumnModel)this.columnModel).isModelColumnVisible(columnIndex);
        }
        throw new IllegalArgumentException("column model is not FormTableColumnModel");
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e != null && e.getID() == 401) {
            if (this.isEditing() && !this.isFocusOwner()) {
                if (e.getKeyCode() == 113) {
                    return false;
                }
            } else {
                if (condition == 1 && !Boolean.FALSE.equals(this.getClientProperty("JTable.autoStartsEdit")) && e.isAltDown()) {
                    return false;
                }
                if (condition == 0 && e.getKeyCode() == 10 && this.enableEnterAction && this.getSelectedRow() >= 0) {
                    this.clicks = this.clickCountToAction;
                    this.doFireActionPerformed(ENTER_ACTION);
                    return false;
                }
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setSelectedForeground(Color c) {
        this.selectedForeground = c;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedBackground(Color c) {
        this.selectedBackground = c;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setUnselectedForeground(Color c) {
        this.unselectedForeground = c;
    }

    public Color getUnselectedForeground() {
        return this.unselectedForeground;
    }

    public void setUnselectedBackground(Color c) {
        this.unselectedBackground = c;
    }

    public Color getUnselectedBackground() {
        return this.unselectedBackground;
    }

    public void setFocusedForeground(Color c) {
        this.focusedForeground = c;
    }

    public Color getFocusedForeground() {
        return this.focusedForeground;
    }

    public void setFocusedBackground(Color c) {
        this.focusedBackground = c;
    }

    public Color getFocusedBackground() {
        return this.focusedBackground;
    }

    public Color getSelectedMandatoryBackground() {
        return this.selectedMandatoryBackground;
    }

    public void setSelectedMandatoryBackground(Color selectedMandatoryBackground) {
        this.selectedMandatoryBackground = selectedMandatoryBackground;
    }

    public Color getUnselectedMandatoryBackground() {
        return this.unselectedMandatoryBackground;
    }

    public void setUnselectedMandatoryBackground(Color unselectedMandatoryBackground) {
        this.unselectedMandatoryBackground = unselectedMandatoryBackground;
    }

    public boolean isEditing(int row, int column) {
        return this.isEditing() && this.getEditingRow() == row && this.getEditingColumn() == column;
    }

    private boolean shouldStartEditing(int row, int column) {
        if (this.isEditing(row, column)) {
            Component comp = this.getEditorComponent();
            if (comp instanceof FormFieldComponent && ((FormFieldComponent)((Object)comp)).isAutoSelect()) {
                ((FormFieldComponent)((Object)comp)).setInhibitAutoSelect(true);
            }
            return false;
        }
        return true;
    }

    public void editCellLater(int row, int column) {
        if (this.shouldStartEditing(row, column)) {
            this.queueEvent(new CellEditingEvent(0, row, column));
        }
    }

    public void editNextCellLater(int row, int column) {
        if (this.shouldStartEditing(row, column)) {
            this.queueEvent(new CellEditingEvent(1, row, column));
        }
    }

    public void editPreviousCellLater(int row, int column) {
        if (this.shouldStartEditing(row, column)) {
            this.queueEvent(new CellEditingEvent(-1, row, column));
        }
    }

    public void editNextCellLater() {
        this.queueEvent(new CellTraversalEvent(true));
    }

    public void editPreviousCellLater() {
        this.queueEvent(new CellTraversalEvent(false));
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (!this.isCellRectFixed()) {
            FormTableEntry entry = ((AbstractFormTableModel)this.getModel()).getEntryAt(row);
            int refRow = entry.getReferencedRow(row, column);
            int refColumn = entry.getReferencedColumn(row, column);
            row = refRow;
            column = refColumn;
        }
        if (super.editCellAt(row, column, e)) {
            if (this.getSurrendersFocusOnKeystroke()) {
                Component editor = this.getEditorComponent();
                editor.requestFocusInWindow();
                AWTEvent evt = EventQueue.getCurrentEvent();
                if (evt instanceof KeyEvent) {
                    KeyEvent kevt = (KeyEvent)evt;
                    char key = kevt.getKeyChar();
                    if (!kevt.isConsumed() && !kevt.isActionKey() && kevt.getKeyCode() != 10 && kevt.getKeyCode() != 27) {
                        if (editor instanceof FormComboBox || editor instanceof FormCheckBox || editor instanceof FormRadioButton) {
                            if (key != '\uffff') {
                                if (editor instanceof FormComboBox) {
                                    FormComboBox box = (FormComboBox)editor;
                                    if (box.isEditable()) {
                                        Component field = box.getEditor().getEditorComponent();
                                        if (field instanceof AbstractFormField && ((AbstractFormField)field).isAutoSelect()) {
                                            ((AbstractFormField)field).clearText();
                                            ((AbstractFormField)field).setInhibitAutoSelect(true);
                                        }
                                    } else {
                                        EventQueue.invokeLater(() -> box.selectWithKeyChar(key));
                                    }
                                } else {
                                    EventQueue.invokeLater(() -> editor.dispatchEvent(new KeyEvent(editor, 401, kevt.getWhen() + 1L, kevt.getModifiers(), 0, key)));
                                }
                            }
                        } else if (editor instanceof FormComponentPanel) {
                            FormComponent field = ((FormComponentPanel)editor).getFormComponent();
                            if (field instanceof FormFieldComponent && ((FormFieldComponent)field).isAutoSelect()) {
                                field.setFormValue(null);
                            }
                            if (key != '\uffff') {
                                ((Component)((Object)field)).dispatchEvent(new KeyEvent((Component)((Object)field), 400, kevt.getWhen() + 1L, kevt.getModifiers(), 0, key));
                            }
                        } else if (editor instanceof FormFieldComponent && ((FormFieldComponent)((Object)editor)).isAutoSelect()) {
                            ((FormFieldComponent)((Object)editor)).setFormValue(null);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        Component comp = this.getEditorComponent();
        super.editingStopped(e);
        if (comp instanceof FormComponent && this.cellTraversal != 0 && !this.inhibitCellTraversal && (EventQueue.getCurrentEvent() instanceof FocusEvent || EventQueue.getCurrentEvent() instanceof KeyEvent) && ((FormComponent)((Object)comp)).wasTransferFocusByEnter()) {
            this.queueEvent(new CellTraversalEvent(!((FormComponent)((Object)comp)).wasTransferFocusBackward()));
        }
        this.inhibitCellTraversal = false;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
    }

    public void inhibitCellTraversal() {
        this.inhibitCellTraversal = true;
    }

    public void clearInhibitCellTraversal() {
        this.inhibitCellTraversal = false;
    }

    public void discardCellEvents() {
        this.minCellEventSerial = this.cellEventSerial;
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (dataModel instanceof AbstractFormTableModel) {
            this.usingAbstractFormTableModel = true;
            ((AbstractFormTableModel)dataModel).setTable(this);
        } else {
            this.usingAbstractFormTableModel = false;
        }
        this.bindableModel = FormTable.findBindableTableModel(dataModel);
        super.setModel(dataModel);
        if (this.usingAbstractFormTableModel) {
            this.applyTemplate(((AbstractFormTableModel)dataModel).getTemplate());
            this.configureRenderers();
            this.configureEditors();
        } else {
            this.applyTemplate(null);
        }
        this.setClickCountToStart(this.clickCountToStart);
    }

    public static BindableTableModel<?> findBindableTableModel(TableModel model) {
        BindableTableModel bindableModel = null;
        while (model != null) {
            if (model instanceof BindableTableModel) {
                bindableModel = (BindableTableModel)((Object)model);
            }
            if (model instanceof FormTableMap) {
                model = ((FormTableMap)model).getModel();
                continue;
            }
            model = null;
        }
        return bindableModel;
    }

    public void applyTemplate(FormTableEntry<T> template) {
        int columns = this.dataModel.getColumnCount();
        this.format = new ArrayList<String>(columns);
        this.formatFlags = new ArrayList<String>(columns);
        this.dateFormat = new ArrayList<DateFormat>(columns);
        this.numberFormat = new ArrayList<NumberFormat>(columns);
        this.maxColumns = new ArrayList<Integer>(columns);
        this.scales = new ArrayList<Integer>(columns);
        this.hAlignment = new ArrayList<Integer>(columns);
        this.vAlignment = new ArrayList<Integer>(columns);
        if (template != null) {
            this.setCellEditorFixed(template.isCellEditorFixed());
            this.setCellRendererFixed(template.isCellRendererFixed());
            this.setCellRectFixed(template.isCellRectFixed());
            for (int i = 0; i < columns; ++i) {
                Character conv;
                Boolean autoSelect;
                String fmt = template.getFormat(i);
                this.format.add(fmt);
                this.formatFlags.add("");
                Boolean blankZero = template.isBlankZero(i);
                if (blankZero != null) {
                    this.setBlankZero(i, blankZero);
                }
                if ((autoSelect = template.isAutoSelect(i)) != null) {
                    this.setAutoSelect(i, autoSelect);
                }
                if ((conv = template.getConvert(i)) != null) {
                    this.setConvert(i, conv.charValue());
                }
                this.dateFormat.add(null);
                this.numberFormat.add(null);
                this.hAlignment.add(template.getHorizontalAlignment(i));
                this.vAlignment.add(template.getVerticalAlignment(i));
                this.maxColumns.add(template.getMaxColumns(i));
                this.scales.add(template.getScale(i));
            }
        } else {
            this.setCellEditorFixed(true);
            this.setCellRendererFixed(true);
            this.setCellRectFixed(true);
            for (int i = 0; i < columns; ++i) {
                this.format.add(null);
                this.formatFlags.add("");
                this.dateFormat.add(null);
                this.numberFormat.add(null);
                this.hAlignment.add(null);
                this.vAlignment.add(null);
                this.maxColumns.add(null);
                this.scales.add(null);
            }
        }
    }

    public void configureRenderers() {
        if (this.usingAbstractFormTableModel) {
            int columns = this.dataModel.getColumnCount();
            FormTableEntry template = ((AbstractFormTableModel)this.dataModel).getTemplate();
            for (int i = 0; i < columns; ++i) {
                TableColumn col;
                TableCellRenderer renderer = template.getCellRenderer(i);
                if (renderer == null || (col = this.getColumnByModelIndex(i)) == null) continue;
                col.setCellRenderer(renderer);
            }
        }
    }

    public void configureEditors() {
        if (this.usingAbstractFormTableModel) {
            int columns = this.dataModel.getColumnCount();
            FormTableEntry template = ((AbstractFormTableModel)this.dataModel).getTemplate();
            for (int i = 0; i < columns; ++i) {
                TableColumn col;
                TableCellEditor editor = template.getCellEditor(i);
                if (editor == null || (col = this.getColumnByModelIndex(i)) == null) continue;
                col.setCellEditor(editor);
            }
        }
    }

    public TableColumn getColumnByModelIndex(int modelIndex) {
        TableColumnModel colModel = this.getColumnModel();
        if (colModel instanceof FormTableColumnModel) {
            return ((FormTableColumnModel)colModel).getColumnByModelIndex(modelIndex);
        }
        Enumeration<TableColumn> columns = colModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (column.getModelIndex() != modelIndex) continue;
            return column;
        }
        return null;
    }

    public Rectangle getDefaultCellRect(int row, int column, boolean includeSpacing) {
        return super.getCellRect(row, column, includeSpacing);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        AbstractFormTableModel amodel;
        FormTableEntry entry;
        Rectangle rect;
        if (!this.isCellRectFixed() && (rect = (entry = (amodel = (AbstractFormTableModel)this.getModel()).getEntryAt(row)).getCellRect(row, column, includeSpacing)) != null) {
            return rect;
        }
        return this.getDefaultCellRect(row, column, includeSpacing);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (!this.isCellRectFixed()) {
            int keyCode;
            AWTEvent event;
            FormTableEntry entry = ((AbstractFormTableModel)this.getModel()).getEntryAt(rowIndex);
            int refRowIndex = entry.getReferencedRow(rowIndex, columnIndex);
            int refColumnIndex = entry.getReferencedColumn(rowIndex, columnIndex);
            if (!(toggle || extend || refRowIndex != rowIndex || refColumnIndex == columnIndex || this.getColumnModel().getSelectionModel().getLeadSelectionIndex() != refColumnIndex || !((event = EventQueue.getCurrentEvent()) instanceof KeyEvent) || (keyCode = ((KeyEvent)event).getKeyCode()) != 9 && keyCode != 39 && keyCode != 37)) {
                boolean visibleFound = false;
                boolean wrapped = false;
                int maxcol = this.getColumnModel().getColumnCount();
                int maxrow = this.getRowCount();
                if (columnIndex > refColumnIndex) {
                    while (!wrapped || rowIndex != refRowIndex) {
                        entry = ((AbstractFormTableModel)this.getModel()).getEntryAt(rowIndex);
                        while (columnIndex < maxcol) {
                            if (entry.isCellVisible(rowIndex, columnIndex)) {
                                visibleFound = true;
                                break;
                            }
                            ++columnIndex;
                        }
                        if (!visibleFound && keyCode == 9) {
                            columnIndex = 0;
                            if (++rowIndex < maxrow) continue;
                            rowIndex = 0;
                            wrapped = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    while (!wrapped || rowIndex != refRowIndex) {
                        entry = ((AbstractFormTableModel)this.getModel()).getEntryAt(rowIndex);
                        while (columnIndex >= 0) {
                            if (entry.isCellVisible(rowIndex, columnIndex)) {
                                visibleFound = true;
                                break;
                            }
                            --columnIndex;
                        }
                        if (!visibleFound && keyCode == 9) {
                            columnIndex = maxcol - 1;
                            if (--rowIndex >= 0) continue;
                            rowIndex = maxrow - 1;
                            wrapped = true;
                            continue;
                        }
                        break;
                    }
                }
                if (visibleFound) {
                    refRowIndex = rowIndex;
                    refColumnIndex = columnIndex;
                }
            }
            rowIndex = refRowIndex;
            columnIndex = refColumnIndex;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    public void setCellTraversal(int mode) {
        this.cellTraversal = mode;
    }

    public int getCellTraversal() {
        return this.cellTraversal;
    }

    public synchronized void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public void fireValueChanged(ListSelectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListSelectionListener.class) continue;
                ((ListSelectionListener)listeners[i + 1]).valueChanged(evt);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.fireValueChanged(evt);
    }

    public synchronized void addFormTableTraversalListener(FormTableTraversalListener listener) {
        this.listenerList.add(FormTableTraversalListener.class, listener);
    }

    public synchronized void removeFormTableTraversalListener(FormTableTraversalListener listener) {
        this.listenerList.remove(FormTableTraversalListener.class, listener);
    }

    public void fireTraversalRequested(FormTableTraversalEvent evt) throws FormTableTraversalVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FormTableTraversalListener.class) continue;
                ((FormTableTraversalListener)listeners[i + 1]).traversalRequested(evt);
            }
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionPerformed(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                ((ActionListener)listeners[i + 1]).actionPerformed(evt);
            }
        }
    }

    private void doFireActionPerformed(String actionCommand) {
        if (this.clicks >= this.clickCountToAction && this.getSelectedRowCount() > 0) {
            this.fireActionPerformed(new ActionEvent(this, 1001, actionCommand));
        }
    }

    public int getClickCount() {
        return this.clicks;
    }

    public void setClickCountToAction(int clicks) {
        this.clickCountToAction = clicks;
    }

    public int getClickCountToAction() {
        return this.clickCountToAction;
    }

    public void setEnterActionEnabled(boolean enableEnterAction) {
        this.enableEnterAction = enableEnterAction;
    }

    public boolean isEnterActionEnabled() {
        return this.enableEnterAction;
    }

    public void setClickCountToStart(int clicks) {
        this.clickCountToStart = clicks;
        if (this.defaultEditorsByColumnClass != null) {
            Enumeration editors = this.defaultEditorsByColumnClass.elements();
            while (editors.hasMoreElements()) {
                Object editor = editors.nextElement();
                if (editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(clicks);
                    continue;
                }
                if (!(editor instanceof FormComponentCellEditor)) continue;
                ((FormComponentCellEditor)editor).setClickCountToStart(clicks);
            }
        }
        if (this.getColumnModel() != null) {
            Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                TableColumn col = columns.nextElement();
                TableCellEditor editor = col.getCellEditor();
                if (editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(clicks);
                    continue;
                }
                if (!(editor instanceof FormComponentCellEditor)) continue;
                ((FormComponentCellEditor)editor).setClickCountToStart(clicks);
            }
        }
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.isHonourChangeable()) {
            this.changeable = changeable;
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void updateAllChangeable(boolean allChangeable) {
        if (this.allChangeable != allChangeable) {
            this.allChangeable = allChangeable;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return row >= 0 && column >= 0 && this.changeable && this.allChangeable && super.isCellEditable(row, column);
    }

    public boolean isCellMandatory(int row, int column) {
        FormTableBinding binding;
        boolean mandatory = false;
        if (this.bindableModel != null && (binding = this.bindableModel.getBinding(this.convertColumnIndexToModel(column))) != null) {
            mandatory = binding.isMandatory();
        }
        return mandatory;
    }

    public void setFormat(int column, String fmt) {
        this.format.set(column, fmt);
        this.dateFormat.set(column, null);
        this.numberFormat.set(column, null);
    }

    public void setFormat(String[] fmt) {
        for (int i = 0; i < fmt.length; ++i) {
            this.setFormat(i, fmt[i]);
        }
    }

    public String getFormat(int column) {
        return this.format == null ? null : this.format.get(column);
    }

    public String[] getFormat() {
        return this.format == null ? null : this.format.toArray(new String[this.format.size()]);
    }

    public void setAutoSelect(int column, boolean autoSelect) {
        if (autoSelect) {
            this.addFormatFlag(column, 'S');
        } else {
            this.removeFormatFlag(column, 'S');
        }
    }

    public void setAutoSelect(boolean autoSelect) {
        if (autoSelect) {
            this.addFormatFlag('S');
        } else {
            this.removeFormatFlag('S');
        }
    }

    public boolean isAutoSelect(int column) {
        return this.formatFlags.get(column).indexOf(83) >= 0;
    }

    public void setBlankZero(int column, boolean blankZero) {
        if (blankZero) {
            this.addFormatFlag(column, 'Z');
        } else {
            this.removeFormatFlag(column, 'Z');
        }
    }

    public void setBlankZero(boolean blankZero) {
        if (blankZero) {
            this.addFormatFlag('Z');
        } else {
            this.removeFormatFlag('Z');
        }
    }

    public boolean isBlankZero(int column) {
        return this.formatFlags.get(column).indexOf(90) >= 0;
    }

    public void setConvert(int column, char convert) {
        this.removeFormatFlag(column, 'v');
        this.removeFormatFlag(column, '^');
        if (convert == 'v' || convert == '^') {
            this.addFormatFlag(column, convert);
        }
    }

    public void setConvert(char convert) {
        this.removeFormatFlag('v');
        this.removeFormatFlag('^');
        if (convert == 'v' || convert == '^') {
            this.addFormatFlag(convert);
        }
    }

    public char getConvert(int column) {
        String formatFlag = this.formatFlags.get(column);
        if (formatFlag.indexOf(118) >= 0) {
            return 'v';
        }
        if (formatFlag.indexOf(94) >= 0) {
            return '^';
        }
        return '=';
    }

    public void setAdjust(int column, char adjust) {
        this.removeFormatFlag(column, '<');
        this.removeFormatFlag(column, '>');
        this.removeFormatFlag(column, '|');
        if (adjust == '>' || adjust == '<' || adjust == '|') {
            this.addFormatFlag(column, adjust);
        }
    }

    public void setAdjust(char adjust) {
        this.removeFormatFlag('<');
        this.removeFormatFlag('>');
        this.removeFormatFlag('|');
        if (adjust == '>' || adjust == '<' || adjust == '|') {
            this.addFormatFlag(adjust);
        }
    }

    public char getAdjust(int column) {
        String formatFlag = this.formatFlags.get(column);
        if (formatFlag.indexOf(60) >= 0) {
            return '<';
        }
        if (formatFlag.indexOf(62) >= 0) {
            return '>';
        }
        if (formatFlag.indexOf(124) >= 0) {
            return '|';
        }
        return '=';
    }

    public void setMaxColumn(int column, Integer maxColumn) {
        this.maxColumns.set(column, maxColumn);
    }

    public Integer getMaxColumn(int column) {
        return this.maxColumns.get(column);
    }

    public void setScale(int column, Integer maxColumn) {
        this.scales.set(column, maxColumn);
    }

    public Integer getScale(int column) {
        return this.scales.get(column);
    }

    public void setHorizontalAlignment(int column, int align) {
        this.hAlignment.set(column, align);
    }

    public void setHorizontalAlignment(int align) {
        for (int i = 0; i < this.hAlignment.size(); ++i) {
            this.hAlignment.set(i, align);
        }
    }

    public int getHorizontalAlignment(int column) {
        Integer align = this.hAlignment.get(column);
        return align == null ? -1 : align;
    }

    public void setVerticalAlignment(int column, int align) {
        this.vAlignment.set(column, align);
    }

    public void setVerticalAlignment(int align) {
        for (int i = 0; i < this.vAlignment.size(); ++i) {
            this.vAlignment.set(i, align);
        }
    }

    public int getVerticalAlignment(int column) {
        Integer align = this.vAlignment.get(column);
        return align == null ? -1 : align;
    }

    private void addFormatFlag(int index, char flag) {
        String formatFlag = this.formatFlags.get(index);
        if (formatFlag.indexOf(flag) == -1) {
            this.formatFlags.set(index, formatFlag + flag);
        }
    }

    private void addFormatFlag(char flag) {
        for (int i = 0; i < this.formatFlags.size(); ++i) {
            this.addFormatFlag(i, flag);
        }
    }

    private void removeFormatFlag(int index, char flag) {
        String formatFlag = this.formatFlags.get(index);
        StringBuilder newFlag = new StringBuilder();
        for (int i = 0; i < formatFlag.length(); ++i) {
            char c = formatFlag.charAt(i);
            if (c == flag) continue;
            newFlag.append(c);
        }
        this.formatFlags.set(index, newFlag.toString());
    }

    private void removeFormatFlag(char flag) {
        for (int i = 0; i < this.formatFlags.size(); ++i) {
            this.removeFormatFlag(i, flag);
        }
    }

    public DateFormat getDateFormat(int column, boolean asTimestamp) {
        DateFormat df = this.dateFormat.get(column);
        if (df == null) {
            String fmt = this.getFormat(column);
            df = fmt != null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(asTimestamp ? FormatHelper.getShortTimestampPattern() : FormatHelper.getShortDatePattern());
            this.dateFormat.set(column, df);
        }
        return df;
    }

    public DateFormat getDateFormat(int column) {
        return this.getDateFormat(column, false);
    }

    public NumberFormat getNumberFormat(int column) {
        NumberFormat nf = this.numberFormat.get(column);
        if (nf == null) {
            String fmt = this.getFormat(column);
            nf = fmt != null ? new DecimalFormat(fmt) : new DecimalFormat(FormatHelper.getIntegerPattern());
            this.numberFormat.set(column, nf);
        }
        return nf;
    }

    public void setMinRowHeight(int minRowHeight) {
        this.minRowHeight = minRowHeight;
    }

    public int getMinRowHeight() {
        return this.minRowHeight;
    }

    public void setMaxRowHeight(int maxRowHeight) {
        this.maxRowHeight = maxRowHeight;
    }

    public int getMaxRowHeight() {
        return this.maxRowHeight;
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        if (this.minRowHeight != 0 && rowHeight < this.minRowHeight) {
            rowHeight = this.minRowHeight;
        }
        if (this.maxRowHeight != 0 && rowHeight > this.maxRowHeight) {
            rowHeight = this.maxRowHeight;
        }
        if (rowHeight != this.getRowHeight(row)) {
            super.setRowHeight(row, rowHeight);
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (this.minRowHeight != 0 && rowHeight < this.minRowHeight) {
            rowHeight = this.minRowHeight;
        }
        if (this.maxRowHeight != 0 && rowHeight > this.maxRowHeight) {
            rowHeight = this.maxRowHeight;
        }
        if (rowHeight != this.getRowHeight()) {
            super.setRowHeight(rowHeight);
        }
    }

    public void scrollToCell(int row, int column) {
        Rectangle rect = this.getCellRect(row, column, true);
        this.scrollRectToVisible(rect);
        rect = this.getCellRect(row, column, true);
        this.scrollRectToVisible(rect);
    }

    public boolean isSizeInPreferencesIgnored() {
        return this.sizeInPreferencesIgnored;
    }

    public void setSizeInPreferencesIgnored(boolean sizeInPreferencesIgnored) {
        this.sizeInPreferencesIgnored = sizeInPreferencesIgnored;
    }

    public boolean isCellEditorFixed() {
        return this.cellEditorFixed;
    }

    public void setCellEditorFixed(boolean cellEditorFixed) {
        this.cellEditorFixed = cellEditorFixed;
    }

    public boolean isCellRendererFixed() {
        return this.cellRendererFixed;
    }

    public void setCellRendererFixed(boolean cellRendererFixed) {
        this.cellRendererFixed = cellRendererFixed;
    }

    public boolean isCellRectFixed() {
        return this.cellRectFixed;
    }

    public void setCellRectFixed(boolean cellRectFixed) {
        this.cellRectFixed = cellRectFixed;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        FormTableEntry entry;
        TableCellRenderer renderer;
        if (!this.isCellRendererFixed() && (renderer = (entry = ((AbstractFormTableModel)this.getModel()).getEntryAt(row)).getCellRenderer(this.convertColumnIndexToModel(column))) != null) {
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        FormTableEntry entry;
        TableCellEditor editor;
        if (!this.isCellEditorFixed() && (editor = (entry = ((AbstractFormTableModel)this.getModel()).getEntryAt(row)).getCellEditor(this.convertColumnIndexToModel(column))) != null) {
            return editor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public void setDefaultEditor(Class<?> columnClass, TableCellEditor editor) {
        if (columnClass.isInterface()) {
            if (editor != null) {
                this.defaultEditorsByColumnInterface.put(columnClass, editor);
            } else {
                this.defaultEditorsByColumnInterface.remove(columnClass);
            }
        } else {
            super.setDefaultEditor(columnClass, editor);
        }
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(this.clickCountToStart);
        } else if (editor instanceof FormComponentCellEditor) {
            ((FormComponentCellEditor)editor).setClickCountToStart(this.clickCountToStart);
        }
    }

    @Override
    public TableCellEditor getDefaultEditor(Class<?> columnClass) {
        if (columnClass == Object.class) {
            columnClass = String.class;
        } else if (columnClass != null && !this.defaultEditorsByColumnInterface.isEmpty()) {
            for (Map.Entry<Class<?>, TableCellEditor> entry : this.defaultEditorsByColumnInterface.entrySet()) {
                if (!entry.getKey().isAssignableFrom(columnClass)) continue;
                return entry.getValue();
            }
        }
        return super.getDefaultEditor(columnClass);
    }

    @Override
    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        if (this.defaultRenderersByColumnInterface != null && columnClass != null && columnClass.isInterface()) {
            if (renderer != null) {
                this.defaultRenderersByColumnInterface.put(columnClass, renderer);
            } else {
                this.defaultRenderersByColumnInterface.remove(columnClass);
            }
        } else {
            super.setDefaultRenderer(columnClass, renderer);
        }
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (columnClass != null && this.defaultRenderersByColumnInterface != null && !this.defaultRenderersByColumnInterface.isEmpty()) {
            for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderersByColumnInterface.entrySet()) {
                if (!entry.getKey().isAssignableFrom(columnClass)) continue;
                return entry.getValue();
            }
        }
        return super.getDefaultRenderer(columnClass);
    }

    public boolean isCellDragEnabled() {
        return this.cellDragEnabled;
    }

    public void setCellDragEnabled(boolean cellDragEnabled) {
        this.cellDragEnabled = cellDragEnabled;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        FormFieldComboBox box;
        Component comp;
        if (this.usingAbstractFormTableModel && editor instanceof FormComponentCellEditor) {
            ((FormComponentCellEditor)editor).prepare(((AbstractFormTableModel)this.getModel()).getEntryAt(row), column);
        }
        if ((comp = super.prepareEditor(editor, row, column)) instanceof FormFieldComboBox && (box = (FormFieldComboBox)comp).isEditable()) {
            AbstractFormField boxEditor = box.getEditorField();
            boxEditor.setNextFocusableComponent(this);
            this.setNextFocusableComponent(boxEditor);
            return comp;
        }
        this.setNextFocusableComponent(comp);
        return comp;
    }

    @Override
    protected void paintComponent(Graphics g) {
        ++this.paintCount;
        super.paintComponent(g);
    }

    public long getPaintCount() {
        return this.paintCount;
    }

    private class CellEditingEvent
    extends AWTEvent {
        private static final int EXACT = 0;
        private static final int NEXT = 1;
        private static final int PREVIOUS = -1;
        private final long serial;
        private final int row;
        private final int col;
        private final int mode;

        public CellEditingEvent(int mode, int row, int col) {
            super(FormTable.this, 2021);
            this.mode = mode;
            this.row = row;
            this.col = col;
            this.serial = ++FormTable.this.cellEventSerial;
        }
    }

    private class CellTraversalEvent
    extends AWTEvent {
        private final boolean next;
        private final long serial;

        public CellTraversalEvent(boolean next) {
            super(FormTable.this, 2020);
            this.next = next;
            this.serial = ++FormTable.this.cellEventSerial;
        }
    }

    private class PreviousCellAction
    extends AbstractAction {
        private PreviousCellAction() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                boolean found;
                int col;
                int row;
                int leadCol;
                int leadRow;
                int cellTraversal;
                block17: {
                    FormTableEntry entry;
                    int rows;
                    int cols;
                    block19: {
                        block18: {
                            cellTraversal = e instanceof CellActionEvent ? ((CellActionEvent)e).traversal : FormTable.this.cellTraversal;
                            if (cellTraversal == 0) return;
                            ListSelectionModel rowSelection = FormTable.this.getSelectionModel();
                            ListSelectionModel colSelection = FormTable.this.getColumnModel().getSelectionModel();
                            leadRow = rowSelection.getLeadSelectionIndex();
                            leadCol = colSelection.getLeadSelectionIndex();
                            row = leadRow;
                            col = leadCol;
                            cols = -1;
                            rows = -1;
                            found = false;
                            if ((cellTraversal & 1) == 1) break block18;
                            if ((cellTraversal & 2) != 2) break block17;
                            break block19;
                        }
                        do {
                            if (--col < 0) {
                                if ((cellTraversal & 0x14) == 20) {
                                    ++col;
                                    break block17;
                                }
                                if (cols < 0) {
                                    cols = FormTable.this.getColumnCount();
                                }
                                col = cols - 1;
                                if ((cellTraversal & 0x18) != 24 && --row < 0) {
                                    if ((cellTraversal & 0x10) == 16) {
                                        ++row;
                                        col = 0;
                                        if ((cellTraversal & 0x90) == 144) {
                                            FormTable.this.transferFocusBackward();
                                        }
                                        break block17;
                                    }
                                    if (rows < 0) {
                                        rows = FormTable.this.getRowCount();
                                    }
                                    row = rows - 1;
                                }
                            }
                            if ((cellTraversal & 0x20) == 32 && !FormTable.this.isCellEditable(row, col) || !FormTable.this.isCellRectFixed() && !(entry = ((AbstractFormTableModel)FormTable.this.getModel()).getEntryAt(row)).isCellVisible(row, col)) continue;
                            found = true;
                            break block17;
                        } while (row != leadRow || col != leadCol);
                        break block17;
                    }
                    do {
                        if (--row < 0) {
                            if ((cellTraversal & 0x14) == 20) {
                                ++row;
                                break;
                            }
                            if (rows < 0) {
                                rows = FormTable.this.getRowCount();
                            }
                            row = rows - 1;
                            if ((cellTraversal & 0x18) != 24 && --col < 0) {
                                if ((cellTraversal & 0x10) == 16) {
                                    ++col;
                                    row = 0;
                                    if ((cellTraversal & 0x90) != 144) break;
                                    FormTable.this.transferFocusBackward();
                                    break;
                                }
                                if (cols < 0) {
                                    cols = FormTable.this.getColumnCount();
                                }
                                col = cols - 1;
                            }
                        }
                        if ((cellTraversal & 0x20) == 32 && !FormTable.this.isCellEditable(row, col) || !FormTable.this.isCellRectFixed() && !(entry = ((AbstractFormTableModel)FormTable.this.getModel()).getEntryAt(row)).isCellVisible(row, col)) continue;
                        found = true;
                        break;
                    } while (row != leadRow || col != leadCol);
                }
                boolean edit = (cellTraversal & 0x40) == 64;
                FormTable.this.fireTraversalRequested(new FormTableTraversalEvent(FormTable.this, !found, leadRow, leadCol, row, col, edit, false));
                if (!found) return;
                FormTable.this.changeSelection(row, col, false, false);
                if (!edit) return;
                FormTable.this.editCellAt(row, col);
                return;
            }
            catch (FormTableTraversalVetoException ve) {
                LOGGER.fine("{0}", (Throwable)ve);
            }
        }
    }

    private class NextCellAction
    extends AbstractAction {
        private NextCellAction() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                boolean found;
                int col;
                int row;
                int cellTraversal;
                int leadCol;
                int leadRow;
                block22: {
                    FormTableEntry entry;
                    int rows;
                    int cols;
                    block24: {
                        block23: {
                            ListSelectionModel rowSelection = FormTable.this.getSelectionModel();
                            ListSelectionModel colSelection = FormTable.this.getColumnModel().getSelectionModel();
                            leadRow = rowSelection.getLeadSelectionIndex();
                            leadCol = colSelection.getLeadSelectionIndex();
                            cellTraversal = FormTable.this.cellTraversal;
                            if (e instanceof CellActionEvent) {
                                cellTraversal = ((CellActionEvent)e).traversal;
                            } else if ((cellTraversal & 0x40) == 64 && !FormTable.this.isEditing() && FormTable.this.isCellEditable(leadRow, leadCol)) {
                                FormTable.this.fireTraversalRequested(new FormTableTraversalEvent(FormTable.this, false, leadRow, leadCol, leadRow, leadCol, true, true));
                                FormTable.this.editCellAt(leadRow, leadCol);
                                return;
                            }
                            if (cellTraversal == 0) return;
                            row = leadRow;
                            col = leadCol;
                            cols = -1;
                            rows = -1;
                            found = false;
                            if ((cellTraversal & 1) == 1) break block23;
                            if ((cellTraversal & 2) != 2) break block22;
                            break block24;
                        }
                        do {
                            ++col;
                            if (cols < 0) {
                                cols = FormTable.this.getColumnCount();
                            }
                            if (col >= cols) {
                                if ((cellTraversal & 0x14) == 20) {
                                    --col;
                                    break block22;
                                }
                                col = 0;
                                if ((cellTraversal & 0x18) != 24) {
                                    ++row;
                                    if (rows < 0) {
                                        rows = FormTable.this.getRowCount();
                                    }
                                    if (row >= rows) {
                                        if ((cellTraversal & 0x10) == 16) {
                                            col = cols - 1;
                                            --row;
                                            if ((cellTraversal & 0x90) == 144) {
                                                FormTable.this.transferFocus();
                                            }
                                            break block22;
                                        }
                                        row = 0;
                                    }
                                }
                            }
                            if ((cellTraversal & 0x20) == 32 && !FormTable.this.isCellEditable(row, col) || !FormTable.this.isCellRectFixed() && !(entry = ((AbstractFormTableModel)FormTable.this.getModel()).getEntryAt(row)).isCellVisible(row, col)) continue;
                            found = true;
                            break block22;
                        } while (row != leadRow || col != leadCol);
                        break block22;
                    }
                    do {
                        ++row;
                        if (rows < 0) {
                            rows = FormTable.this.getRowCount();
                        }
                        if (row >= rows) {
                            if ((cellTraversal & 0x14) == 20) {
                                --row;
                                break;
                            }
                            row = 0;
                            if ((cellTraversal & 0x18) != 24) {
                                ++col;
                                if (cols < 0) {
                                    cols = FormTable.this.getColumnCount();
                                }
                                if (col >= cols) {
                                    if ((cellTraversal & 0x10) == 16) {
                                        row = rows - 1;
                                        --col;
                                        if ((cellTraversal & 0x90) != 144) break;
                                        FormTable.this.transferFocus();
                                        break;
                                    }
                                    col = 0;
                                }
                            }
                        }
                        if ((cellTraversal & 0x20) == 32 && !FormTable.this.isCellEditable(row, col) || !FormTable.this.isCellRectFixed() && !(entry = ((AbstractFormTableModel)FormTable.this.getModel()).getEntryAt(row)).isCellVisible(row, col)) continue;
                        found = true;
                        break;
                    } while (row != leadRow || col != leadCol);
                }
                boolean edit = (cellTraversal & 0x40) == 64;
                FormTable.this.fireTraversalRequested(new FormTableTraversalEvent(FormTable.this, !found, leadRow, leadCol, row, col, edit, true));
                if (!found) return;
                FormTable.this.changeSelection(row, col, false, false);
                if (!edit) return;
                FormTable.this.editCellAt(row, col);
                return;
            }
            catch (FormTableTraversalVetoException ve) {
                LOGGER.fine("{0}", (Throwable)ve);
            }
        }
    }

    private class CellActionEvent
    extends ActionEvent {
        private final int traversal;

        CellActionEvent(int cellTraversal) {
            super(FormTable.this, 0, null);
            this.traversal = cellTraversal;
        }
    }

    private class BooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean editable = table.isCellEditable(row, column);
            this.setEnabled(true);
            if (isSelected) {
                if (hasFocus) {
                    if (editable) {
                        this.setForeground(table.getForeground());
                        this.setBackground(table.getBackground());
                    } else {
                        this.setEnabled(false);
                        this.setForeground(table.getSelectionForeground());
                        this.setBackground(table.getSelectionBackground());
                    }
                } else {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                }
            } else {
                this.setEnabled(true);
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

