/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.tentackle.swing.FormTableCellRenderer;
import org.tentackle.swing.FormTextArea;

public class FormTextAreaTableCellRenderer
extends FormTableCellRenderer {
    private boolean autoRowHeight;

    public FormTextAreaTableCellRenderer() {
        super(new FormTextArea(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setForeground(null);
                this.setBackground(null);
            }

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }
        });
        FormTextArea textArea = (FormTextArea)this.getComponent();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setCellEditorUsage(true);
        textArea.setSmartEnter(false);
        textArea.setEditable(false);
        this.setAutoRowHeight(true);
    }

    @Override
    protected void setValue(Object value) {
        ((FormTextArea)this.getComponent()).setText(value == null ? "" : value.toString());
    }

    @Override
    protected String getText() {
        return ((FormTextArea)this.getComponent()).getText();
    }

    @Override
    protected void setHorizontalAlignment(int alignment) {
        ((FormTextArea)this.getComponent()).setHorizontalAlignment(alignment);
    }

    @Override
    protected void setVerticalAlignment(int alignment) {
        ((FormTextArea)this.getComponent()).setVerticalAlignment(alignment);
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.autoRowHeight = autoRowHeight;
    }

    public boolean isAutoRowHeight() {
        return this.autoRowHeight;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FormTextArea textArea = (FormTextArea)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (textArea.getWidth() == 0) {
            int width = table.getColumnModel().getColumn(column).getWidth();
            textArea.setSize(width, table.getRowHeight(row));
        }
        if (this.autoRowHeight) {
            int height = textArea.getPreferredSize().height;
            if (table != null && table.getRowHeight(row) < height) {
                table.setRowHeight(row, height);
            }
        }
        return textArea;
    }
}

