/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormSpinField;
import org.tentackle.swing.IntegerFormField;
import org.tentackle.swing.SpinEvent;
import org.tentackle.swing.SpinListener;
import org.tentackle.swing.ValueEvent;

public class MinSecSpinField
extends FormSpinField
implements SpinListener {
    private final IntegerFormField minSecField = new IntegerFormField();

    public MinSecSpinField(int minSec) {
        this.minSecField.setColumns(2);
        this.minSecField.setFormat("00");
        this.setFormComponent(this.minSecField);
        this.setMinSec(minSec);
        this.addSpinListener(this);
    }

    public MinSecSpinField() {
        this(0);
    }

    @Override
    public void valueEntered(ValueEvent e) {
        super.valueEntered(e);
        this.setMinSec(this.getMinSec());
    }

    public void setMinSec(int minSec) {
        if ((minSec %= 60) < 0) {
            minSec += 60;
        }
        this.minSecField.setIntValue(minSec);
    }

    public int getMinSec() {
        return this.minSecField.getIntValue();
    }

    @Override
    public void increment(SpinEvent e, FormComponent c) {
        this.setMinSec(this.getMinSec() + 1);
    }

    @Override
    public void decrement(SpinEvent e, FormComponent c) {
        this.setMinSec(this.getMinSec() - 1);
    }
}

