/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.tentackle.swing.FormComponentPanel;
import org.tentackle.swing.FormRadioButton;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.SwingSwingBundle;

public class YesNoRadioButton
extends FormComponentPanel {
    private Boolean savedValue;
    private FormRadioButton noButton;
    private FormRadioButton yesButton;

    public YesNoRadioButton() {
        this.initComponents();
        this.setYesText(SwingSwingBundle.getString("YES"));
        this.setNoText(SwingSwingBundle.getString("NO"));
        this.setFormComponent(this.yesButton);
    }

    public boolean isUndetermined() {
        return !this.yesButton.isSelected() && !this.noButton.isSelected();
    }

    public Boolean getSelected() {
        return this.isUndetermined() ? null : Boolean.valueOf(this.yesButton.isSelected());
    }

    @Override
    public Boolean getFormValue() {
        return this.getSelected();
    }

    public void setSelected(Boolean selected) {
        if (selected == null) {
            this.yesButton.setSelected(false);
            this.noButton.setSelected(false);
        } else {
            this.yesButton.setSelected(selected);
            this.noButton.setSelected(!this.yesButton.isSelected());
        }
    }

    @Override
    public void setFormValue(Object object) {
        this.setSelected(object instanceof Boolean ? (Boolean)object : null);
    }

    public void setYesText(String text) {
        this.yesButton.setText(text);
    }

    public String getYesText() {
        return this.yesButton.getText();
    }

    public void setNoText(String text) {
        this.noButton.setText(text);
    }

    public String getNoText() {
        return this.noButton.getText();
    }

    @Override
    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        this.noButton.setChangeable(changeable);
    }

    @Override
    public void saveValue() {
        if (this.isHonourChangeable()) {
            this.savedValue = this.getSelected();
        }
    }

    @Override
    public boolean isValueChanged() {
        if (!this.isHonourChangeable()) {
            return false;
        }
        Boolean value = this.getSelected();
        if (value == null) {
            return this.savedValue != null;
        }
        return this.savedValue == null || this.savedValue.booleanValue() != value.booleanValue();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.noButton.setMandatory(mandatory);
    }

    private void initComponents() {
        this.yesButton = new FormRadioButton();
        this.noButton = new FormRadioButton();
        this.setLayout(new GridBagLayout());
        this.yesButton.setText(SwingSwingBundle.getString("YES"));
        this.yesButton.setName("yes");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                YesNoRadioButton.this.yesButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.yesButton, gridBagConstraints);
        this.noButton.setText(SwingSwingBundle.getString("NO"));
        this.noButton.setName("no");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                YesNoRadioButton.this.noButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.noButton, new GridBagConstraints());
    }

    private void yesButtonActionPerformed(ActionEvent evt) {
        if (this.yesButton.isSelected()) {
            this.noButton.setSelected(false);
        }
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }

    private void noButtonActionPerformed(ActionEvent evt) {
        if (this.noButton.isSelected()) {
            this.yesButton.setSelected(false);
        }
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }
}

