/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.Comparator;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.SortingFocusTraversalPolicy;
import org.tentackle.swing.FocusTraversalGroup;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormLayoutComparator;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.SwingDefaultFocusTraversalPolicy;

public class FormFocusTraversalPolicy
extends SortingFocusTraversalPolicy {
    private static final SwingDefaultFocusTraversalPolicy FITNESS_TEST_POLICY = new SwingDefaultFocusTraversalPolicy();
    private Component lastComp;

    public FormFocusTraversalPolicy(Comparator<? super Component> layoutComparator) {
        super(layoutComparator);
    }

    public FormFocusTraversalPolicy() {
        this(new FormLayoutComparator());
    }

    @Override
    protected boolean accept(Component component) {
        if (!super.accept(component) || component instanceof FormFieldComponent && !((FormFieldComponent)((Object)component)).isChangeable()) {
            return false;
        }
        if (component instanceof FormComponent && ((FormComponent)((Object)component)).isFormTraversable() || component instanceof FormButton && component.isEnabled() && ((FormButton)component).isFormTraversable() || component instanceof FormTable && component.isEnabled() && ((FormTable)component).isFormTraversable() || component instanceof JPasswordField) {
            if (component instanceof JTable) {
                return true;
            }
            if (component instanceof JComboBox) {
                JComboBox box = (JComboBox)component;
                return box.getUI().isFocusTraversable(box);
            }
            if (component instanceof JComponent) {
                InputMap inputMap;
                for (inputMap = ((JComponent)component).getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
                }
                if (inputMap != null) {
                    return true;
                }
            }
            return FITNESS_TEST_POLICY.accept(component);
        }
        return false;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        FocusTraversalGroup focusGroup;
        if (container == null || component == null) {
            throw new IllegalArgumentException("container and component cannot be null");
        }
        Component comp = null;
        if (component instanceof FormComponent && (focusGroup = ((FormComponent)((Object)component)).getFocusTraversalGroup()) != null && (comp = focusGroup.getComponentAfter(component)) == null && (comp = focusGroup.getFirstComponent()) != null) {
            this.updateComparatorFromContainer(container);
            while ((comp = super.getComponentAfter(container, comp)) != null && !this.isFirstComponentOrNonGrouped(comp)) {
            }
        }
        if (comp != null) {
            if (!this.accept(comp)) {
                return this.getComponentAfter(container, comp);
            }
        } else {
            this.updateComparatorFromContainer(container);
            comp = super.getComponentAfter(container, component);
        }
        if (comp != null && container instanceof FormWindow && component instanceof FormComponent && comp != component && this.lastComp != component && this.accept(component) && comp == super.getFirstComponent(container)) {
            ((FormComponent)((Object)component)).setFormWrapWindow((FormWindow)((Object)container));
            this.lastComp = component;
        } else {
            this.lastComp = null;
        }
        return comp;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        FocusTraversalGroup focusGroup;
        if (container == null || component == null) {
            throw new IllegalArgumentException("container and component cannot be null");
        }
        Component comp = null;
        if (component instanceof FormComponent && (focusGroup = ((FormComponent)((Object)component)).getFocusTraversalGroup()) != null && (comp = focusGroup.getComponentBefore(component)) == null && (comp = focusGroup.getLastComponent()) != null) {
            this.updateComparatorFromContainer(container);
            while ((comp = super.getComponentBefore(container, comp)) != null && !this.isLastComponentOrNonGrouped(comp)) {
            }
        }
        if (comp != null) {
            if (this.accept(comp)) {
                return comp;
            }
            return this.getComponentBefore(container, comp);
        }
        this.updateComparatorFromContainer(container);
        return super.getComponentBefore(container, component);
    }

    @Override
    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("container cannot be null");
        }
        this.updateComparatorFromContainer(container);
        return super.getFirstComponent(container);
    }

    @Override
    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("container cannot be null");
        }
        this.updateComparatorFromContainer(container);
        return super.getLastComponent(container);
    }

    private void updateComparatorFromContainer(Container container) {
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof FormLayoutComparator) {
            ((FormLayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
    }

    private boolean isFirstComponentOrNonGrouped(Component comp) {
        if (comp instanceof FormComponent) {
            FocusTraversalGroup group = ((FormComponent)((Object)comp)).getFocusTraversalGroup();
            return group == null || comp == group.getFirstComponent();
        }
        return false;
    }

    private boolean isLastComponentOrNonGrouped(Component comp) {
        if (comp instanceof FormComponent) {
            FocusTraversalGroup group = ((FormComponent)((Object)comp)).getFocusTraversalGroup();
            return group == null || comp == group.getLastComponent();
        }
        return false;
    }
}

