/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Rectangle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.tentackle.common.Compare;
import org.tentackle.swing.BindableTableModel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableModel;
import org.tentackle.swing.FormTableRowObject;
import org.tentackle.swing.bind.FormTableBinding;

public abstract class FormTableEntry<T>
implements FormTableRowObject {
    private FormTableModel<T> model;
    private int row;

    public abstract FormTableEntry<T> newInstance(T var1);

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public String getDisplayedColumnName(int mColumn) {
        return this.getColumnName(mColumn);
    }

    public Class<?> getColumnClass(int mColumn) {
        return null;
    }

    public String getFormat(int mColumn) {
        return null;
    }

    public Integer getHorizontalAlignment(int mColumn) {
        return null;
    }

    public Integer getVerticalAlignment(int mColumn) {
        return null;
    }

    public Boolean isBlankZero(int mColumn) {
        return null;
    }

    public FormTableBinding getBinding(int mColumn) {
        return this.model == null ? null : this.model.getBinding(mColumn);
    }

    public Boolean isAutoSelect(int mColumn) {
        FormTableBinding binding = this.getBinding(mColumn);
        if (binding != null) {
            return binding.isAutoSelect();
        }
        return null;
    }

    public Integer getMaxColumns(int mColumn) {
        FormTableBinding binding = this.getBinding(mColumn);
        if (binding != null) {
            return binding.getMaxColumns();
        }
        return null;
    }

    public Integer getScale(int mColumn) {
        FormTableBinding binding = this.getBinding(mColumn);
        if (binding != null) {
            return binding.getScale();
        }
        return null;
    }

    public Character getConvert(int mColumn) {
        FormTableBinding binding = this.getBinding(mColumn);
        if (binding != null) {
            return binding.getConvert();
        }
        return null;
    }

    public Character getAdjust(int mColumn) {
        return null;
    }

    public boolean isColumnNotSummable(int mColumn) {
        Class<?> clazz = this.getColumnClass(mColumn);
        if (clazz != null && !Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        Object value = this.getValueAt(mColumn);
        return value != null && !(value instanceof Number);
    }

    public boolean isCellRendererFixed() {
        return true;
    }

    public boolean isCellEditorFixed() {
        return true;
    }

    public boolean isCellRectFixed() {
        return true;
    }

    public void setModel(FormTableModel<T> model) {
        this.model = model;
    }

    @Override
    public FormTableModel<T> getModel() {
        return this.model;
    }

    @Override
    public FormTable getTable() {
        return this.model == null ? null : this.model.getTable();
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    public abstract T getObject();

    @Override
    public Object getValueAt(int mColumn) {
        FormTableBinding binding = this.getBinding(mColumn);
        if (binding != null) {
            binding.setBoundRootObject(this);
            Object modelValue = binding.getModelValue();
            binding.setViewValue(modelValue);
            return modelValue;
        }
        return null;
    }

    @Override
    public void setValueAt(int mColumn, Object value) {
        FormTableBinding binding = this.getBinding(mColumn);
        if (binding != null) {
            binding.setBoundRootObject(this);
            binding.setModelValue(value);
            binding.validate();
        }
    }

    public BindableTableModel.BindType getBindType() {
        return BindableTableModel.BindType.BIND;
    }

    public String getBindingPath(int mColumn) {
        return null;
    }

    public boolean updateCursor(int mRow) {
        return true;
    }

    public boolean updateList(int mRow) {
        return true;
    }

    public boolean updateArray(int mRow) {
        return true;
    }

    public int compareTo(FormTableEntry<? extends T> entry, int[] compareBy) {
        int rv = 0;
        for (int i = 0; rv == 0 && i < compareBy.length; ++i) {
            int col = compareBy[i];
            boolean descending = false;
            if (col < 0) {
                col = -col - 1;
                descending = true;
            }
            try {
                rv = Compare.compare((Comparable)((Comparable)this.getValueAt(col)), (Comparable)((Comparable)entry.getValueAt(col)));
            }
            catch (Exception e) {
                Object o1 = this.getValueAt(col);
                Object o2 = entry.getValueAt(col);
                String s1 = o1 != null ? o1.toString() : null;
                String s2 = o2 != null ? o2.toString() : null;
                rv = Compare.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
            }
            if (!descending) continue;
            return -rv;
        }
        return rv;
    }

    public boolean isVisiblyEqual(FormTableEntry<? extends T> entry) {
        for (int col = this.getColumnCount() - 1; col >= 0; --col) {
            String s2;
            Object o1 = this.getValueAt(col);
            Object o2 = entry.getValueAt(col);
            String s1 = o1 != null ? o1.toString() : null;
            String string = s2 = o2 != null ? o2.toString() : null;
            if (Compare.compare((Comparable)((Object)s1), (Comparable)((Object)s2)) == 0) continue;
            return false;
        }
        return true;
    }

    public TableCellRenderer getCellRenderer(int mColumn) {
        return null;
    }

    public boolean isBindingChangeable(int mColumn) {
        FormTableBinding binding = this.getBinding(mColumn);
        return binding != null && binding.isChangeable();
    }

    public boolean isCellEditable(int mColumn) {
        return false;
    }

    public TableCellEditor getCellEditor(int mColumn) {
        return null;
    }

    public Rectangle getCellRect(int vRow, int vColumn, boolean includeSpacing) {
        return null;
    }

    public boolean isCellVisible(int vRow, int vColumn) {
        return true;
    }

    public int getReferencedRow(int vRow, int vColumn) {
        return vRow;
    }

    public int getReferencedColumn(int vRow, int vColumn) {
        return vColumn;
    }

    public boolean getShowHorizontalLine(int vRow) {
        return true;
    }

    public boolean getShowVerticalLine(int vRow, int vColumn) {
        return true;
    }

    public void fireRowUpdated() {
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(this.row, this.row);
    }

    public void fireCellsUpdated(int ... mColumns) {
        for (int col : mColumns) {
            ((AbstractTableModel)this.getModel()).fireTableCellUpdated(this.row, col);
        }
    }
}

