/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.swing.plaf.UIResource;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;

class TBasicTransferable
implements Transferable,
UIResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TBasicTransferable.class);
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;
    protected final String plainData;
    protected final String htmlData;

    public TBasicTransferable(String plainData, String htmlData) {
        this.plainData = plainData;
        this.htmlData = htmlData;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nRicher = richerFlavors != null ? richerFlavors.length : 0;
        int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
        int nString = this.isPlainSupported() ? stringFlavors.length : 0;
        int nFlavors = nRicher + nHTML + nPlain + nString;
        DataFlavor[] flavors = new DataFlavor[nFlavors];
        int nDone = 0;
        if (nRicher > 0) {
            System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
            nDone += nRicher;
        }
        if (nHTML > 0) {
            System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
            nDone += nHTML;
        }
        if (nPlain > 0) {
            System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
            nDone += nPlain;
        }
        if (nString > 0) {
            System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flv : flavors = this.getTransferDataFlavors()) {
            if (!flv.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        this.getRicherFlavors();
        if (this.isRicherFlavor(flavor)) {
            return this.getRicherData(flavor);
        }
        if (this.isHTMLFlavor(flavor)) {
            String data = this.getHTMLData();
            String string = data = data == null ? "" : data;
            if (String.class.equals(flavor.getRepresentationClass())) {
                return data;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            }
        } else if (this.isPlainFlavor(flavor)) {
            String data = this.getPlainData();
            String string = data = data == null ? "" : data;
            if (String.class.equals(flavor.getRepresentationClass())) {
                return data;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            }
        } else if (this.isStringFlavor(flavor)) {
            String data = this.getPlainData();
            data = data == null ? "" : data;
            return data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected boolean isRicherFlavor(DataFlavor flavor) {
        for (DataFlavor richerFlavor : this.getRicherFlavors()) {
            if (!richerFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor[] getRicherFlavors() {
        return new DataFlavor[0];
    }

    protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
        return null;
    }

    protected boolean isHTMLFlavor(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flv : flavors = htmlFlavors) {
            if (!flv.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHTMLSupported() {
        return this.htmlData != null;
    }

    protected String getHTMLData() {
        return this.htmlData;
    }

    protected boolean isPlainFlavor(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flv : flavors = plainFlavors) {
            if (!flv.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return this.plainData != null;
    }

    protected String getPlainData() {
        return this.plainData;
    }

    protected boolean isStringFlavor(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flv : flavors = stringFlavors) {
            if (!flv.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            TBasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            TBasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            TBasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            TBasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            TBasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            TBasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            TBasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            TBasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException cle) {
            LOGGER.severe("error initializing javax.swing.plaf.basic.BasicTranserable", (Throwable)cle);
        }
    }
}

