/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tmetal;

import java.awt.Color;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.tentackle.common.Service;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.plaf.TentackleLookAndFeel;
import org.tentackle.swing.plaf.tmetal.TMetalTheme;

@Service(value=TentackleLookAndFeel.class)
public class TMetalLookAndFeel
extends MetalLookAndFeel
implements TentackleLookAndFeel {
    private static final long serialVersionUID = -5383733820337968815L;
    private static MetalTheme currentTheme = null;
    private Color mandatoryColor;
    private Color unselectedMandatoryColor;
    private boolean focusAnimated = true;

    public TMetalLookAndFeel() {
        currentTheme = null;
    }

    @Override
    public void loadTentackleExtraColors() {
        this.mandatoryColor = new ColorUIResource(255, 255, 170);
        this.unselectedMandatoryColor = new ColorUIResource(PlafUtilities.getInstance().brighter(this.mandatoryColor, 0.75));
    }

    @Override
    public Color getMandatoryColor() {
        return this.mandatoryColor;
    }

    @Override
    public void setMandatoryColor(Color mandatoryColor) {
        this.mandatoryColor = mandatoryColor;
    }

    @Override
    public Color getUnselectedMandatoryColor() {
        return this.unselectedMandatoryColor;
    }

    @Override
    public void setUnselectedMandatoryColor(Color unselectedMandatoryColor) {
        this.unselectedMandatoryColor = unselectedMandatoryColor;
    }

    public static String getTMetalName() {
        return "TMetal";
    }

    public static String getTMetalDescription() {
        return "Enhanced Metal LnF for Tentackle";
    }

    @Override
    public String getName() {
        return TMetalLookAndFeel.getTMetalName();
    }

    @Override
    public String getDescription() {
        return TMetalLookAndFeel.getTMetalDescription();
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    protected void createDefaultTheme() {
        if (currentTheme == null) {
            TMetalLookAndFeel.setCurrentTheme(new TMetalTheme());
        }
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        currentTheme = theme;
    }

    @Override
    public void uninitialize() {
        TMetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String tMetalPackageName = "org.tentackle.swing.plaf.tmetal.";
        Object[] uiDefaults = new Object[]{"ButtonUI", "org.tentackle.swing.plaf.tmetal.TMetalButtonUI", "ComboBoxUI", "org.tentackle.swing.plaf.tmetal.TMetalComboBoxUI", "RadioButtonUI", "org.tentackle.swing.plaf.tmetal.TMetalRadioButtonUI", "CheckBoxUI", "org.tentackle.swing.plaf.tmetal.TMetalCheckBoxUI", "TextFieldUI", "org.tentackle.swing.plaf.tmetal.TMetalTextFieldUI", "TextAreaUI", "org.tentackle.swing.plaf.tmetal.TMetalTextAreaUI", "TableUI", "org.tentackle.swing.plaf.tmetal.TMetalTableUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        if (currentTheme != null) {
            FontActiveValue userTextValue = new FontActiveValue(currentTheme, 2);
            FontActiveValue controlTextValue = new FontActiveValue(currentTheme, 0);
            Object[] defaults = new Object[]{"Label.font", userTextValue, "TextField.font", controlTextValue, "TextArea.font", controlTextValue, "PasswordField.font", controlTextValue, "Table.font", controlTextValue, "TitledBorder.font", userTextValue, "TextField.mandatoryBackground", this.getMandatoryColor(), "TextArea.mandatoryBackground", this.getMandatoryColor(), "TextArea.inactiveBackground", table.getColor("control"), "ComboBox.mandatoryBackground", this.getMandatoryColor(), "CheckBox.mandatoryBackground", this.getMandatoryColor(), "RadioButton.mandatoryBackground", this.getMandatoryColor(), "Table.selectedMandatoryBackground", this.getMandatoryColor(), "Table.unselectedMandatoryBackground", this.getUnselectedMandatoryColor()};
            table.putDefaults(defaults);
        }
    }

    @Override
    public ImageIcon loadImageIcon(String name) throws MissingResourceException {
        URL url = TMetalLookAndFeel.class.getResource("icons/" + name + ".png");
        if (url == null) {
            url = TMetalLookAndFeel.class.getResource("icons/" + name + ".gif");
        }
        if (url == null) {
            throw new MissingResourceException("no such icon '" + name + "'", TMetalLookAndFeel.class.getName(), name);
        }
        return new ImageIcon(url);
    }

    @Override
    public void setFocusAnimated(boolean flag) {
        this.focusAnimated = flag;
    }

    @Override
    public boolean isFocusAnimated() {
        return this.focusAnimated;
    }

    private static class FontActiveValue
    implements UIDefaults.ActiveValue {
        private final int type;
        private final MetalTheme theme;

        FontActiveValue(MetalTheme theme, int type) {
            this.theme = theme;
            this.type = type;
        }

        @Override
        public Object createValue(UIDefaults table) {
            FontUIResource value = null;
            switch (this.type) {
                case 0: {
                    value = this.theme.getControlTextFont();
                    break;
                }
                case 1: {
                    value = this.theme.getSystemTextFont();
                    break;
                }
                case 2: {
                    value = this.theme.getUserTextFont();
                    break;
                }
                case 3: {
                    value = this.theme.getMenuTextFont();
                    break;
                }
                case 4: {
                    value = this.theme.getWindowTitleFont();
                    break;
                }
                case 5: {
                    value = this.theme.getSubTextFont();
                }
            }
            return value;
        }
    }
}

