/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.AbstractFractionNumberFormField;
import org.tentackle.swing.SwingSwingBundle;

public class DoubleFormField
extends AbstractFractionNumberFormField {
    private double minValue = -1.7976931348623157E308;
    private double maxValue = Double.MAX_VALUE;

    public DoubleFormField(Document doc, int columns) {
        super(doc, columns);
        this.decimalFormat.applyPattern(FormatHelper.getFloatingNumberPattern());
    }

    public DoubleFormField(int columns) {
        this((Document)null, columns);
    }

    public DoubleFormField() {
        this(0);
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Double getFormValue() {
        String str = this.getText();
        if (str == null || (str = str.replace(this.getFiller(), ' ').trim()).length() <= 0) return null;
        try {
            Number value = this.decimalFormat.parse(str);
            if (value instanceof Long) {
                value = ((Long)value).doubleValue();
            }
            if (value instanceof Double) {
                if ((Double)value > this.maxValue) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.maxValue);
                    return null;
                } else {
                    if (!((Double)value < this.minValue)) return (Double)value;
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.minValue);
                }
                return null;
            } else {
                this.errorOffset = 0;
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
            }
            return null;
        }
        catch (ParseException e) {
            this.errorOffset = e.getErrorOffset();
            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
        }
        return null;
    }

    public double getDoubleValue() {
        Double value = this.getFormValue();
        return value == null ? 0.0 : value;
    }

    public void setDoubleValue(double value) {
        this.setFormValue(value);
    }
}

