/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Locale;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormCalendar;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormCalendarDialog
extends FormDialog {
    private Date day;
    private FormPanel buttonPanel;
    private FormCalendar calendar;
    private FormButton cancelButton;
    private FormButton okButton;

    public static FormCalendarDialog createFormCalendarDialog(Component comp, Locale locale, Date day, int timeMode) {
        return new FormCalendarDialog(FormUtilities.getInstance().getParentWindow(comp), locale, day, timeMode);
    }

    public FormCalendarDialog(Window owner, Locale locale, Date day, int timeMode) {
        super(owner);
        this.initComponents();
        this.calendar.setup(locale, day, timeMode);
        this.calendar.addActionListener(e -> this.okButton.doClick());
    }

    public FormCalendarDialog(Window owner, int timeMode) {
        this(owner, null, null, timeMode);
    }

    public FormCalendarDialog() {
        this(null, 0);
    }

    public Date showDialog() {
        this.pack();
        this.day = null;
        this.setVisible(true);
        return this.day;
    }

    private void initComponents() {
        this.buttonPanel = new FormPanel();
        this.okButton = new FormButton();
        this.cancelButton = new FormButton();
        this.calendar = new FormCalendar();
        this.setAutoPosition(true);
        this.setModal(true);
        this.okButton.setIcon(PlafUtilities.getInstance().getIcon("ok"));
        this.okButton.setMargin(new Insets(1, 4, 1, 4));
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormCalendarDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setIcon(PlafUtilities.getInstance().getIcon("cancel"));
        this.cancelButton.setMargin(new Insets(1, 4, 1, 4));
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormCalendarDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.getContentPane().add((Component)this.calendar, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.day = this.calendar.getCalendar().getTime();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

