/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.AbstractFormField;
import org.tentackle.swing.FocusTraversalGroup;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComboBox;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.FormWrapEvent;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.PropertyGroup;
import org.tentackle.swing.TooltipDisplay;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.bind.FormComponentBinding;

public class FormComboBox<E>
extends JComboBox<E>
implements FormComponent,
FocusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormComboBox.class);
    private static final long DEFAULT_LEADKEY_TIMEOUT = 1000L;
    private String helpURL;
    private FormWindow formWrapWindow;
    private boolean valueEnteredOnSelect;
    private boolean allowDeselect = true;
    private boolean autoUpdate = true;
    private Window parentWindow;
    private TooltipDisplay tooltipDisplay;
    private Object lastActionItem;
    private boolean actionFired;
    private boolean fireRunning;
    private String savedValue;
    private int leadMatchLen;
    private ListCellRenderer<E> popupRenderer;
    private boolean shortLongPopup;
    private KeyEvent lastKeyEvent;
    private boolean transferFocusDone;
    private boolean transferFocusBackwardDone;
    private boolean valueChangedTriggered;
    private boolean triggerValueChangedEnabled = true;
    private boolean valueAdjusting;
    private boolean transferFocusByEnter;
    private boolean focusGainedFromTransfer;
    private boolean focusGainedFromTransferBackward;
    private boolean formTraversable = true;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean allChangeable = true;
    private boolean bindable = true;
    private String componentPath;
    private String bindingPath;
    private FormComponentBinding binding;
    private boolean smartValueEntered = true;
    private Object oldValueShown;
    private boolean mandatory;
    private long leadKeyTimeout = 1000L;
    private FocusTraversalGroup focusTraversalGroup;
    private PropertyGroup propertyGroup;
    private static final String TABLECELLEDITOR_PROPERTY = "JComboBox.isTableCellEditor";

    public FormComboBox(ComboBoxModel<E> model) {
        super(model);
        this.setup();
    }

    public FormComboBox(E[] items) {
        super(items);
        this.setup();
    }

    public FormComboBox() {
        this.setup();
    }

    private void setup() {
        FormUtilities.getInstance().setupDefaultBindings(this);
        if (!this.isEditable()) {
            this.addFocusListener(this);
        }
    }

    @Override
    public void showErrorPopup(String message) {
        FormUtilities.getInstance().showErrorPopup(this, message);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            this.lastKeyEvent = e;
            boolean isTableCellEditor = this.isCellEditorUsage();
            if (!this.isEditable()) {
                if (isTableCellEditor) {
                    if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        e.consume();
                        return;
                    }
                } else if (!this.isPopupVisible() && e.getModifiers() == 0) {
                    if (e.getKeyCode() == 38) {
                        e.consume();
                        this.transferFocusBackward();
                        return;
                    }
                    if (e.getKeyCode() == 40) {
                        e.consume();
                        this.transferFocus();
                        return;
                    }
                }
                if (this.allowDeselect && (e.getKeyCode() == 8 || e.getKeyCode() == 127)) {
                    this.setSelectedIndex(-1);
                    this.clearMultiKeyLeadString();
                    e.consume();
                }
                if (e.getKeyCode() == 90 && e.getModifiers() == 2) {
                    this.setFormValueText(this.savedValue);
                }
            }
            if (!this.isPopupVisible()) {
                if (e.getKeyCode() == 114 || (e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 10 && e.isControlDown() || e.getKeyCode() == 32) && (isTableCellEditor || e.isControlDown())) {
                    this.showPopup();
                    e.consume();
                }
            } else if (isTableCellEditor && e.getModifiers() == 0) {
                if (e.getKeyCode() == 38) {
                    int index = this.getSelectedIndex();
                    if (index > 0) {
                        this.setFormValueIndex(index - 1);
                    }
                    return;
                }
                if (e.getKeyCode() == 40) {
                    int index = this.getSelectedIndex();
                    if (index < this.getItemCount() - 1) {
                        this.setFormValueIndex(index + 1);
                    }
                    return;
                }
            }
        }
        super.processKeyEvent(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    protected void fireActionEvent() {
        if (!this.valueAdjusting) {
            if (this.valueEnteredOnSelect) {
                if (this.isCellEditorUsage()) {
                    this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 10, '\uffff'));
                } else {
                    if (this.isAutoUpdate()) {
                        this.fireValueEntered();
                        FormUtilities.getInstance().doValidate(this);
                    }
                    this.lastActionItem = this.getSelectedItem();
                    this.actionFired = true;
                }
            } else {
                super.fireActionEvent();
            }
        }
    }

    @Override
    public void setEditable(boolean editable) {
        boolean changed = editable != this.isEditable();
        super.setEditable(editable);
        if (changed) {
            if (editable) {
                this.removeFocusListener(this);
                if (this.editor != null && this.editor.getEditorComponent() instanceof AbstractFormField) {
                    this.editor.getEditorComponent().addFocusListener(this);
                }
            } else {
                this.addFocusListener(this);
                if (this.editor != null && this.editor.getEditorComponent() instanceof AbstractFormField) {
                    this.editor.getEditorComponent().removeFocusListener(this);
                }
            }
        }
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.autoUpdate = autoupdate;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean setFormValueText(String text) {
        if (text != null && text.length() > 0) {
            int count = this.getItemCount();
            for (int i = 0; i < count; ++i) {
                String itemString;
                Object item = this.getItemAt(i);
                if (item == null || text.compareTo(itemString = item.toString()) != 0) continue;
                this.setFormValueIndex(i);
                return true;
            }
        }
        boolean oldValueAdjusting = this.valueAdjusting;
        this.valueAdjusting = true;
        this.setSelectedIndex(-1);
        this.valueAdjusting = oldValueAdjusting;
        return false;
    }

    public String getFormValueText() {
        E obj = this.getFormValue();
        return obj == null ? null : obj.toString();
    }

    public void setFormValueIndex(int index) {
        boolean oldValueAdjusting = this.valueAdjusting;
        this.valueAdjusting = true;
        this.actionFired = false;
        this.setSelectedIndex(index);
        this.clearMultiKeyLeadString();
        this.valueAdjusting = oldValueAdjusting;
    }

    public void addAllItems(E[] items) {
        if (items != null) {
            for (E item : items) {
                this.addItem(item);
            }
        }
    }

    public void addAllItems(Collection<E> items) {
        if (items != null) {
            for (E item : items) {
                this.addItem(item);
            }
        }
    }

    public void setAllItems(E[] items) {
        this.removeAllItems();
        this.addAllItems(items);
    }

    public void setAllItems(Collection<E> items) {
        this.removeAllItems();
        this.addAllItems(items);
    }

    public Object[] getAllItems() {
        int count = this.getItemCount();
        Object[] items = new Object[count];
        for (int i = 0; i < count; ++i) {
            items[i] = this.getItemAt(i);
        }
        return items;
    }

    @Override
    public void removeAllItems() {
        boolean oldValueAdjusting = this.valueAdjusting;
        this.valueAdjusting = true;
        super.removeAllItems();
        this.valueAdjusting = oldValueAdjusting;
    }

    @Override
    public void addItem(E item) {
        boolean oldValueAdjusting = this.valueAdjusting;
        this.valueAdjusting = true;
        super.addItem(item);
        this.valueAdjusting = oldValueAdjusting;
    }

    public void setValueEnteredOnSelect(boolean flag) {
        this.valueEnteredOnSelect = flag;
    }

    public boolean isValueEnteredOnSelect() {
        return this.valueEnteredOnSelect;
    }

    public void setValueAdjusting(boolean flag) {
        this.valueAdjusting = flag;
    }

    public boolean isValueAdjusting() {
        return this.valueAdjusting;
    }

    public boolean selectWithLeadString(String lead) {
        int index = this.getItemIndexWithLeadString(lead, this.getModel());
        this.setSelectedIndex(index);
        return index >= 0;
    }

    public int getItemIndexWithLeadString(String lead, ComboBoxModel<E> model) {
        int leadLen;
        int matchIndex = -1;
        this.leadMatchLen = 0;
        if (lead != null && (leadLen = (lead = lead.toLowerCase()).length()) > 0) {
            int items = this.getItemCount();
            for (int itemIndex = 0; itemIndex < items; ++itemIndex) {
                int charPos;
                String itemText;
                Object item = model.getElementAt(itemIndex);
                String string = itemText = item == null ? null : item.toString().toLowerCase();
                if (itemText == null) continue;
                int itemLen = itemText.length();
                for (charPos = 0; charPos < itemLen && charPos < leadLen && itemText.charAt(charPos) == lead.charAt(charPos); ++charPos) {
                }
                if (charPos <= this.leadMatchLen) continue;
                matchIndex = itemIndex;
                this.leadMatchLen = charPos;
            }
        }
        return matchIndex;
    }

    public void setMultiKeySelectionManager(boolean flag) {
        if (flag) {
            this.setKeySelectionManager(new MultiKeySelectionManager());
        } else {
            this.setKeySelectionManager(this.createDefaultKeySelectionManager());
        }
    }

    public boolean isMultiKeySelectionManager() {
        return this.getKeySelectionManager() instanceof MultiKeySelectionManager;
    }

    public long getLeadKeyTimeout() {
        return this.leadKeyTimeout;
    }

    public void setLeadKeyTimeout(long leadKeyTimeout) {
        this.leadKeyTimeout = leadKeyTimeout;
    }

    public boolean isAllowDeselect() {
        return this.allowDeselect;
    }

    public void setAllowDeselect(boolean allowDeselect) {
        this.allowDeselect = allowDeselect;
    }

    public void setPopupRenderer(ListCellRenderer<E> aRenderer) {
        ListCellRenderer<E> oldRenderer = this.popupRenderer;
        this.popupRenderer = aRenderer;
        this.firePropertyChange("popupRenderer", oldRenderer, this.popupRenderer);
        this.invalidate();
    }

    public ListCellRenderer<E> getPopupRenderer() {
        return this.popupRenderer;
    }

    public void setShortLongPopupEnabled(boolean flag) {
        boolean oldFlag = this.shortLongPopup;
        this.shortLongPopup = flag;
        this.firePropertyChange("shortLongPopup", oldFlag, this.shortLongPopup);
        this.invalidate();
    }

    public boolean isShortLongPopupEnabled() {
        return this.shortLongPopup;
    }

    @Override
    public Object getValueShown() {
        return super.getSelectedItem();
    }

    @Override
    public boolean isValueShownModified() {
        return !Objects.equals(this.oldValueShown, this.getValueShown());
    }

    @Override
    public void clearValueShownModified() {
        this.oldValueShown = this.getValueShown();
    }

    private void clearMultiKeyLeadString() {
        JComboBox.KeySelectionManager km = this.getKeySelectionManager();
        if (km instanceof MultiKeySelectionManager) {
            ((MultiKeySelectionManager)km).clearLeadChars();
        }
    }

    private void setValueInEditorField(Object item) {
        Component c = this.getEditor().getEditorComponent();
        if (c instanceof AbstractFormField) {
            ((AbstractFormField)c).setFormValue(item);
        } else if (c instanceof JTextField) {
            ((JTextField)c).setText(item == null ? null : item.toString());
        }
    }

    private String getVisibleText() {
        Component c;
        if (this.isEditable() && (c = this.getEditor().getEditorComponent()) instanceof JTextField) {
            return ((JTextField)c).getText();
        }
        Object obj = super.getSelectedItem();
        return obj != null ? obj.toString() : null;
    }

    private TooltipDisplay getTooltipDisplay() {
        Window w;
        if (this.tooltipDisplay == null && (w = this.getParentWindow()) instanceof FormWindow) {
            this.tooltipDisplay = ((FormWindow)((Object)w)).getTooltipDisplay();
        }
        return this.tooltipDisplay;
    }

    private void showTooltip(String text) {
        TooltipDisplay td = this.getTooltipDisplay();
        if (td != null) {
            td.setTooltip(text);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            Component opposite = e.getOppositeComponent();
            boolean wasEnter = false;
            if (opposite instanceof FormComponent) {
                this.focusGainedFromTransfer = ((FormComponent)((Object)opposite)).wasTransferFocus();
                this.focusGainedFromTransferBackward = ((FormComponent)((Object)opposite)).wasTransferFocusBackward();
                wasEnter = ((FormComponent)((Object)opposite)).wasTransferFocusByEnter();
            }
            this.transferFocusDone = false;
            this.transferFocusBackwardDone = false;
            this.transferFocusByEnter = false;
            if (this.isAutoUpdate()) {
                this.fireValueChanged();
            }
            this.formWrapWindow = null;
            this.showTooltip(super.getToolTipText());
            if (this.isEditable() && this instanceof FormFieldComboBox) {
                AbstractFormField field = ((FormFieldComboBox)this).getEditorField();
                if (field.isStartEditLeftmost() || wasEnter || this.focusGainedFromTransferBackward) {
                    field.setCaretLeft();
                } else if (this.focusGainedFromTransfer) {
                    field.setCaretRight();
                }
            }
            this.oldValueShown = this.getValueShown();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            boolean bl = this.transferFocusByEnter = !(this.lastKeyEvent == null || this.lastKeyEvent.getKeyCode() != 10 && this.lastKeyEvent.getKeyCode() != 9 || this.lastKeyEvent.getModifiers() != 0 && this.lastKeyEvent.getModifiers() != 1);
            if (this.isChangeable() && this.isAutoUpdate()) {
                if (this.isCellEditorUsage() || !this.isSmartValueEntered() || this.isValueShownModified()) {
                    this.fireValueEntered();
                }
                FormUtilities.getInstance().doValidate(this);
            }
            if (this.formWrapWindow != null) {
                this.formWrapWindow.fireFormWrappedFocus(new FormWrapEvent(this));
                this.formWrapWindow = null;
            }
            this.showTooltip(null);
            this.lastKeyEvent = null;
        }
    }

    @Override
    public void requestFocusLater() {
        FormUtilities.getInstance().requestFocusLater(this);
    }

    @Override
    public synchronized void addValueListener(ValueListener listener) {
        this.listenerList.add(ValueListener.class, listener);
    }

    @Override
    public synchronized void removeValueListener(ValueListener listener) {
        this.listenerList.remove(ValueListener.class, listener);
    }

    @Override
    public void fireValueChanged() {
        FormUtilities.getInstance().doFireValueChanged(this, this.listenerList.getListenerList());
        this.valueChangedTriggered = false;
    }

    @Override
    public void fireValueEntered() {
        if (!this.actionFired || this.lastActionItem != this.getSelectedItem()) {
            this.valueChangedTriggered = false;
            FormUtilities.getInstance().doFireValueEntered(this, this.listenerList.getListenerList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFormValue(Object item) {
        boolean oldValueAdjusting = this.valueAdjusting;
        this.actionFired = false;
        try {
            this.valueAdjusting = true;
            if (item != null) {
                for (int i = 0; i < this.getItemCount(); ++i) {
                    if (!item.equals(this.getItemAt(i))) continue;
                    this.setSelectedIndex(i);
                    return;
                }
                if (item instanceof String && this.setFormValueText((String)item)) {
                    return;
                }
                if (this.isEditable()) {
                    if (this.setFormValueText(item.toString())) {
                        return;
                    }
                    this.setValueInEditorField(item);
                    return;
                }
            }
            this.setSelectedIndex(-1);
            if (this.isEditable()) {
                this.setValueInEditorField(null);
            }
        }
        finally {
            this.valueAdjusting = oldValueAdjusting;
            this.clearMultiKeyLeadString();
        }
    }

    public E getFormValue() {
        if (this.isEditable()) {
            Component c = this.getEditor().getEditorComponent();
            if (c instanceof AbstractFormField) {
                return (E)((AbstractFormField)c).getFormValue();
            }
            if (c instanceof JTextField) {
                return (E)((JTextField)c).getText();
            }
        }
        return (E)this.getSelectedItem();
    }

    @Override
    public void saveValue() {
        this.savedValue = this.getVisibleText();
        this.valueChangedTriggered = false;
    }

    @Override
    public boolean isValueChanged() {
        String value = this.getVisibleText();
        if (this.savedValue == null) {
            return value != null;
        }
        return value == null || !value.equals(this.savedValue);
    }

    @Override
    public void setTriggerValueChangedEnabled(boolean enabled) {
        this.triggerValueChangedEnabled = enabled;
    }

    @Override
    public boolean isTriggerValueChangedEnabled() {
        return this.triggerValueChangedEnabled;
    }

    @Override
    public void triggerValueChanged() {
        if (this.triggerValueChangedEnabled && !this.valueChangedTriggered && !this.fireRunning) {
            FormUtilities.getInstance().triggerValueChanged(this);
            this.valueChangedTriggered = true;
        }
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.isHonourChangeable()) {
            this.changeable = changeable;
            super.setEnabled(changeable && this.allChangeable);
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable && this.allChangeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void updateAllChangeable(boolean allChangeable) {
        if (this.allChangeable != allChangeable) {
            this.allChangeable = allChangeable;
            this.setChangeable(this.changeable);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.changeable = enabled;
    }

    @Override
    public void setFireRunning(boolean running) {
        this.fireRunning = running;
    }

    @Override
    public boolean isFireRunning() {
        return this.fireRunning;
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        this.putClientProperty(TABLECELLEDITOR_PROPERTY, flag);
    }

    @Override
    public boolean isCellEditorUsage() {
        try {
            Object obj = this.getClientProperty(TABLECELLEDITOR_PROPERTY);
            if (obj != null) {
                return (Boolean)obj;
            }
        }
        catch (Exception ex) {
            LOGGER.severe("FormComboBox: isTableCellEditor not Boolean! " + ex, new Object[0]);
        }
        return false;
    }

    @Override
    public void prepareFocusLost() {
    }

    @Override
    public void setFormWrapWindow(FormWindow parent) {
        this.formWrapWindow = parent;
    }

    @Override
    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    @Override
    public void showHelp() {
        FormUtilities.getInstance().openHelpURL(this);
    }

    @Override
    public Window getParentWindow() {
        if (this.parentWindow == null) {
            this.parentWindow = FormUtilities.getInstance().getParentWindow(this);
        }
        return this.parentWindow;
    }

    @Override
    public void invalidateParentInfo() {
        this.parentWindow = null;
        this.tooltipDisplay = null;
    }

    @Override
    public String getToolTipText() {
        return this.getTooltipDisplay() == null ? super.getToolTipText() : null;
    }

    @Override
    public void transferFocus() {
        this.transferFocusDone = true;
        super.transferFocus();
    }

    @Override
    public void transferFocusBackward() {
        this.transferFocusBackwardDone = true;
        super.transferFocusBackward();
    }

    @Override
    public boolean wasTransferFocus() {
        return this.transferFocusDone;
    }

    @Override
    public boolean wasTransferFocusBackward() {
        return this.transferFocusBackwardDone;
    }

    @Override
    public boolean wasFocusGainedFromTransfer() {
        return this.focusGainedFromTransfer;
    }

    @Override
    public boolean wasFocusGainedFromTransferBackward() {
        return this.focusGainedFromTransferBackward;
    }

    @Override
    public boolean wasTransferFocusByEnter() {
        return this.transferFocusByEnter;
    }

    @Override
    public void setFormTraversable(boolean formTraversable) {
        this.formTraversable = formTraversable;
    }

    @Override
    public boolean isFormTraversable() {
        return this.formTraversable;
    }

    @Override
    public void setFocusTraversalGroup(FocusTraversalGroup group) {
        if (this.focusTraversalGroup != group) {
            if (this.focusTraversalGroup != null) {
                if (this.focusTraversalGroup.removeComponent(this)) {
                    this.focusTraversalGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in focus travseral group " + this.focusTraversalGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.focusTraversalGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in focus travseral group " + group);
                }
            }
        }
    }

    @Override
    public FocusTraversalGroup getFocusTraversalGroup() {
        return this.focusTraversalGroup;
    }

    @Override
    public void setPropertyGroup(PropertyGroup group) {
        if (this.propertyGroup != group) {
            if (this.propertyGroup != null) {
                if (this.propertyGroup.removeComponent(this)) {
                    this.propertyGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in property group " + this.propertyGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.propertyGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in property group " + group);
                }
            }
        }
    }

    @Override
    public PropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.mandatory != mandatory) {
            boolean oldValue = this.mandatory;
            this.mandatory = mandatory;
            this.firePropertyChange("mandatory", oldValue, mandatory);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    @Override
    public String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    @Override
    public String getBindingPath() {
        return this.bindingPath;
    }

    @Override
    public void setBinding(FormComponentBinding binding) {
        this.binding = binding;
    }

    @Override
    public FormComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public void setSmartValueEntered(boolean smartValueEntered) {
        this.smartValueEntered = smartValueEntered;
    }

    @Override
    public boolean isSmartValueEntered() {
        return this.smartValueEntered;
    }

    public class MultiKeySelectionManager<E>
    implements JComboBox.KeySelectionManager {
        private final StringBuilder leadChars = new StringBuilder();
        private long lastTime;

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            long now = System.currentTimeMillis();
            if (now - this.lastTime > FormComboBox.this.leadKeyTimeout) {
                this.clearLeadChars();
            }
            this.leadChars.append(aKey);
            this.lastTime = now;
            int index = FormComboBox.this.getItemIndexWithLeadString(this.leadChars.toString(), aModel);
            if (index >= 0) {
                if (FormComboBox.this.leadMatchLen > 0) {
                    this.leadChars.setLength(FormComboBox.this.leadMatchLen);
                } else {
                    this.clearLeadChars();
                }
            }
            return index;
        }

        public void clearLeadChars() {
            this.leadChars.setLength(0);
            this.lastTime = 0L;
        }
    }
}

