/**
 * Tentackle - http://www.tentackle.org
 * Copyright (C) 2001-2008 Harald Krake, harald@krake.de, +49 7722 9508-0
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.swing;

import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import org.tentackle.swing.plaf.PlafUtilities;


/**
 * Form field to edit a URL.
 * <p>
 * A button press opens the browser to the given URL.
 *
 * @author harald
 */
@SuppressWarnings("serial")
public class FormUrlField extends FormFieldComponentPanel {

  /**
   * Creates a form url field.
   */
  public FormUrlField() {
    initComponents();
    super.setFormComponent(urlField);
  }


  @Override
  public void setFormComponent(FormComponent comp) {
    throw new IllegalAccessError("changing the component is not allowed");
  }


  /**
   * {@inheritDoc}
   * <p>
   * Overridden to set the names in subcomponents.
   */
  @Override
  public void setName(String name) {
    super.setName(name);
    if (name != null) {
      ((Component) getFormComponent()).setName(name + "/url");
      urlButton.setName(name + "/open");
    }
    else  {
      ((Component) getFormComponent()).setName("url");
      urlButton.setName("open");
    }
  }


  @Override
  public void setCellEditorUsage(boolean flag) {
    super.setCellEditorUsage(flag);
    /**
     * disable focus lost on datefield when used as a celleditor
     */
    urlButton.setFocusable(!flag);
  }


  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    urlField = new org.tentackle.swing.StringFormField();
    urlButton = new org.tentackle.swing.FormButton();

    setLayout(new java.awt.GridBagLayout());

    urlField.setName("url"); // NOI18N
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 1);
    add(urlField, gridBagConstraints);

    urlButton.setIcon(PlafUtilities.getInstance().getIcon("url"));
    urlButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
    urlButton.setName("open"); // NOI18N
    urlButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        urlButtonActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
    add(urlButton, gridBagConstraints);
  }// </editor-fold>//GEN-END:initComponents

  private void urlButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_urlButtonActionPerformed
    if (getText() != null && !getText().isEmpty())  {
      try {
        // startet den Mailer
        String url = getText();
        if (!url.contains("://")) {
          url = "http://" + url;
        }
        Desktop.getDesktop().browse(URI.create(url));
      }
      catch (IOException ex) {
        FormError.showException("Can't open URL '" + getText() + "'", ex);
      }
    }
  }//GEN-LAST:event_urlButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private org.tentackle.swing.FormButton urlButton;
  private org.tentackle.swing.StringFormField urlField;
  // End of variables declaration//GEN-END:variables

}
