/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import org.tentackle.swing.AbstractFractionNumberFormField;
import org.tentackle.swing.AbstractNumberFormField;
import org.tentackle.swing.FormComponentCellEditor;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.StringFormField;

public class FormFieldComponentCellEditor
extends FormComponentCellEditor {
    private String defaultFormat;
    private int defaultHorizontalAlignment;
    private int defaultVerticalAlignment;

    public FormFieldComponentCellEditor(FormFieldComponent editorComponent) {
        this.setEditorComponent(editorComponent);
    }

    public FormFieldComponentCellEditor() {
        this(new StringFormField());
    }

    public void setEditorComponent(FormFieldComponent editor) {
        super.setEditorComponent(editor);
        this.defaultFormat = editor.getFormat();
        this.defaultHorizontalAlignment = editor.getHorizontalAlignment();
        this.defaultVerticalAlignment = 0;
        if (editor instanceof FormTextArea) {
            this.setAutoRowHeight(true);
            ((FormTextArea)editor).setLineWrap(true);
            ((FormTextArea)editor).setWrapStyleWord(true);
        }
    }

    @Override
    public FormFieldComponent getEditorComponent() {
        return (FormFieldComponent)this.editor;
    }

    protected void prepareTableCellEditorComponent(FormTable table, boolean selected, int row, int column) {
        FormFieldComponent editorComponent = this.getEditorComponent();
        if (table != null) {
            Integer scale;
            int modelColumn = table.convertColumnIndexToModel(column);
            String format = table.getFormat(modelColumn);
            if (format != null) {
                editorComponent.setFormat(format);
            } else {
                editorComponent.setFormat(this.defaultFormat);
            }
            int alignment = table.getHorizontalAlignment(modelColumn);
            if (alignment != -1) {
                editorComponent.setHorizontalAlignment(alignment);
            } else {
                editorComponent.setHorizontalAlignment(this.defaultHorizontalAlignment);
            }
            alignment = table.getVerticalAlignment(modelColumn);
            if (alignment != -1) {
                editorComponent.setVerticalAlignment(alignment);
            } else {
                editorComponent.setVerticalAlignment(this.defaultVerticalAlignment);
            }
            Integer maxColumns = table.getMaxColumn(modelColumn);
            if (maxColumns != null) {
                editorComponent.setMaxColumns(maxColumns);
            }
            if ((scale = table.getScale(modelColumn)) != null && editorComponent instanceof AbstractFractionNumberFormField) {
                ((AbstractFractionNumberFormField)editorComponent).setScale(scale);
            }
            editorComponent.setAdjust(table.getAdjust(modelColumn));
            editorComponent.setAutoSelect(table.isAutoSelect(modelColumn));
            editorComponent.setConvert(table.getConvert(modelColumn));
            if (editorComponent instanceof AbstractNumberFormField) {
                ((AbstractNumberFormField)editorComponent).setBlankZero(table.isBlankZero(modelColumn));
            }
            if (editorComponent.isAutoSelect()) {
                editorComponent.setEraseFirst(true);
            } else {
                editorComponent.setEraseFirst(false);
            }
        }
        editorComponent.setCaretPosition(0);
        super.prepareTableCellEditorComponent(table, selected, row, column);
    }
}

