/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormUrlField
extends FormFieldComponentPanel {
    private FormButton urlButton;
    private StringFormField urlField;

    public FormUrlField() {
        this.initComponents();
        super.setFormComponent(this.urlField);
    }

    @Override
    public void setFormComponent(FormComponent comp) {
        throw new IllegalAccessError("changing the component is not allowed");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            ((Component)((Object)this.getFormComponent())).setName(name + "/url");
            this.urlButton.setName(name + "/open");
        } else {
            ((Component)((Object)this.getFormComponent())).setName("url");
            this.urlButton.setName("open");
        }
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.urlButton.setFocusable(!flag);
    }

    private void initComponents() {
        this.urlField = new StringFormField();
        this.urlButton = new FormButton();
        this.setLayout(new GridBagLayout());
        this.urlField.setName("url");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)this.urlField, gridBagConstraints);
        this.urlButton.setIcon(PlafUtilities.getInstance().getIcon("url"));
        this.urlButton.setMargin(new Insets(0, 0, 0, 0));
        this.urlButton.setName("open");
        this.urlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUrlField.this.urlButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.urlButton, gridBagConstraints);
    }

    private void urlButtonActionPerformed(ActionEvent evt) {
        if (this.getText() != null && !this.getText().isEmpty()) {
            try {
                String url = this.getText();
                if (!url.contains("://")) {
                    url = "http://" + url;
                }
                Desktop.getDesktop().browse(URI.create(url));
            }
            catch (IOException ex) {
                FormError.showException("Can't open URL '" + this.getText() + "'", ex);
            }
        }
    }
}

