/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.WorkerThread;
import org.tentackle.swing.plaf.PlafUtilities;

public class WorkerDialog
extends FormDialog {
    private final WorkerThread workerThread;
    private boolean cancelAllowed;
    private FormButton cancelButton;
    private JProgressBar progressBar;
    private JLabel titleLabel;

    public WorkerDialog(WorkerThread workerThread) {
        this.workerThread = workerThread;
        this.initComponents();
        this.setCancelAllowed(workerThread != null);
    }

    public WorkerDialog() {
        this((WorkerThread)null);
    }

    public void setCancelAllowed(boolean cancelAllowed) {
        this.cancelAllowed = cancelAllowed;
        this.cancelButton.setVisible(cancelAllowed);
    }

    public boolean isCancelAllowed() {
        return this.cancelAllowed;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgress(int n) {
        EventQueue.invokeLater(() -> {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setStringPainted(true);
            }
            this.progressBar.setValue(n);
        });
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.titleLabel.setText(title);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && (!this.cancelAllowed || this.terminateWorkerThread())) {
            return;
        }
        super.processWindowEvent(e);
    }

    private boolean terminateWorkerThread() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.cancelButton = new FormButton();
        this.titleLabel = new JLabel();
        this.setAutoPosition(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.progressBar.setIndeterminate(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setIcon(PlafUtilities.getInstance().getIcon("cancel"));
        this.cancelButton.setText(SwingSwingBundle.getString("CANCEL"));
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkerDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.cancelAllowed && !this.terminateWorkerThread()) {
            this.dispose();
        }
    }
}

