/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tentackle.misc.Toolkit;
import org.tentackle.swing.FormFieldComponent;

public class FormFieldComponentDocument
extends PlainDocument {
    private boolean eraseFirst;
    private final FormFieldComponent field;

    public FormFieldComponentDocument(FormFieldComponent field) {
        this.field = field;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.eraseFirst) {
            if (!this.field.isAutoSelect() || !this.field.hasFocus()) {
                super.remove(0, this.getLength());
                offs = 0;
                this.field.setInhibitAutoSelect(true);
            }
            this.eraseFirst = false;
        }
        if (this.field == null) {
            super.insertString(offs, str, a);
        } else {
            int i;
            boolean valid = true;
            char filler = this.field.getFiller();
            if (filler != ' ') {
                str = str.replace(' ', filler);
            }
            if (this.field.getValidChars() != null) {
                String vchars = this.field.getValidChars();
                for (i = 0; i < str.length(); ++i) {
                    if (str.charAt(i) == filler || vchars.indexOf(str.charAt(i)) >= 0) continue;
                    valid = false;
                    break;
                }
            }
            if (this.field.getInvalidChars() != null) {
                String ichars = this.field.getInvalidChars();
                for (i = 0; i < str.length(); ++i) {
                    if (ichars.indexOf(str.charAt(i)) < 0) continue;
                    valid = false;
                    break;
                }
            }
            switch (this.field.getConvert()) {
                case '^': {
                    str = str.toUpperCase();
                    break;
                }
                case 'v': {
                    str = str.toLowerCase();
                }
            }
            if (valid) {
                if (!this.field.isOverwrite()) {
                    int rlen;
                    int olen = this.getLength();
                    if (olen - offs < (rlen = str.length())) {
                        rlen = olen - offs;
                    }
                    if (rlen > 0) {
                        super.remove(offs, rlen);
                    }
                }
                super.insertString(offs, str, a);
            } else {
                Toolkit.beep();
            }
        }
    }

    void setEraseFirst(boolean erasefirst) {
        this.eraseFirst = erasefirst;
    }
}

