/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.swing.AbstractNumberFormField;
import org.tentackle.swing.SwingSwingBundle;

public class IntegerFormField
extends AbstractNumberFormField {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntegerFormField(Document doc, int columns) {
        super(doc, columns);
    }

    public IntegerFormField(int columns) {
        this((Document)null, columns);
    }

    public IntegerFormField() {
        this(0);
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Integer getFormValue() {
        String str = this.getText();
        if (str == null || (str = str.replace(this.getFiller(), ' ').trim()).length() <= 0) return null;
        try {
            Number value = this.decimalFormat.parse(str);
            if (value instanceof Long) {
                if ((Long)value > (long)this.maxValue) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.maxValue);
                    return null;
                } else {
                    if ((Long)value >= (long)this.minValue) return ((Long)value).intValue();
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.minValue);
                }
                return null;
            } else {
                this.errorOffset = 0;
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
            }
            return null;
        }
        catch (ParseException e) {
            this.errorOffset = e.getErrorOffset();
            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
        }
        return null;
    }

    public int getIntValue() {
        Integer value = this.getFormValue();
        return value == null ? 0 : value;
    }

    public void setIntValue(int value) {
        this.setFormValue(value);
    }
}

