/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultiLineToolTipUI
extends BasicToolTipUI {
    private static final MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    private static final int MARGIN = 2;

    protected MultiLineToolTipUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.getClientProperty("html") != null) {
            super.paint(g, c);
        } else {
            Font font = c.getFont();
            FontMetrics fontMetrics = c.getFontMetrics(font);
            int fontHeight = fontMetrics.getHeight();
            int fontAscent = fontMetrics.getAscent();
            g.setColor(c.getBackground());
            Dimension size = c.getSize();
            g.fillRect(0, 0, size.width, size.height);
            String tipText = ((JToolTip)c).getTipText();
            if (tipText != null) {
                g.setColor(c.getForeground());
                int y = 2 + fontAscent;
                StringTokenizer tokenizer = new StringTokenizer(tipText, "\n");
                int numberOfLines = tokenizer.countTokens();
                for (int i = 0; i < numberOfLines; ++i) {
                    g.drawString(tokenizer.nextToken(), 2, y);
                    y += fontHeight;
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getClientProperty("html") != null) {
            return super.getPreferredSize(c);
        }
        Font font = c.getFont();
        FontMetrics fontMetrics = c.getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(4, 4);
        }
        StringTokenizer tokenizer = new StringTokenizer(tipText, "\n");
        int numberOfLines = tokenizer.countTokens();
        int height = numberOfLines * fontHeight;
        int width = 0;
        for (int i = 0; i < numberOfLines; ++i) {
            int thisWidth = fontMetrics.stringWidth(tokenizer.nextToken());
            width = Math.max(width, thisWidth);
        }
        return new Dimension(width + 4, height + 4);
    }
}

