/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ApplicationException;
import org.tentackle.misc.Toolkit;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormError
extends FormDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormError.class);
    private Component messageComp;
    private JPanel buttonPanel;
    private JLabel iconLabel;
    private FormTextArea messageField;
    private JPanel messagePanel;
    private FormButton okButton;

    public FormError() {
        this.initComponents();
        this.messageComp = this.messagePanel;
    }

    public void showDialog(String message, String title, boolean enableClipboardOption) {
        if (enableClipboardOption) {
            this.copyToClipboard(title, message, null);
        }
        if (message != null) {
            this.messageField.setText(message);
            this.messageField.setSize(this.messageField.getOptimalSize());
        }
        if (title != null) {
            this.setTitle(title);
        }
        this.pack();
        Toolkit.beep();
        this.setVisible(true);
    }

    public void showDialog(String message, String title) {
        this.showDialog(message, title, false);
    }

    public void showDialog() {
        this.showDialog(null, null);
    }

    public void setMessageComponent(Component comp) {
        this.getContentPane().remove(this.messageComp);
        this.messageComp = comp;
        this.getContentPane().add(this.messageComp, "Center");
    }

    public Component getMessageComponent() {
        return this.messageComp;
    }

    protected void copyToClipboard(String errorTitle, String errorMessage, Throwable t) {
        try {
            String newLine = System.getProperty("line.separator");
            Clipboard clipboard = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
            StringWriter writer = new StringWriter();
            if (errorTitle != null) {
                writer.append(errorTitle).append(newLine);
            }
            if (errorMessage != null) {
                writer.append(errorMessage).append(newLine);
            }
            if (t != null) {
                StackTraceElement[] stArr;
                for (StackTraceElement element : stArr = t.getStackTrace()) {
                    writer.append(element.toString()).append(newLine);
                }
            }
            StringSelection clipboardData = new StringSelection(writer.toString());
            clipboard.setContents(clipboardData, clipboardData);
        }
        catch (HeadlessException e) {
            LOGGER.logStacktrace((Throwable)e);
        }
    }

    public static void show(String message, boolean abort, Logger logger, boolean enableClipboardOption) {
        if (message == null) {
            message = ReflectionHelper.getApplicationInvocationAsString();
        }
        if (logger != null) {
            if (abort) {
                logger.severe(message, new Object[0]);
            } else {
                logger.warning(message, new Object[0]);
            }
        }
        FormUtilities.getInstance().getEventQueue().dropKeyEvents();
        new FormError().showDialog(message, null, enableClipboardOption);
        if (abort) {
            FormError.abort(logger);
        }
    }

    public static void show(String message, boolean abort, Logger logger) {
        FormError.show(message, abort, logger, false);
    }

    public static void show(String message, boolean abort) {
        FormError.show(message, abort, LOGGER);
    }

    public static void show(String message) {
        FormError.show(message, false);
    }

    public static void showException(String message, Throwable ex, boolean abort, Logger logger) {
        if (message == null) {
            message = ReflectionHelper.getApplicationInvocationAsString();
        }
        String extraMsg = null;
        if (ex instanceof ApplicationException) {
            extraMsg = ((ApplicationException)ex).getAllMessages();
        } else if (ex != null) {
            extraMsg = ex.getMessage();
        }
        if (extraMsg != null) {
            message = message + "\n" + extraMsg;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            FormError.show(message);
        }
        if (logger != null) {
            logger.log(abort ? Logger.Level.SEVERE : Logger.Level.WARNING, message, ex);
        }
        if (abort) {
            FormError.abort(logger);
        }
    }

    public static void showException(String message, Throwable ex, boolean abort) {
        FormError.showException(message, ex, abort, LOGGER);
    }

    public static void showException(String message, Throwable ex) {
        FormError.showException(message, ex, false);
    }

    public static void showException(Throwable ex, boolean abort) {
        FormError.showException(ex.getClass().getName(), ex, abort);
    }

    public static void showException(Throwable ex) {
        FormError.showException(ex, false);
    }

    private static void abort(Logger logger) {
        if (logger != null) {
            CharArrayWriter writer = new CharArrayWriter();
            new Exception("Application Aborted! Stacktrace:").printStackTrace(new PrintWriter(writer));
            logger.severe(writer.toString(), new Object[0]);
        }
        throw new GUIRuntimeException("FormError");
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.iconLabel = new JLabel();
        this.messageField = new FormTextArea();
        this.buttonPanel = new JPanel();
        this.okButton = new FormButton();
        this.setAutoPosition(true);
        this.setTitle(SwingSwingBundle.getString("ERROR"));
        this.setModal(true);
        this.messagePanel.setLayout(new GridBagLayout());
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setIcon(PlafUtilities.getInstance().getIcon("ErrorDialog"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.iconLabel, gridBagConstraints);
        this.messageField.setEditable(false);
        this.messageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageField.setLineWrap(true);
        this.messageField.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.messageField, gridBagConstraints);
        this.getContentPane().add((Component)this.messagePanel, "Center");
        this.okButton.setClickOnEnter(true);
        this.okButton.setFormTraversable(true);
        this.okButton.setIcon(PlafUtilities.getInstance().getIcon("ok"));
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormError.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

