/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.function.Function;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tentackle.misc.Toolkit;
import org.tentackle.swing.FormFieldComponent;

public class FormFieldDocument
extends PlainDocument {
    public static Function<String, String> defaultConverter;
    private Function<String, String> converter;
    private final FormFieldComponent field;
    private boolean eraseFirst;

    public FormFieldDocument(FormFieldComponent field) {
        this.field = field;
    }

    void setEraseFirst(boolean erasefirst) {
        this.eraseFirst = erasefirst;
    }

    public Function<String, String> getConverter() {
        return this.converter;
    }

    public void setConverter(Function<String, String> converter) {
        this.converter = converter;
    }

    public Function<String, String> getEffectiveConverter() {
        Function<String, String> effectiveConverter = this.getConverter();
        return effectiveConverter == null ? defaultConverter : effectiveConverter;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Function<String, String> effectiveConverter;
        if (this.eraseFirst) {
            if (!this.field.isAutoSelect() || !this.field.hasFocus()) {
                super.remove(0, this.getLength());
                offs = 0;
                this.field.setInhibitAutoSelect(true);
                this.field.triggerValueChanged();
            }
            this.eraseFirst = false;
        }
        if ((effectiveConverter = this.getEffectiveConverter()) != null) {
            str = effectiveConverter.apply(str);
        }
        if (this.field == null) {
            super.insertString(offs, str, a);
        } else if (str != null) {
            int i;
            boolean valid = true;
            int maxColumns = this.field.getMaxColumns();
            boolean override = this.field.isOverwrite();
            char filler = this.field.getFiller();
            if (maxColumns > 0 && override && offs + str.length() > maxColumns) {
                valid = false;
            }
            if (filler != ' ') {
                str = str.replace(' ', filler);
            }
            switch (this.field.getConvert()) {
                case '^': {
                    str = str.toUpperCase();
                    break;
                }
                case 'v': {
                    str = str.toLowerCase();
                }
            }
            if (this.field.getValidChars() != null) {
                String vchars = this.field.getValidChars();
                for (i = 0; i < str.length(); ++i) {
                    if (str.charAt(i) == filler || vchars.indexOf(str.charAt(i)) >= 0) continue;
                    valid = false;
                    break;
                }
            }
            if (this.field.getInvalidChars() != null) {
                String ichars = this.field.getInvalidChars();
                for (i = 0; i < str.length(); ++i) {
                    if (ichars.indexOf(str.charAt(i)) < 0) continue;
                    valid = false;
                    break;
                }
            }
            if (valid) {
                if (this.field.isOverwrite()) {
                    int rlen;
                    int olen = this.getLength();
                    if (olen - offs < (rlen = str.length())) {
                        rlen = olen - offs;
                    }
                    if (rlen > 0) {
                        super.remove(offs, rlen);
                    }
                }
                super.insertString(offs, str, a);
                if (!override && maxColumns > 0 && this.getLength() > maxColumns) {
                    super.remove(maxColumns, this.getLength() - maxColumns);
                    Toolkit.beep();
                }
                if (maxColumns > 0 && this.field.isAutoNext() && this.field.getCaretPosition() >= maxColumns) {
                    this.field.transferFocus();
                }
                this.field.triggerValueChanged();
            } else {
                Toolkit.beep();
            }
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.field.triggerValueChanged();
    }
}

