/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.List;
import org.tentackle.swing.AbstractFormTableModel;
import org.tentackle.swing.BindableTableModel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.bind.FormTableBinder;
import org.tentackle.swing.bind.FormTableBinding;

public class FormTableModel<T>
extends AbstractFormTableModel<T>
implements BindableTableModel<T> {
    private FormTableEntry<T> template;
    private FormTableEntry<T>[] entries;
    private FormTableBinder binder;
    private List<T> list;
    private T[] array;

    public FormTableModel(FormTableEntry<T> template, List<T> list) {
        this.setTemplate(template);
        this.listChanged(list);
    }

    public FormTableModel(FormTableEntry<T> template, T[] array) {
        this.setTemplate(template);
        this.listChanged(array);
    }

    public FormTableModel(FormTableEntry<T> template) {
        this.setTemplate(template);
    }

    public void setTemplate(FormTableEntry<T> template) {
        if (template == null) {
            throw new IllegalArgumentException("template must not be null");
        }
        this.template = template;
        template.setModel(this);
    }

    protected FormTableBinder createBinder() {
        return FormUtilities.getInstance().getBindingFactory().createFormTableBinder(this);
    }

    @Override
    public FormTableBinder getBinder() {
        if (this.binder == null) {
            this.binder = this.createBinder();
        }
        return this.binder;
    }

    @Override
    public BindableTableModel.BindType getBindType() {
        return this.template.getBindType();
    }

    @Override
    public Class<?> getBindingRootClass() {
        return this.template.getClass();
    }

    public void bind() {
        BindableTableModel.BindType bindType = this.getBindType();
        if (bindType == BindableTableModel.BindType.BIND) {
            this.getBinder().bind();
        } else if (bindType == BindableTableModel.BindType.BINDALL) {
            this.getBinder().bindAllInherited();
        }
    }

    public String toString() {
        return this.template.getClass().getName();
    }

    @Override
    public FormTableEntry<T> getTemplate() {
        return this.template;
    }

    @Override
    public synchronized int getRowCount() {
        return this.entries == null ? 0 : this.entries.length;
    }

    @Override
    public int getColumnCount() {
        return this.template.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.template.getColumnName(columnIndex);
    }

    @Override
    public String getDisplayedColumnName(int columnIndex) {
        return this.template.getDisplayedColumnName(columnIndex);
    }

    @Override
    public FormTableBinding getBinding(int columnIndex) {
        return this.binder == null ? null : this.binder.getBinding(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FormTableEntry<T> entry = this.getEntryAt(rowIndex);
        if (entry == null) {
            return null;
        }
        return entry.getValueAt(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        FormTableEntry<T> entry = this.getEntryAt(rowIndex);
        if (entry != null) {
            entry.setValueAt(columnIndex, aValue);
            this.setDataChanged(true);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public String getBindingPath(int mColumn) {
        return this.template.getBindingPath(mColumn);
    }

    @Override
    public void setDataChanged(boolean dataChanged) {
        FormTable<T> table;
        boolean wasChanged = this.isDataChanged();
        super.setDataChanged(dataChanged);
        if (!wasChanged && dataChanged && (table = this.getTable()) != null) {
            FormUtilities.getInstance().triggerValueChanged(table);
        }
    }

    @Override
    public FormTable<T> getTable() {
        AbstractFormTableModel model = this;
        FormTable table = super.getTable();
        while (table == null && (model = model.getMap()) != null) {
            table = model.getTable();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormTableEntry<T> getEntryAt(int row) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            if (this.entries[row] == null) {
                FormTableEntry<T> entry = null;
                if (this.list != null) {
                    entry = this.template.newInstance(this.list.get(row));
                } else if (this.array != null) {
                    entry = this.template.newInstance(this.array[row]);
                }
                if (entry != null) {
                    entry.setModel(this);
                    entry.setRow(row);
                    this.entries[row] = entry;
                }
            }
            return this.entries[row];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setEntryAt(FormTableEntry<T> entry, int row) {
        boolean rv = false;
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            if (row >= 0 && row < this.getRowCount()) {
                this.entries[row] = entry;
                if (this.list != null) {
                    rv = entry.updateList(row);
                } else if (this.array != null) {
                    rv = entry.updateArray(row);
                }
                if (rv) {
                    this.setDataChanged(true);
                    this.fireTableRowsUpdated(row, row);
                }
                return rv;
            }
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> colClass = this.template.getColumnClass(columnIndex);
        if (colClass != null) {
            return colClass;
        }
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object value;
            FormTableEntry<T> entry = this.getEntryAt(i);
            if (entry == null || (value = entry.getValueAt(columnIndex)) == null) continue;
            return value.getClass();
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        FormTableEntry<T> entry = this.getEntryAt(rowIndex);
        return entry != null && entry.isCellEditable(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(List<T> list) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            this.list = list;
            this.array = null;
            this.setDataChanged(false);
            this.entries = list == null ? null : new FormTableEntry[list.size()];
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(T[] array) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            this.array = array;
            this.list = null;
            this.setDataChanged(false);
            this.entries = array == null ? null : new FormTableEntry[array.length];
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listUpdated(int firstRow, int lastRow) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            if (firstRow < 0) {
                firstRow = 0;
            }
            if (lastRow < firstRow) {
                lastRow = firstRow;
            }
            if (lastRow >= this.entries.length) {
                lastRow = this.entries.length - 1;
            }
            if (lastRow >= firstRow) {
                for (int i = firstRow; i <= lastRow; ++i) {
                    this.entries[i] = null;
                }
                this.setDataChanged(true);
                this.fireTableRowsUpdated(firstRow, lastRow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listCellUpdated(int rowIndex, int columnIndex) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            if (rowIndex >= 0 && rowIndex < this.entries.length) {
                this.entries[rowIndex] = null;
                this.setDataChanged(true);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listInserted(int firstRow, int lastRow) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            int newSize = this.list.size();
            if (firstRow < 0) {
                firstRow = 0;
            }
            if (lastRow < firstRow) {
                lastRow = firstRow;
            }
            if (lastRow >= newSize) {
                lastRow = newSize - 1;
            }
            if (lastRow >= firstRow) {
                int i;
                FormTableEntry<T>[] oldEntries = this.entries;
                this.entries = new FormTableEntry[newSize];
                for (i = 0; i < firstRow; ++i) {
                    this.entries[i] = oldEntries[i];
                }
                while (i <= lastRow) {
                    this.entries[i] = null;
                    ++i;
                }
                int inserted = lastRow - firstRow + 1;
                while (i < this.entries.length) {
                    this.entries[i] = oldEntries[i - inserted];
                    ++i;
                }
                this.setDataChanged(true);
                this.fireTableRowsInserted(firstRow, lastRow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listDeleted(int firstRow, int lastRow) {
        FormTableModel formTableModel = this;
        synchronized (formTableModel) {
            if (firstRow < 0) {
                firstRow = 0;
            }
            if (lastRow < firstRow) {
                lastRow = firstRow;
            }
            if (lastRow >= this.entries.length) {
                lastRow = this.entries.length - 1;
            }
            if (lastRow >= firstRow) {
                int i;
                FormTableEntry<T>[] oldEntries = this.entries;
                this.entries = new FormTableEntry[this.list.size()];
                for (i = 0; i < firstRow; ++i) {
                    this.entries[i] = oldEntries[i];
                }
                int deleted = lastRow - firstRow + 1;
                while (i < this.entries.length) {
                    this.entries[i] = oldEntries[i + deleted];
                    ++i;
                }
                this.setDataChanged(true);
                this.fireTableRowsDeleted(firstRow, lastRow);
            }
        }
    }
}

