/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FormTree
extends JTree {
    public static final String CLICK_ACTION = "click";
    public static final String ENTER_ACTION = "enter";
    private int clicks;

    public FormTree() {
        this.setup();
    }

    public FormTree(TreeModel model) {
        super(model);
        this.setup();
    }

    public FormTree(TreeNode root) {
        super(root);
        this.setup();
    }

    public int getClickCount() {
        return this.clicks;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionPerformed(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                ((ActionListener)listeners[i + 1]).actionPerformed(evt);
            }
        }
    }

    private void setup() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FormTree.this.clicks = e.getClickCount();
                FormTree.this.doFireActionPerformed(FormTree.CLICK_ACTION);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FormTree.this.clicks = 2;
                    FormTree.this.doFireActionPerformed(FormTree.ENTER_ACTION);
                }
            }
        });
    }

    private void doFireActionPerformed(String actionCommand) {
        if (this.clicks == 2 && this.getSelectionCount() > 0) {
            this.fireActionPerformed(new ActionEvent(this, 1001, actionCommand));
        }
    }
}

