/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.Locale;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormSpinField;
import org.tentackle.swing.MonthComboBox;
import org.tentackle.swing.SpinEvent;
import org.tentackle.swing.SpinListener;

public class MonthSpinField
extends FormSpinField
implements SpinListener {
    private final MonthComboBox monthCombo;

    public MonthSpinField(Locale locale) {
        this.monthCombo = new MonthComboBox(locale);
        this.setFormComponent(this.monthCombo);
        this.addSpinListener(this);
    }

    public MonthSpinField() {
        this((Locale)null);
    }

    public void setMonth(int month) {
        this.monthCombo.setMonth(month);
    }

    public int getMonth() {
        return this.monthCombo.getMonth();
    }

    @Override
    public void increment(SpinEvent e, FormComponent c) {
        int index = this.monthCombo.getSelectedIndex() + 1;
        if (index > 11) {
            index = 0;
        }
        this.monthCombo.setMonth(index);
    }

    @Override
    public void decrement(SpinEvent e, FormComponent c) {
        int index = this.monthCombo.getSelectedIndex() - 1;
        if (index < 0) {
            index = 11;
        }
        this.monthCombo.setMonth(index);
    }
}

