/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.swing.AbstractNumberFormField;
import org.tentackle.swing.SwingSwingBundle;

public class ShortFormField
extends AbstractNumberFormField {
    private short minValue = Short.MIN_VALUE;
    private short maxValue = Short.MAX_VALUE;

    public ShortFormField(Document doc, int columns) {
        super(doc, columns);
    }

    public ShortFormField(int columns) {
        this((Document)null, columns);
    }

    public ShortFormField() {
        this(0);
    }

    public void setMinValue(short minValue) {
        this.minValue = minValue;
    }

    public short getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(short maxValue) {
        this.maxValue = maxValue;
    }

    public short getMaxValue() {
        return this.maxValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Short getFormValue() {
        String str = this.getText();
        if (str == null || (str = str.replace(this.getFiller(), ' ').trim()).length() <= 0) return null;
        try {
            Number value = this.decimalFormat.parse(str);
            if (value instanceof Long) {
                if ((Long)value > (long)this.maxValue) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.maxValue);
                    return null;
                } else {
                    if ((Long)value >= (long)this.minValue) return ((Long)value).shortValue();
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.minValue);
                }
                return null;
            } else {
                this.errorOffset = 0;
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
            }
            return null;
        }
        catch (ParseException e) {
            this.errorOffset = e.getErrorOffset();
            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
        }
        return null;
    }

    public short getShortValue() {
        Short value = this.getFormValue();
        return value == null ? (short)0 : value;
    }

    public void setShortValue(short value) {
        this.setFormValue(value);
    }
}

