/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.DecimalFormat;
import javax.swing.text.Document;
import org.tentackle.common.BMoney;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.AbstractFormField;

public abstract class AbstractNumberFormField
extends AbstractFormField {
    private static final String defValidChars = ".,-0123456789";
    private boolean unsigned;
    private boolean blankZero;
    protected DecimalFormat decimalFormat;

    public AbstractNumberFormField(Document doc, int columns) {
        super(doc, null, columns);
        this.setValidChars(defValidChars);
        this.setHorizontalAlignment(11);
        this.decimalFormat = new DecimalFormat(FormatHelper.getIntegerPattern());
    }

    public AbstractNumberFormField(int columns) {
        this((Document)null, columns);
    }

    public AbstractNumberFormField() {
        this(0);
    }

    @Override
    public void setFormat(String pattern) {
        this.setDecimalFormat(new DecimalFormat(pattern));
    }

    @Override
    public String getFormat() {
        return this.decimalFormat.toPattern();
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    @Override
    public void setFormValue(Object object) {
        super.setText(this.doFormat(object));
    }

    @Override
    public void setText(String text) {
    }

    @Override
    protected void restoreSavedValue() {
        super.setText(this.savedValue);
    }

    @Override
    public void clearText() {
        super.setText("");
    }

    @Override
    public String doFormat(Object object) {
        if (object != null) {
            if (this.blankZero && (object instanceof Double ? (Double)object == 0.0 : (object instanceof Float ? ((Float)object).floatValue() == 0.0f : (object instanceof BMoney ? ((BMoney)object).isZero() : object instanceof Number && ((Number)object).longValue() == 0L)))) {
                return "";
            }
            return this.decimalFormat.format(object);
        }
        return "";
    }

    public void setUnsigned(boolean unsigned) {
        String vchars;
        this.unsigned = unsigned;
        if (unsigned) {
            vchars = this.getValidChars().replace('-', this.getFiller());
        } else {
            vchars = this.getValidChars().replace(this.getFiller(), '-');
            if (!vchars.contains("-")) {
                vchars = vchars + "-";
            }
        }
        super.setValidChars(vchars);
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public void setValidChars(String validChars) {
        super.setValidChars(validChars);
        this.unsigned = validChars != null && validChars.indexOf(45) < 0;
    }

    public void setBlankZero(boolean blankZero) {
        this.blankZero = blankZero;
    }

    public boolean isBlankZero() {
        return this.blankZero;
    }
}

