/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.HashSet;
import java.util.Set;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.swing.GUISaveable;

public class GUIExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GUIExceptionHandler.class);
    private static boolean exitOnException = true;
    private static final Set<GUISaveable> SAVEABLES = new HashSet<GUISaveable>();
    private static final String HANDLER_KEY = "sun.awt.exception.handler";
    private static final String HANDLER_CLASS = "org.tentackle.swing.GUIExceptionHandler";

    public static void install(boolean override) {
        if (override || System.getProperty(HANDLER_KEY) == null) {
            System.setProperty(HANDLER_KEY, HANDLER_CLASS);
        }
    }

    public static void setExitOnException(boolean flag) {
        exitOnException = flag;
    }

    public static boolean isExitOnException() {
        return exitOnException;
    }

    public static void registerSaveable(GUISaveable saveable) {
        SAVEABLES.add(saveable);
    }

    public static void unregisterSaveable(GUISaveable saveable) {
        SAVEABLES.remove(saveable);
    }

    public static void runSaveState() {
        for (GUISaveable s : SAVEABLES) {
            s.saveState();
        }
    }

    public void handle(Throwable t) {
        try {
            LOGGER.severe("unhandled GUI exception", t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            GUIExceptionHandler.runSaveState();
        }
        catch (Exception ex) {
            LoggerOutputStream.logException((Exception)ex, (Logger)LOGGER);
        }
        if (exitOnException) {
            System.exit(1);
        }
    }
}

